(* constructors - Definition v3 page 4 *)

(*
$File: Common/Con.sml $
$Date: 1992/03/09 15:00:59 $
$Revision: 1.16 $
$Locker: birkedal $
*)

(*$Con: IDENT CON*)
functor Con(structure Ident: IDENT): CON = 
  struct
    type id     = Ident.id
    type longid = Ident.longid
    type strid  = Ident.strid

    datatype longcon = LONGCON of longid

    fun mk_longcon longid = (LONGCON longid)

    fun pr_longcon (LONGCON longid) = Ident.pr_longid longid

    datatype con = CON of Ident.id

    fun mk_con id = (CON id)

(* leszczyk#1.6 *)
    fun un_con (CON id) = id
(* end leszczyk#1.6 *)

    fun pr_con (CON id) = Ident.pr_id id

    fun decompose (LONGCON longid) =
      let
	val (strid_list, id) = Ident.decompose longid
      in
	(strid_list, CON id)
      end

    fun (CON id1) < (CON id2) = Ident.<(id1, id2)

    fun con_to_id (CON id) = id

    val con_REF = mk_con Ident.id_REF

    val con_TRUE = mk_con Ident.id_TRUE
    val con_FALSE = mk_con Ident.id_FALSE

    val con_NIL = mk_con Ident.id_NIL
    val con_CONS = mk_con Ident.id_CONS

    val bogus = mk_longcon Ident.bogus

    val mk_Con = mk_con o Ident.mk_Id
  end;
