(* Core Trace *)

(*
$File: Common/CORE_TRACE.sml $
$Date: 1995/12/11 21:24:17 $
$Revision: 1.0 $
$Locker: mikon $
*)

(*$CORE_TRACE*)

signature CORE_TRACE =
sig
    
    type Type and Env and Context and TyEnv and VarEnv and TyRea and TyVar 
(* mikon#1.37 *)
    and Substitution
(* end mikon#1.37 *)
(* mikon#1.39 *)
    and TyName
(* end mikon#1.39 *)

    datatype Trace = 
	TRACE of SchemeTrace Option * SimTrace Option

    and SimTrace = 
	TYPE of Type
      | ENV of Env
      | CONTEXTxTYPE of Context * Type
      | CONTEXTxENV of Context * Env
      | TYENV of TyEnv
      | VARENVxTYREA of VarEnv * TyRea
(* mikon#1.39 *)
      | CONTEXTxTYNAME of Context * TyName
(* end mikon#1.39 *)

    and SchemeTrace =
	SCHEME_C of Context
      | TYVARS of TyVar list
	
(* mikon#1.37 *)
    val process_core_trace_and_tvs : (Trace * TyVar list) -> Substitution -> (Trace * TyVar list)
(* end mikon#1.37 *)

end;
