(*
$File: Parsing/GrammarUtils.sml $
$Date: 1992/11/10 17:00:12 $
$Revision: 1.14 $
$Locker:  $
*)

(* mikon#1.31 *)
(*$GrammarUtils:
	TOPDEC_GRAMMAR DEC_GRAMMAR LEX_BASICS CON EXCON SCON LAB TYCON TYVAR
	IDENT STRID FUNID SIGID PRE_GRAMMAR_INFO SOURCE_INFO DF_INFO CRASH
	GRAMMAR_UTILS
*)
(* end mikon#1.31 *)

functor GrammarUtils(structure TopdecGrammar: TOPDEC_GRAMMAR
		     structure DecGrammar: DEC_GRAMMAR
		       sharing type TopdecGrammar.dec = DecGrammar.dec
			   and type TopdecGrammar.ty = DecGrammar.ty
(* mikon for alx *)
                           and type TopdecGrammar.exp = DecGrammar.exp
(* mikon for alx koniec *)

			   and type TopdecGrammar.WithInfo = DecGrammar.WithInfo

		     structure LexBasics: LEX_BASICS

		     structure Con: CON
		       sharing type TopdecGrammar.con
			 	    = DecGrammar.con
				    = Con.con

		     structure Excon: EXCON
		       sharing type TopdecGrammar.excon
			 	    = DecGrammar.excon
				    = Excon.excon

		     structure SCon: SCON
		       sharing type DecGrammar.scon = SCon.scon

		     structure Lab: LAB
		       sharing type DecGrammar.lab = Lab.lab

		     structure TyCon: TYCON
		       sharing type TopdecGrammar.tycon
			 	    = DecGrammar.tycon
				    = TyCon.tycon
			   and type TopdecGrammar.longtycon
				    = DecGrammar.longtycon
				    = TyCon.longtycon

		     structure TyVar: TYVAR
		       sharing type TopdecGrammar.tyvar
			 	    = DecGrammar.tyvar
				    = TyVar.SyntaxTyVar

		     structure Ident: IDENT
		       sharing type TopdecGrammar.id
			 	    = DecGrammar.id
				    = Ident.id
			   and type DecGrammar.longid = Ident.longid

		     structure StrId: STRID
		       sharing type TopdecGrammar.strid = StrId.strid
			   and type TopdecGrammar.longstrid
			     	    = DecGrammar.longstrid
				    = StrId.longstrid

		     structure FunId: FUNID
		       sharing type TopdecGrammar.funid = FunId.funid

		     structure SigId: SIGID
		       sharing type TopdecGrammar.sigid = SigId.sigid

(* mikon#1.31 *)
		     structure PreGrammarInfo: PRE_GRAMMAR_INFO
		       sharing type TopdecGrammar.info
			 	    = DecGrammar.info
				    = PreGrammarInfo.PreElabGrammarInfo

		     structure SourceInfo: SOURCE_INFO
		       sharing type PreGrammarInfo.SourceInfo = SourceInfo.info
			   and type SourceInfo.pos = LexBasics.pos

		     structure DFInfo: DF_INFO
		       sharing type PreGrammarInfo.DFInfo = DFInfo.info
(* end mikon#1.31 *)

		     structure Crash: CRASH
		    ): GRAMMAR_UTILS =
  struct
    structure M = TopdecGrammar
    	  and C = DecGrammar

    open M C

   (* The simple constructing functions first. *)

    val mk_Con = Con.mk_Con
    val mk_ExCon = Excon.mk_ExCon
    val mk_IdentLab = Lab.mk_IdentLab
    val mk_IntegerLab = Lab.mk_IntegerLab
    val mk_Id = Ident.mk_Id
    val mk_LongId = Ident.mk_LongId
    val mk_FunId = FunId.mk_FunId
    val mk_StrId = StrId.mk_StrId
    val mk_LongStrId = StrId.mk_LongStrId
    val mk_SigId = SigId.mk_SigId
    val mk_TyVar = TyVar.mk_TyVar
    val mk_TyCon = TyCon.mk_TyCon
    val mk_LongTyCon = TyCon.mk_LongTyCon
    val mk_IntSCon = SCon.INTEGER
    val mk_StringSCon = SCon.STRING
    val mk_RealSCon = SCon.REAL

   (* Kinds of parse tree derived-form information. MEMO: currently void. *)

(* mikon#1.31 *)
    val i: info = PreGrammarInfo.emptyPreElabGrammarInfo

    fun PP left right =
      PreGrammarInfo.addPreElabSourceInfo i (SourceInfo.putPositions(left, right))
(* end mikon#1.31 *)

    fun wi_Convert f list =
      case list
	of WITH_INFO(i, x) :: rest =>
	     WITH_INFO(i, f x) :: wi_Convert f rest

	 | nil => nil

    type pos = LexBasics.pos
    exception LAYERPAT_ERROR of (pos * pos) Option

(* alx#1.40*)
(* the content of warning when imperative features in axiom *)
    val imperativeWarning = "Warning: Imperative features in axiom!"
(* alx#1.40#end*)


(* mikon#1.31 *)
    fun layerError i =
      case PreGrammarInfo.getPreElabSourceInfo i
(* end mikon#1.31 *)
	of Some si =>
	     let
	       val (left, right) = SourceInfo.getPositions si
	     in
	       raise LAYERPAT_ERROR(Some(left, right))
	     end

	 | None =>
	     raise LAYERPAT_ERROR None

   (* Complex constructor functions. *)

(* alx#1.23 *)
    fun mk_PSigId identif = 
        PRINCIPpsigexp( i, SIGIDsigexp( i, (mk_SigId identif)))
(* alx#1.23#end *)

(* alx#1.25 *)
    fun specAsSig( inf, specif) =
        PRINCIPpsigexp( i, SIGsigexp( inf, specif ) )
(* alx#1.25#end *)


    fun expOfAtexp a = ATEXPexp(i, a)
    fun patOfAtpat a = ATPATpat(i, a)

    fun atexpOfIdent id = IDENTatexp(i, OP_OPT(Ident.idToLongId id, false))
    val expOfIdent = expOfAtexp o atexpOfIdent
    fun patOfIdent(id, withOp) =
      patOfAtpat(LONGIDatpat(i, OP_OPT(Ident.idToLongId id, withOp)))

    fun topdecOfExp exp =	(* Convert `exp' to `val it = exp'. *)
      let
	val pat = patOfIdent(Ident.id_IT, false)
	val valbind = PLAINvalbind(i, pat, exp, None)
	val valdec = VALdec(i, valbind)
	val strdec = DECstrdec(i, valdec)
      in
	STRtopdec(i, strdec)
      end

    fun composeStrDec(i, strdec1, strdec2) =
      case (strdec1, strdec2)
	of (EMPTYstrdec _, _) => strdec2
	 | (_, EMPTYstrdec _) => strdec1
	 | _ => SEQstrdec(i, strdec1, strdec2)

(* alx#1.38*)
(* this is kind of trivial solution of the problem. it maybe solved another 
way by wandering through the tree of dec *)
    fun Dec2StrDec( i, dec ) =
        ( DECstrdec( i, dec ))
(* alx#1.38#end*)

    fun composeSpec(i, spec1, spec2) =
      case (spec1, spec2)
	of (EMPTYspec _, _) => spec2
	 | (_, EMPTYspec _) => spec1
	 | _ => SEQspec(i, spec1, spec2)

    val inventStrId = StrId.inventStrId
    val inventId = Ident.inventId

(* alx#1.19
     fun functSigExp(sigexp, strid) =	 Convert `(spec): sigexp' - `strid'
 					      is an invented StrId for `spec'.
 					      (See note in text, as the Definition
 					      says...) 
 	 let
 	   val longStrId = StrId.longStrIdOfStrId strid
 	 in
 	   case sigexp
 	     of SIGsigexp(_, spec) =>
 		  SIGsigexp(
 		    i, LOCALspec(i, OPENspec(i, [WITH_INFO(i, longStrId)]), spec)
 		  )
 
 	      | idSigExp => idSigExp
 	 end
 alx#1.19#end commented out *)
(* alx#1.22 *)
(* alx#1.19 
    fun functSigExp(psigexp, strid) =	 Convert `(spec): sigexp' - `strid'
					     is an invented StrId for `spec'.
					     (See note in text, as the Definition
					     says...) 
    let
	val longStrId = StrId.longStrIdOfStrId strid
    in
	case psigexp
	  of PRINCIPpsigexp(_, SIGsigexp(_, spec)) =>
	       PRINCIPpsigexp( i, 
		  SIGsigexp( i, 
		     LOCALspec(i, 
		       OPENspec(i, [WITH_INFO(i, longStrId)]), spec)
		       )
	       )		  
	     | PRINCIPpsigexp(_, idSigExp ) => idSigExp
    end
alx#1.19#end *) 
(* alx#1.22#end commented out *)
(* alx#1.24 *)
    fun functPSigExp(spec, strid) =	 (* Convert `(spec): sigexp' - `strid'
					   is an invented StrId for `spec'.
					   (See note in text, as the Definition
					   says...) *)
    let
      val longStrId = (StrId.longStrIdOfStrId strid)
    in
      PRINCIPpsigexp( i, 
                SIGsigexp( i, 
                   LOCALspec(i, 
                     OPENspec(i, [WITH_INFO(i, longStrId)]), spec)
	             )
             )		  
    end
(* alx#1.24#end *)
   (* convertFunctorBody: convert `strexp' to open the invented structure
      name `strid' for `unwrapped' functor arguments. *)

    fun convertFunctorBody(strid, strexp) =
      let
	val longStrId = (StrId.longStrIdOfStrId strid)
      in
	LETstrexp(i, DECstrdec(i, OPENdec(i, [WITH_INFO(i, longStrId)])),
		     strexp
		 )
      end

    fun composeDec(i, dec1, dec2) =
      case (dec1, dec2)
	of (EMPTYdec _, _) => dec2
	 | (_, EMPTYdec _) => dec1
	 | _ => SEQdec(i, dec1, dec2)

    fun tupleAtExp exps =	(* `(A, B, C)' -> `{1=A, 2=B, 3=C}'. *)
      let
	fun f(n, e :: rest) =
	      Some(EXPROW(i, mk_IntegerLab n, e, f(n+1, rest)))
	  | f(_, nil) =
	      None
      in
	RECORDatexp(i, f(1, exps))
      end

    fun caseExp(exp, match) =
      APPexp(i, FNexp(i, match), PARatexp(i, exp))

    fun sequenceExp exps =
      let
	fun wildMatch exp =
	  MATCH(i, MRULE(i, ATPATpat(i, WILDCARDatpat i), exp), None)

	fun f(e :: rest, context) = caseExp(e, wildMatch(f(rest, context)))
	  | f(nil, context) = context
      in
	case rev exps
	  of last :: rest => f(rev rest, last)
	   | nil => Crash.impossible "sequenceExp"
      end

    fun listAtExp exps =
      let
	val nilExp = expOfIdent Ident.id_NIL
	val consExp = expOfIdent Ident.id_CONS

	fun f(e :: rest) = APPexp(i, consExp, tupleAtExp [e, f rest])
	  | f nil = nilExp
      in
	PARatexp(i, f exps)
      end

    fun hash lab =
      let
	val var = Ident.inventId()
	val row = PATROW(i, lab, patOfIdent(var, false), Some(DOTDOTDOT i))
	val pat = ATPATpat(i, RECORDatpat(i, Some row))
	val mrule = MRULE(i, pat, expOfIdent var)
	val match = MATCH(i, mrule, None)
      in
	PARatexp(i, FNexp(i, match))
      end

    val trueExp = expOfIdent Ident.id_TRUE
    val falseExp = expOfIdent Ident.id_FALSE

    fun ifThenElse(ifExp, thenExp, elseExp) =
      let
	val mruleT = MRULE(i, patOfIdent(Ident.id_TRUE, false), thenExp)
	val mruleF = MRULE(i, patOfIdent(Ident.id_FALSE, false), elseExp)
      in
	caseExp(ifExp, MATCH(i, mruleT, Some(MATCH(i, mruleF, None))))
      end

(* mikon#last *)
    fun notExp NExp =
      let
	val mruleT = MRULE(i, patOfIdent(Ident.id_TRUE, false), falseExp)
	val mruleF = MRULE(i, patOfIdent(Ident.id_FALSE, false), trueExp)
      in
	caseExp(NExp, MATCH(i, mruleT, Some(MATCH(i, mruleF, None))))
      end

(* alx#1.7 *)
    val wildCard = ATPATpat( i, WILDCARDatpat( i ))

    fun raisesExp ( ExpOfRaises, MatchOfRaises ) =
    let
   val parenatExp = PARatexp( i, sequenceExp (ExpOfRaises :: [falseExp] ) )
   val raiseFalseExp = ATEXPexp( i, parenatExp )
   val handleMatchExp = HANDLEexp( i, raiseFalseExp, MatchOfRaises )
   val wildMatchRule = MRULE( i, wildCard, falseExp)
   val wildFalseMatch = MATCH( i, wildMatchRule, None )   
    in
   HANDLEexp( i, handleMatchExp, wildFalseMatch )
    end

    fun properExp ( ExpOfProper ) =
      let
   val termExp = CONVERexp( i, ExpOfProper )
   val wildMatchRule = MRULE( i, wildCard, trueExp)
   val wildMatch = MATCH( i, wildMatchRule, None )   
   val NotRaisExp = 
      ifThenElse(
         raisesExp ( ExpOfProper, wildMatch ),
         falseExp,
         trueExp )
      in
   ifThenElse(termExp, NotRaisExp, falseExp) (* simulation of ANDALSO *)
      end
(* alx#1.7#end *)

   (* This is really ugly. Because the info field has references, we must make
      sure that we get a new one for each occurrence of a sub-expression. That
      means that all the intermediate values (well, most of them) have to be
      written as functions to ensure generativity. Those references will have
      to go. Soon. *)

    fun whileExp(whileExp, doExp) =
      let
	val var = Ident.inventLongId()
	val varExp = ATEXPexp(i, IDENTatexp(i, OP_OPT(var, false)))
	val unitAtExp = RECORDatexp(i, None)
	val unitExp = ATEXPexp(i, unitAtExp)
	val varPat = ATPATpat(i, LONGIDatpat(i, OP_OPT(var, false)))
	val unitPat = ATPATpat(i, RECORDatpat(i, None))
	val callVar = APPexp(i, varExp, unitAtExp)

	val fnBody =
	  ifThenElse(whileExp, sequenceExp [doExp, callVar], unitExp)

	val mrule = MRULE(i, unitPat, fnBody)
	val match = MATCH(i, mrule, None)
	val fnExp = FNexp(i, match)
	val bind = RECvalbind(i, PLAINvalbind(i, varPat, fnExp, None))
	val dec = VALdec(i, bind)
      in
	ATEXPexp(i, LETatexp(i, dec, callVar))
      end

    fun rewriteDatBind(datbind, typbind) =
	(* XXX no check for different identifiers to be bound in datbind 
	   and typbind (as required, Def. p. 66 *)
      let

	(* replace --- replaces typevariables in ty, that 
	   occur in tyvarseq with the corresonding types in tyseq,
	   assumes size of tyvarseq = size of tyseq *)
	fun replaceTy tyvarseq tyseq ty = 
	  case ty of 
	    TYVARty(i, tv) => 
	      let 
		val i = 
		  (case (List.index (General.curry (op =) tv) tyvarseq) of
		    OK i => i
		  | Fail _ =>
		     Crash.unimplemented
		      "No check for tyvar on rsh in lhs of withtype defined type"

		  )
              in
		(List.nth i tyseq) 
		handle List.Subscript _ => 
			Crash.impossible "GrammarUtils.rewriteDatBind---replaceTy"
	      end
	  | RECORDty(i, None) =>
	      ty
	  | RECORDty(i, Some tyrow) => 
	      RECORDty(i, Some (replaceTyrow tyvarseq tyseq tyrow))
	  | CONty(i, tylist, tycon) => 
	      CONty(i, map (replaceTy tyvarseq tyseq) tylist, tycon)
	  | FNty(i, ty1, ty2) => 
	      FNty(i, replaceTy tyvarseq tyseq ty1,
		   replaceTy tyvarseq tyseq ty2)
	  | PARty(i, ty) =>
	      PARty(i, replaceTy tyvarseq tyseq ty)

	and replaceTyrow tyvarseq tyseq tyrow =
	  case tyrow of
	    TYROW(i, lab, ty, None) =>
	      TYROW(i, lab, replaceTy tyvarseq tyseq ty, None)
	  | TYROW(i, lab, ty, Some tyrow) =>
	      TYROW(i, lab, replaceTy tyvarseq tyseq ty, 
		   Some (replaceTyrow tyvarseq tyseq tyrow))
	  
	exception Lookup_tycon

        fun lookup_tycon tycon typbind =
	  case typbind of 
	    TYPBIND(_, tyvarseq, tycon', ty, None) =>
	      if tycon' = tycon then (tyvarseq, ty)
	      else (raise Lookup_tycon)
	  | TYPBIND(_, tyvarseq, tycon', ty, Some typbind) =>
	      if tycon' = tycon then (tyvarseq, ty)
	      else (lookup_tycon tycon typbind)
(* alx#1.26 *)
     | QUEST_TYPBIND( _, tyvarseq, tycon', None) =>
	      if tycon' = tycon then (raise Lookup_tycon) (* (tyvarseq, TYVARty( i,... )) *)
	      else (raise Lookup_tycon)
     | QUEST_TYPBIND( _, tyvarseq, tycon', Some typbind) =>
	      if tycon' = tycon then (raise Lookup_tycon) (* (tyvarseq, TYVARty( i,... )) *)
	      else (lookup_tycon tycon typbind)
(* alx#1.26#end *)

	fun rewriteTy ty =
	  case ty of 
	    TYVARty _ => 
	      ty
	  | RECORDty(i, None) => 
	      ty
	  | RECORDty(i, Some tyrow) => 
	      RECORDty(i, Some (rewriteTyrow tyrow))
	  | CONty(i, tyseq', longtycon') =>
	      let 
		val (strid_list, tycon') = TyCon.explode_LongTyCon longtycon' 
	      in
		if strid_list = nil then
		  (let 
		     val (tyvarseq1, ty1) = lookup_tycon tycon' typbind
		     val _ = 
		       if (List.size tyseq') <> (List.size tyvarseq1) then
			 Crash.unimplemented "GrammarUtils.rewriteDatBind< insert error info into i >" 
		       else ()
		   in
		     replaceTy tyvarseq1 tyseq' ty1
		   end)
		     handle Lookup_tycon => ty
		else
		  ty
	      end
	  | FNty(i, ty1, ty2) => 
	      FNty(i, rewriteTy ty1, rewriteTy ty2)
	  | PARty(i, ty) =>
	      PARty(i, rewriteTy ty)

	and rewriteTyrow tyrow =
	  case tyrow of
	    TYROW(i, lab, ty, None) =>
	      TYROW(i, lab, rewriteTy ty, None)
	  | TYROW(i, lab, ty, Some tyrow) =>
	      TYROW(i, lab, rewriteTy ty, Some (rewriteTyrow tyrow))

	fun rewriteConBind (CONBIND(i, con, None, None)) =
	      CONBIND(i, con, None, None)
	  | rewriteConBind (CONBIND(i, con, Some ty, None)) =
	      CONBIND(i, con, Some (rewriteTy ty), None)
	  | rewriteConBind (CONBIND(i, con, None, Some conbind)) =
	      CONBIND(i, con, None, Some (rewriteConBind conbind))
	  | rewriteConBind (CONBIND(i, con, Some ty, Some conbind)) =
	      CONBIND(i, con, Some (rewriteTy ty), Some (rewriteConBind conbind))

      in
	case datbind of 
	  DATBIND(i, tyvarlist, tycon, conbind, None) =>
	    DATBIND(i, tyvarlist, tycon, rewriteConBind conbind, None)
	| DATBIND(i, tyvarlist, tycon, conbind, Some datbind) =>
	    let 
	      val datbind' = rewriteDatBind(datbind, typbind) 
	    in
	      DATBIND(i, tyvarlist, tycon, 
		      rewriteConBind conbind, Some datbind')
	    end
      end


    fun tupleAtPat pats =	(* `(A, B, C)' -> `{1=A, 2=B, 3=C}'. *)
      let
	fun f(n, p :: rest) =
	      Some(PATROW(i, mk_IntegerLab n, p, f(n+1, rest)))
	  | f(_, nil) =
	      None
      in
	RECORDatpat(i, f(1, pats))
      end

    fun listAtPat pats =
      let
	val nilPat = patOfIdent(Ident.id_NIL, false)

	fun f(p :: rest) =
	      CONSpat(i, OP_OPT(Ident.idToLongId Ident.id_CONS, false),
		      tupleAtPat [p, f rest]
		     )
	  | f nil = nilPat
      in
	PARatpat(i, f pats)
      end

   (* layeredPat: analyse "Pat AS Pat", which is what comes out of the
		  parser, and turn it into a valid "as"-pattern. NB: either
		  Pat might be an UNRES_INFIX (and will be for the isolated
		  identifiers) since we haven't done the post-pass yet.
		  MEMO - preserve the "op" for the identifier. *)

    fun layeredPat(i, idPat, asPat) =
      let
	fun longIdToId longid =
	  case Ident.decompose longid
	    of (nil, id) => id
	     | (_, id) => layerError i
		  
      in
	case idPat
	  of TYPEDpat(_, ATPATpat(_, LONGIDatpat(_, OP_OPT(id, withOp))), ty) =>
	       LAYEREDpat(i, OP_OPT(longIdToId id, withOp), Some ty, asPat)

	   | ATPATpat(_, LONGIDatpat(_, OP_OPT(id, withOp))) =>
	       LAYEREDpat(i, OP_OPT(longIdToId id, withOp), None, asPat)

	   | _ => layerError i
      end

    fun tupleType tys =
      let
	fun f(n, ty :: rest) =
	      Some(TYROW(i, mk_IntegerLab n, ty, f(n+1, rest)))
	  | f(_, nil) =
	      None
      in
	RECORDty(i, f(1, tys))
      end
  end;
