(*
$File: Common/ValPrint.sml$
$Date: 1992/01/29 15:11:13 $
$Revision: 1.1 $
$Locker:  $
*)

(*$ValPrint:
	CORE_DYNOBJECT MODULE_DYNOBJECT PRETTYPRINT VAL_PRINT
 *)

functor ValPrint(structure StatObject:
		   sig
		     type TypeScheme
		   end

		 structure CoreDynObject: CORE_DYNOBJECT

		 structure ModuleDynObject: MODULE_DYNOBJECT
		   sharing type ModuleDynObject.Env = CoreDynObject.Env

		 structure PP: PRETTYPRINT
		   sharing type CoreDynObject.StringTree = PP.StringTree
		): VAL_PRINT =
  struct
    type id = CoreDynObject.Var.id
    type strid = CoreDynObject.strid
    type DynamicBasis = ModuleDynObject.Basis
    type TypeScheme = StatObject.TypeScheme
    type Val = CoreDynObject.Val

    fun locate(db, path, id) =
      let
	fun iter(env, x :: xs, id) =
	      iter(CoreDynObject.lookup_StrId(env, x), xs, id)

	  | iter(env, nil, id) =
	      CoreDynObject.lookup_Var(env, CoreDynObject.Var.mkVar id)
      in
	iter(ModuleDynObject.E_of_B db, path, id)
      end

   (* For the interpreter, we can print objects without looking at their
      types. *)

    fun print(v, _) = PP.oneLiner CoreDynObject.layoutVal v
  end;
