(* Dynamic values and objects for the Modules (Defn. V4 p57). *)

(*
$File: $
$Date: 1993/02/24 07:59:52 $
$Revision: 1.3 $
$Locker: birkedal $
*)

(*$ModuleDynObject:
	TOPDEC_GRAMMAR PPTOPDECGRAMMAR STRID SIGID FUNID VAR EXCON
	CORE_DYNOBJECT FINMAP FLAGS PRETTYPRINT REPORT CRASH
	MODULE_DYNOBJECT
 *)

functor ModuleDynObject(structure TopdecGrammar: TOPDEC_GRAMMAR

			structure PPTopdecGrammar: PPTOPDECGRAMMAR
			  sharing PPTopdecGrammar.G = TopdecGrammar

			structure StrId: STRID
(* leszczyk#1. *)
			  sharing type StrId.strid = TopdecGrammar.strid
(* end leszczyk#1. *)
			structure SigId: SIGID
			structure FunId: FUNID
			structure Var: VAR
			structure Excon: EXCON

			structure CoreDynObject: CORE_DYNOBJECT
			  sharing CoreDynObject.Var = Var
			      and CoreDynObject.Excon = Excon
(* leszczyk#1. *)
			      and type CoreDynObject.id = Var.id
			      and type CoreDynObject.Con.id = Var.id
			      and type CoreDynObject.id = Excon.id
(* end leszczyk#1. *)
			      and type CoreDynObject.strid = StrId.strid
			      and type CoreDynObject.longstrid = StrId.longstrid

(* leszczyk#1.3 *)
			structure ResIdent : RESIDENT
			  sharing type ResIdent.longvar = Var.longvar
			structure Grammar : DEC_GRAMMAR
			  sharing type Grammar.longid = ResIdent.longid
			      and type Grammar.excon = Excon.excon
			      and type Grammar.con = CoreDynObject.Con.con
			      and type Grammar.info = TopdecGrammar.info
			      and type Grammar.dec = TopdecGrammar.dec
			structure TyCon: TYCON
			  sharing type TyCon.tycon = Grammar.tycon
			structure GrammarInfo : GRAMMAR_INFO
			  sharing type GrammarInfo.PostElabGrammarInfo = Grammar.info
			structure Ident : IDENT
			  sharing type Ident.id = Var.id
			      and type Ident.longid = Var.longid
(* end leszczyk#1.3 *)

			structure FinMap: FINMAP
			structure Flags: FLAGS

			structure PP: PRETTYPRINT
			  sharing type PPTopdecGrammar.StringTree
			    	       = CoreDynObject.StringTree
				       = FinMap.StringTree
				       = PP.StringTree

			structure Report: REPORT
			  sharing type PP.Report = Report.Report

			structure Crash: CRASH
		       ): MODULE_DYNOBJECT =
  struct
(* leszczyk#1.1 *)
    type id = Var.id
(* end leszczyk#1.1 *)
    type strid = StrId.strid
    type longstrid = StrId.longstrid
    type sigid = SigId.sigid
    type funid = FunId.funid
    type strexp = TopdecGrammar.strexp
(* leszczyk#1.1
    type var = Var.var
    type excon = Excon.excon
 end leszczyk#1.1 & commented out *)
    type Env = CoreDynObject.Env
    type StrEnv = CoreDynObject.StrEnv

    type ('a, 'b) map = ('a, 'b) FinMap.map

    infix plus
    val op plus = FinMap.plus

    infix //
    val op // = Report.//

    fun debug(title, f: unit -> PP.StringTree) =
      if Flags.DEBUG_EVALTOPDEC
      then Report.print(Report.line title // PP.reportStringTree(f()))
      else ()

    fun mustFind fname (m, x) =
      case FinMap.lookup m x
	of Some y => y
	 | None => Crash.impossible("ModuleDynObject." ^ fname)

    datatype FunctorClosure =
    	       FUNCTOR_CLOSURE of (strid * Int) * (strexp * Int Option) * Basis

(* leszczyk#1.1 *)
	 and Int = INT of IntEnv * StatEnv
(* end leszczyk#1.1 *)
	 and IntEnv = INTENV of (strid, Int) map
(* leszczyk#1.1 *)
         and Status = v | c | e
	 and StatEnv = STATENV of (id, Status) map
(* end leszczyk#1.1 *)
	 and SigEnv = SIGENV of (sigid, Int) map
    	 and FunEnv = FUNENV of (funid, FunctorClosure) map
	 and Basis = BASIS of FunEnv * SigEnv * Env
	 and IntBasis = INTBASIS of SigEnv * IntEnv


   (* Death by prettyprinting... *)

    type StringTree = PP.StringTree

    fun layoutIntEnv(INTENV m) =
      FinMap.layoutMap {start="(IE:", eq=" -> ", sep=", ", finish=")"}
		       (PP.layoutAtom StrId.pr_StrId)
		       layoutInt
		       m

(* leszczyk#1.1 *)
    and layoutStatus(n) =
      let
        fun pr_Status(v) = "v"
	  | pr_Status(c) = "c"
	  | pr_Status(e) = "e"
      in
	PP.layoutAtom pr_Status n
      end

    and layoutStatEnv(STATENV n) =
      FinMap.layoutMap {start="(StE:", eq=" -> ", sep=", ", finish=")"}
                       (PP.layoutAtom Var.pr_var o Var.mkVar)
		       layoutStatus
		       n

    and layoutInt(INT(IE, StE)) =
      let
	val ieT = layoutIntEnv IE
	val steT = layoutStatEnv StE
      in
	PP.NODE{start="(INT:", finish=")", indent=3, childsep=PP.RIGHT ", ",
		children=[ieT, steT]
	       }
      end
(* end leszczyk#1.1 *)
    fun layoutBasis(BASIS(F, G, E)) =
      let
	fun layoutFunctorClosure(FUNCTOR_CLOSURE((strid, int),
						 (strexp, int_opt),
						 B
						)
				) =
	  let
	    val t1 = PP.NODE{start="(StrId:", finish=")", indent=3,
			     children=[PP.layoutAtom StrId.pr_StrId strid,
				       layoutInt int
				      ],
			     childsep=PP.LEFT " -> "
			    }
	  
	    val t2 = PP.NODE{start="(StrExp:", finish=")", indent=3,
			     children=[PPTopdecGrammar.layoutStrexp strexp,
			     	       case int_opt
					 of Some int => layoutInt int
				          | None => PP.LEAF "[NoConstraint]"
				      ],
			     childsep=PP.LEFT ": "
			    }
	  in
	    PP.NODE{start="(FunClos:", finish=")", indent=3,
		    children=[t1, t2, layoutBasis B],
		    childsep=PP.RIGHT ", "
		   }
	  end

	fun layoutFunEnv(FUNENV F) =
	   FinMap.layoutMap {start="(F:", eq=" -> ", sep=", ", finish=")"}
			    (PP.layoutAtom FunId.pr_FunId)
			    layoutFunctorClosure
			    F

	fun layoutSigEnv(SIGENV G) =
	   FinMap.layoutMap {start="(G:", eq=" -> ", sep=", ", finish=")"}
			    (PP.layoutAtom SigId.pr_SigId)
			    layoutInt
			    G
      in
	PP.NODE{start="Dynamic Basis:", finish="", indent=3,
		childsep=PP.RIGHT "; ",
		children=[layoutFunEnv F, layoutSigEnv G,
			  CoreDynObject.layoutEnv E
			 ]
	       }
      end


   (* Death by 1000 functions... *)

    val emptyIE = INTENV FinMap.empty

    val singleIE = INTENV o FinMap.singleton

    fun IE_plus_IE(INTENV m1, INTENV m2) = INTENV(m1 plus m2)

(* leszczyk#1.1 *)

    fun domIE(INTENV m) = FinMap.dom m

    val emptyStE = STATENV FinMap.empty

    val singleStE = STATENV o FinMap.singleton

    fun StE_plus_StE(STATENV m1, STATENV m2) = STATENV(m1 plus m2)

    fun domStE(STATENV m) = FinMap.dom m

    fun InterE E: Int =
      let
	val SE = CoreDynObject.SE_of_E E
	val VE = CoreDynObject.VE_of_E E
(* leszczyk#1.1
	val EE = CoreDynObject.EE_of_E E
 end leszczyk#1.1 & commented out *)

	fun iter(strid :: rest) =
	      let
		val E' = CoreDynObject.lookup_StrId(E, strid)
	      in
		IE_plus_IE(singleIE(strid, InterE E'), iter rest)
	      end
	  | iter nil = emptyIE;

	fun iterv(id :: rest) =
              StE_plus_StE(singleStE(id, v), iterv rest)
          | iterv nil = emptyStE;
      in
	INT(iter(EqSet.list(CoreDynObject.domSE SE)),
           (iterv(EqSet.list(CoreDynObject.domVE VE)))
(* end leszczyk#1.1 *)

(* leszczyk#1.1
	    CoreDynObject.domVE VE,
	    CoreDynObject.domEE EE
 end leszczyk#1.1 & commented out *)
	   )
      end

(* leszczyk#1.1 *)
    fun IE_in_Int IE = INT(IE, emptyStE)

    fun IE_of_Int(INT(IE, StE)) = IE

    fun StE_in_Int StE = INT(emptyIE, StE)

(* end leszczyk#1.1 *)

    fun InterB(BASIS(_, G, E)) = INTBASIS(G, IE_of_Int(InterE E))

    fun strId_in_IE(strid, INTENV m) =
      (debug("Looking in: ",
	     fn () => FinMap.layoutMap
		      {start="{", eq=" -> ", sep="; ", finish="}"}
		      (PP.layoutAtom StrId.pr_StrId)
		      layoutInt
		      m
	    );
       case FinMap.lookup m strid of Some _ => true
				   | None => false
      )

(* leszczyk#1.1 *)
    fun Id_in_StE(id, STATENV n) =
      (debug("Looking in: ",
	     fn () => FinMap.layoutMap
		      {start="{", eq=" -> ", sep="; ", finish="}"}
		      (PP.layoutAtom Var.pr_var o Var.mkVar)
		      layoutStatus
		      n
	    );
       case FinMap.lookup n id of Some _ => true
				| None => false
      )
(* end leszczyk#1.1 *)

    fun lookup_StrId_IE(INTENV m, strid): Int =
      mustFind "lookup_StrId_IE" (m, strid)

(* leszczyk#1.2 *)
    fun lookup_Id_StE(STATENV m, id): Status =
      mustFind "lookup_Id_StE" (m, id)
(* end leszczyk#1.2 *)

(* leszczyk#1.1 *)
    fun Cut(E, INT(IE, StE)): Env =
      let
	val SE = CoreDynObject.SE_of_E E
	val VE = CoreDynObject.VE_of_E E
  (* leszczyk#1.1
	val EE = CoreDynObject.EE_of_E E
   end leszczyk#1.1 & commented out *)

	val _ = debug("Cut.IE: ", fn () => layoutIntEnv IE);
	val _ = debug("Cut.SE: ", fn () => CoreDynObject.layoutStrEnv SE);

       (* Run through SE, discarding strid's not in IE. For those strid's
	  in IE (giving I), map strid to `SE(strid) Cut I'. *)

	val SE1 = CoreDynObject.trimSE(SE, fn s => strId_in_IE(s, IE))

	val _ = debug("Cut.SE1: ", fn () => CoreDynObject.layoutStrEnv SE1);

	val SE' = CoreDynObject.mapSE(
		    SE1, fn (strid, E) => Cut(E, lookup_StrId_IE(IE, strid))
		  )

	val _ = debug("Cut.SE': ", fn () => CoreDynObject.layoutStrEnv SE');

	val VE' = CoreDynObject.trimVE(VE, fn i => Id_in_StE(i, StE))

  (* leszczyk#1.1	  
	val VE' = CoreDynObject.trimVE(VE, fn v => EqSet.member v vars)

	val EE' = CoreDynObject.trimEE(EE, fn e => EqSet.member e excons)
  end leszczyk#1.1 & commented out *)

	val _ = debug("Cut.E: ", 
		      fn () => CoreDynObject.layoutEnv 
		               (CoreDynObject.mkEnv(SE', VE')));

      in
	CoreDynObject.mkEnv(SE', VE')
      end
(* end leszczyk#1.1 *)

(* leszczyk#1.1
    fun Vars_in_Int v = INT(emptyIE, v, EqSet.empty)

    fun Excons_in_Int e = INT(emptyIE, EqSet.empty, e)
 end leszczyk#1.1 & commented out *)

(* leszczyk#1.1 *)
    val emptyInt = INT(emptyIE, emptyStE)

    fun Int_plus_Int(INT(INTENV m1, STATENV v1), INT(INTENV m2, STATENV v2)) =
      INT(INTENV(m1 plus m2), STATENV(v1 plus v2))
(* end leszczyk#1.1 *)

    val emptyG = SIGENV FinMap.empty

    val singleG = SIGENV o FinMap.singleton

    fun G_plus_G(SIGENV m1, SIGENV m2) = SIGENV(m1 plus m2)

    fun G_of_IB(INTBASIS(G, _)) = G

    fun G_in_IB G = INTBASIS(G, emptyIE)

    val emptyF = FUNENV FinMap.empty

    fun G_in_B G = BASIS(emptyF, G, CoreDynObject.emptyE)

    fun IB_plus_G(INTBASIS(SIGENV m1, IE), SIGENV m2) =
      INTBASIS(SIGENV(m1 plus m2), IE)

    fun IB_plus_IE(INTBASIS(G1, INTENV m1), INTENV m2) =
      INTBASIS(G1, INTENV(m1 plus m2))

    val singleF = FUNENV o FinMap.singleton

    fun F_plus_F(FUNENV m1, FUNENV m2) = FUNENV(m1 plus m2)

    fun F_in_B F = BASIS(F, emptyG, CoreDynObject.emptyE)

    fun F_of_B(BASIS(F, _, _)) = F

    fun B_plus_F(BASIS(FUNENV m1, G, E), FUNENV m2) =
      BASIS(FUNENV(m1 plus m2), G, E)

    fun E_in_B E = BASIS(FUNENV FinMap.empty, SIGENV FinMap.empty, E)

    fun E_of_B(BASIS(_, _, E)) = E

    fun B_plus_E(BASIS(F, G, E1), E2) =
      BASIS(F, G, CoreDynObject.E_plus_E(E1, E2))

    fun B_plus_B(BASIS(FUNENV F1, SIGENV G1, E1),
		 BASIS(FUNENV F2, SIGENV G2, E2)
		) =
      BASIS(FUNENV(F1 plus F2),
	    SIGENV(G1 plus G2),
	    CoreDynObject.E_plus_E(E1, E2)
	   )

    val emptyBasis = E_in_B CoreDynObject.emptyE

    val initialBasis = E_in_B CoreDynObject.initialE

    fun lookup_SigId(SIGENV m, sigid) = mustFind "lookup_SigId" (m, sigid)

    fun lookup_LongStrId_B(BASIS(_, _, E), longstrid) =
      CoreDynObject.lookup_LongStrId(E, longstrid)

   (* lookup_LongStrId_IB is a wee bit of a hassle since we have to do the
      longid decomposition ourselves. (For the other lookups we are relying
      on CoreDynObject to do all this stuff.) *)

    fun lookup_LongStrId_IB(INTBASIS(_, INTENV m), longstrid): Int =
      let
	val (strids, strid) = StrId.explode_longstrid longstrid

	fun iter(m, this :: rest): Int =
	      let
		val Int = mustFind "lookup_LongStrId_IB/1" (m, this)
		val INTENV m' = IE_of_Int Int
	      in
		iter(m', rest)
	      end

	  | iter(m, nil) = mustFind "lookup_LongStrId_IB/2" (m, strid)
      in
	iter(m, strids)
      end

    fun lookup_FunId(FUNENV m, funid) = mustFind "lookup_FunId" (m, funid)

    fun B_plus_SE(BASIS(F, G, E), SE) =
      BASIS(F, G, CoreDynObject.E_plus_SE(E, SE))

    val mkClosure = FUNCTOR_CLOSURE

    fun unClosure(FUNCTOR_CLOSURE x) = x

(* leszczyk#1.2 *)
    fun TrivEnv(INT(IE, StE)) =
      let

	open CoreDynObject

	fun iter(strid :: rest) =
	      let
		val E' = TrivEnv(lookup_StrId_IE(IE, strid))
	      in
		SE_plus_SE(singleSE(strid, E'), iter rest)
	      end
	  | iter nil = emptySE;

	val SE = iter(EqSet.list(domIE(IE)));

	fun iterv(id :: rest) =
	      let
		fun give_val(i) = case lookup_Id_StE(StE, i)
		  of v => INCOMPLETEval
		   | c => CON0val(Con.mk_con(i))
		   | e => EXNAME0val(ExName.new(Var.pr_var(Var.mkVar i)));

		val VE' = singleVE(id, give_val id)
	      in
		VE_plus_VE(VE', iterv rest)
	      end
	  | iterv nil = emptyVE;

	val VE = iterv(EqSet.list(domStE(StE)));
      in
	CoreDynObject.mkEnv(SE, VE)
      end
(* end leszczyk#1.2 *)

(* leszczyk#1.3 *)
    fun TrivStrExp(INT(IE, StE)) =
      let
	fun get_ids(STATENV m, st) =
	      STATENV(FinMap.filter(fn (_, st') => st = st') m)

	val vlist = EqSet.list(domStE(get_ids(StE, v)))
	val elist = EqSet.list(domStE(get_ids(StE, e)))
	val clist = EqSet.list(domStE(get_ids(StE, c)))

	val slist = EqSet.list(domIE IE)

	val info = GrammarInfo.emptyPostElabGrammarInfo

	local
	  open Grammar ResIdent
	  val idToLongVar = Var.mk_longvar o Ident.idToLongId
	in 
	  fun mk_vals(id::rest) =
	        PLAINvalbind(
		  info,
		  ATPATpat(
		    info,
		    LONGIDatpat(
		      info,
		      OP_OPT(LONGVAR (idToLongVar id), true))),
		  ATEXPexp(info, UNDEFatexp(info)),
		  case rest
		    of nil => None
		     | _ => Some (mk_vals(rest)))

	  fun mk_excs(id::rest) =
	        EXBIND(
		  info,
		  OP_OPT(CoreDynObject.Excon.mk_excon id, true),
		  None,     
		  case rest
		    of nil => None
		     | _ => Some (mk_excs(rest)))

	  fun mk_cons(id::rest) =
	        CONBIND(
		  info,
		  OP_OPT(CoreDynObject.Con.mk_con id, true),
		  None,
		  case rest
		    of nil => None
		     | _ => Some (mk_cons(rest)))

	  val vstrdec =
	    TopdecGrammar.DECstrdec(
	      info,
	      case vlist
	        of nil => EMPTYdec(info)
	         | _ => VALdec(info, mk_vals(vlist))
	    )

	  val estrdec =
	    TopdecGrammar.DECstrdec(
	      info,
	      case elist
	        of nil => EMPTYdec(info)
	         | _ => EXCEPTIONdec(info, mk_excs(elist))
	    )

	  val dstrdec =
	    TopdecGrammar.DECstrdec(
	      info,
	      case clist
	        of nil => EMPTYdec(info)
	         | _ => DATATYPEdec(
		   info,
		   DATBIND(
		     info,
		     nil,
		     TyCon.mk_TyCon "dummy",
		     mk_cons(clist),
		     None
		   )
	        )
	    )
	end

	open TopdecGrammar

	fun mk_structs(strid::rest) =
	      STRBIND(
		info,
	      	UNGUARDsglstrbind(
		  info,
		  strid,
		  TrivStrExp(lookup_StrId_IE(IE, strid))),
		case rest
		  of nil => None
		   | _ => Some (mk_structs(rest)))

	val sstrdec = case slist
	  of nil => EMPTYstrdec(info)
	   | _ => STRUCTUREstrdec(info, mk_structs(slist))

	val fst_strdec = SEQstrdec(info, sstrdec, vstrdec)
	val snd_strdec = SEQstrdec(info, estrdec, dstrdec)
	val strdec = SEQstrdec(info, fst_strdec, snd_strdec)
      in
	STRUCTstrexp(info, strdec)
      end
(* end leszczyk#1.3 *)

    type Report = Report.Report
    fun reportBasis _ = Report.line "<ModuleDynObject.basis>"
  end;


