(*
$File: Interpreter/Evaluation.sml $
$Date: 1992/08/19 14:49:39 $
$Revision: 1.16 $
$Locker:  $
*)

(*$Evaluation:
	LAB CON SCON EXCON VAR STRID SIGID FUNID RESIDENT OVERLOADING_INFO
	GRAMMAR_INFO DEC_GRAMMAR
	TOPDEC_GRAMMAR STATOBJECT PPTOPDECGRAMMAR FINMAP SORTED_FINMAP
	FLAGS PRETTYPRINT REPORT CRASH ExName BasicValue CoreDynObject
	SpecialValue ModuleDynObject EvalTopdec ValPrint EvalDec
	EVALUATION
 *)

functor Evaluation(structure Lab: LAB
		   structure Con: CON
		   structure SCon: SCON
		   structure Excon: EXCON
		   structure Var: VAR
(* leszczyk#1.3 *)
		   structure TyCon: TYCON
		   structure Ident: IDENT
		     sharing type Ident.id = Con.id
		         and type Ident.id = Excon.id
		         and type Ident.id = Var.id
			 and type Ident.longid = Var.longid
(* end leszczyk#1.3 *)

		   structure StrId: STRID
		     sharing type Var.strid = Excon.strid = StrId.strid

		   structure SigId: SIGID
		   structure FunId: FUNID

		   structure ResIdent: RESIDENT
		     sharing type ResIdent.longvar = Var.longvar
			 and type ResIdent.longcon = Con.longcon
			 and type ResIdent.longexcon = Excon.longexcon

		structure OverloadingInfo: OVERLOADING_INFO
		structure GrammarInfo: GRAMMAR_INFO
		     sharing type GrammarInfo.OverloadingInfo = OverloadingInfo.info

		   structure DecGrammar: DEC_GRAMMAR
		     sharing type DecGrammar.lab = Lab.lab
			 and type DecGrammar.scon = SCon.scon
			 and type DecGrammar.excon = Excon.excon
			 and type DecGrammar.id = Var.var
			 and type DecGrammar.longstrid = StrId.longstrid
			 and type DecGrammar.longid = ResIdent.longid
			 and type DecGrammar.info = GrammarInfo.PostElabGrammarInfo
(* leszczyk#1. *)
			 and type DecGrammar.tycon = TyCon.tycon
			 and type DecGrammar.con = Con.con
(* end leszczyk#1. *)

		   structure TopdecGrammar: TOPDEC_GRAMMAR
		     sharing type TopdecGrammar.dec = DecGrammar.dec
		         and type TopdecGrammar.strid = StrId.strid
			 and type TopdecGrammar.longstrid = StrId.longstrid
			 and type TopdecGrammar.sigid = SigId.sigid
			 and type TopdecGrammar.funid = FunId.funid
			 and type TopdecGrammar.excon = Excon.excon
			 and type TopdecGrammar.id = Var.var
(* leszczyk#1. *)
			 and type TopdecGrammar.con = Con.con
			 and type TopdecGrammar.info = DecGrammar.info
(* end leszczyk#1. *)

		   structure PPTopdecGrammar: PPTOPDECGRAMMAR
		     sharing PPTopdecGrammar.G = TopdecGrammar

		   structure StatObject: STATOBJECT
		   structure FinMap: FINMAP
		   structure SortedFinMap: SORTED_FINMAP
		   structure Flags: FLAGS

		   structure PP: PRETTYPRINT
		     sharing type PPTopdecGrammar.StringTree
				  = FinMap.StringTree
				  = SortedFinMap.StringTree
				  = PP.StringTree

		   structure Report: REPORT
		     sharing type PP.Report = Report.Report

		   structure Crash: CRASH

		   val USE: string -> unit	(* use a file, raise host ML's
						   Io if unable to open it. *)

		  ): EVALUATION =
  struct
    structure ExName = ExName()
    structure BasicValue = BasicValue()

    structure SpecialValue =
      SpecialValue(structure SCon = SCon
		   structure Crash = Crash
		  )

    structure CoreDynObject =
      CoreDynObject(structure Lab = Lab
		    structure Con = Con
		    structure SpecialValue = SpecialValue
		    structure Var = Var
		    structure Excon = Excon
		    structure ExName = ExName
		    structure StrId = StrId
		    structure Grammar = DecGrammar
		    structure FinMap = FinMap
		    structure SortedFinMap = SortedFinMap
		    structure BasicValue = BasicValue
		    structure PP = PP
		    structure Crash = Crash
		   )

    structure ModuleDynObject =
      ModuleDynObject(structure TopdecGrammar = TopdecGrammar
		      structure PPTopdecGrammar = PPTopdecGrammar
(* leszczyk#1.3 *)
		      structure Grammar = DecGrammar
		      structure ResIdent = ResIdent
		      structure TyCon = TyCon
		      structure GrammarInfo = GrammarInfo
		      structure Ident = Ident
(* end leszczyk#1.3 *)
		      structure StrId = StrId
		      structure SigId = SigId
		      structure FunId = FunId
		      structure Var = Var
		      structure Excon = Excon
		      structure CoreDynObject = CoreDynObject
		      structure FinMap = FinMap
		      structure Flags = Flags
		      structure PP = PP
		      structure Report = Report
		      structure Crash = Crash
		     )

    structure DynamicBasis = ModuleDynObject
				(* Export the simple DynamicBasis interface. *)

    structure EvalTopdec =
      EvalTopdec(structure Grammar = TopdecGrammar
		 structure ModuleDynObject = ModuleDynObject
		 structure CoreDynObject = CoreDynObject

		 structure EvalDec =
		   EvalDec(structure Grammar = DecGrammar
			   structure ResIdent  = ResIdent
			   structure BasicValue = BasicValue
			   structure SpecialValue = SpecialValue
			   structure OverloadingInfo = OverloadingInfo
			   structure GrammarInfo = GrammarInfo
			   structure CoreDynObject = CoreDynObject
			   structure ModuleDynObject = ModuleDynObject
			   structure SortedFinMap = SortedFinMap
			   structure FinMap = FinMap
			   structure PP = PP
			   structure Crash = Crash
			   val USE = USE
			  )

		 structure Flags = Flags
		 structure PP = PP
		 structure Report = Report
		 structure Crash = Crash
		)

    structure ValPrint =
      ValPrint(structure StatObject = StatObject
	       structure CoreDynObject = CoreDynObject
	       structure ModuleDynObject = ModuleDynObject
	       structure PP = PP
	      )
  end;
