(* topdec evaluator *)

(*
$File: Interpreter/EvalTopdec.sml $
$Date: 1992/04/07 14:58:00 $
$Revision: 1.14 $
$Locker:  $
*)

(*$EvalTopdec:
	TOPDEC_GRAMMAR MODULE_DYNOBJECT CORE_DYNOBJECT EVALDEC
	FLAGS PRETTYPRINT REPORT CRASH EVALTOPDEC
 *)

functor EvalTopdec(structure Grammar: TOPDEC_GRAMMAR

		   structure ModuleDynObject: MODULE_DYNOBJECT
			     sharing
(* zaslepka
			     type ModuleDynObject.var = Grammar.id
		         and type ModuleDynObject.excon = Grammar.excon
*)
			 type ModuleDynObject.sigid = Grammar.sigid
		         and type ModuleDynObject.strid = Grammar.strid
		         and type ModuleDynObject.strexp = Grammar.strexp
			 and type ModuleDynObject.funid = Grammar.funid
			 and type ModuleDynObject.longstrid = Grammar.longstrid

		   structure CoreDynObject: CORE_DYNOBJECT
		     sharing type ModuleDynObject.Env = CoreDynObject.Env
		         and type ModuleDynObject.StrEnv = CoreDynObject.StrEnv
			 and type CoreDynObject.strid = Grammar.strid
(* leszczyk#1. *)
			 and type CoreDynObject.Excon.excon = Grammar.excon
			 and type CoreDynObject.Con.con = Grammar.con
			 and type CoreDynObject.Var.id = ModuleDynObject.id
			 and type CoreDynObject.Con.id = ModuleDynObject.id
			 and type CoreDynObject.Excon.id = ModuleDynObject.id
			 and type CoreDynObject.Var.var = Grammar.id
(* end leszczyk#1. *)

		   structure EvalDec: EVALDEC
		     sharing type EvalDec.dec = Grammar.dec
			 and type EvalDec.Env = CoreDynObject.Env

		   structure Flags: FLAGS

		   structure PP: PRETTYPRINT
		     sharing type ModuleDynObject.StringTree
		       		  = CoreDynObject.StringTree
				  = PP.StringTree

		   structure Report: REPORT
		     sharing type PP.Report = Report.Report

		   structure Crash: CRASH
		  ): EVALTOPDEC =
  struct
    type topdec = Grammar.topdec

    structure C = CoreDynObject
          and M = ModuleDynObject	(* abbreviation... *)

    type DynamicBasis = M.Basis

    type StringTree = M.StringTree
    val layoutDynamicBasis = M.layoutBasis

    infix cut
    val op cut = M.Cut

    infix //
    val op // = Report.//

    fun ifPresent _ None = None
      | ifPresent (f, x) (Some y) = Some(f(x, y))

    open Grammar

   (* debug: the suspension is to avoid expensive prettyprinting. *)

    fun debug(title, f: unit -> StringTree) =
      if Flags.DEBUG_EVALTOPDEC
      then Report.print(Report.line title // PP.reportStringTree(f()))
      else ()

(* leszczyk#1.1
    fun varsOfValdesc valdesc =
      case valdesc
	of VALDESC(_, id, _, valdesc_opt) =>
	     EqSet.insert id (case valdesc_opt
				of Some valdesc => varsOfValdesc valdesc
				 | None => EqSet.empty
			     )

    fun exconsOfExdesc exdesc =
      case exdesc
	of EXDESC(_, id, _, exdesc_opt) =>
	     EqSet.insert id (case exdesc_opt
				of Some exdesc => exconsOfExdesc exdesc
				 | None => EqSet.empty
			     )
 end leszczyk#1.1 & commented out *)

   (* The evalXXX functions allow EvalDec.UNCAUGHT to escape. We catch
      it when we wrap up (below). *)

    fun evalStrdesc(IB, strdesc): M.IntEnv =
      case strdesc
	of STRDESC(_, strid, sigexp, strdesc_opt) =>
	     let
	       val I = evalSigexp(IB, sigexp)

	       val IE_opt = ifPresent (evalStrdesc, IB) strdesc_opt
	     in
	       (fn IE => case IE_opt of Some IE' => M.IE_plus_IE(IE, IE')
				      | None => IE
	       ) (M.singleIE(strid, I))
	     end

    and evalSpec(IB, spec): M.Int =
      case spec
	of VALspec(_, valdesc) =>
(* leszczyk#1.1 & 1.6 *)
	     M.StE_in_Int(evalValdesc valdesc)

	 | DATATYPEspec(_, datdesc) =>
	     M.StE_in_Int(evalDatdesc datdesc)

	 | EXCEPTIONspec(_, exdesc) =>
	     M.StE_in_Int(evalExdesc exdesc)

(* end leszczyk#1.1 & 1.6 *)
	 | STRUCTUREspec(_, strdesc) =>
	     M.IE_in_Int(evalStrdesc(IB, strdesc))

	 | LOCALspec(_, spec1, spec2) =>
	     let
	       val I1 = evalSpec(IB, spec1)
	       val I2 = evalSpec(M.IB_plus_IE(IB, M.IE_of_Int I1), spec2)
	     in
	       I2
	     end

	 | OPENspec(_, list) =>
	     let
	       fun f (WITH_INFO(_, longstrid)) Is =
		 M.Int_plus_Int(Is, M.lookup_LongStrId_IB(IB, longstrid))
	     in
	       List.foldR f M.emptyInt list
	     end

	 | INCLUDEspec(_, list) =>
	     let
	       fun f (WITH_INFO(_, sigid)) Is =
		 M.Int_plus_Int(Is, M.lookup_SigId(M.G_of_IB IB, sigid))
	     in
	       List.foldR f M.emptyInt list
	     end

	 | SEQspec(_, spec1, spec2) =>
	     let
	       val I1 = evalSpec(IB, spec1)
	       val I2 = evalSpec(M.IB_plus_IE(IB, M.IE_of_Int I1), spec2)
	     in
	       M.Int_plus_Int(I1, I2)
	     end

	 | _ =>	M.emptyInt		(* EMPTYspec and those not
					   concerned with evaluation. *)

(* leszczyk#1.1 & 1.6 *)
    and evalValdesc(valdesc) =
      case valdesc
	of VALDESC(_, id, _, valdesc_opt) =>
	     M.StE_plus_StE(M.singleStE(C.Var.unVar id, M.v),
			    (case valdesc_opt
			       of Some valdesc => evalValdesc valdesc
				| None => M.emptyStE
			    ))

    and evalDatdesc(datdesc) =
      case datdesc
	of DATDESC(_, _, _, condesc, datdesc_opt) =>
	     M.StE_plus_StE(evalCondesc(condesc),
			    (case datdesc_opt
			       of Some datdesc => evalDatdesc datdesc
				| None => M.emptyStE
			    ))

    and evalCondesc(condesc) =
      case condesc
	of CONDESC(_, con, _, condesc_opt) =>
	     M.StE_plus_StE(M.singleStE(C.Con.un_con con, M.c),
			    (case condesc_opt
			       of Some condesc => evalCondesc condesc
				| None => M.emptyStE
			    ))

    and evalExdesc(exdesc) =
      case exdesc
	of EXDESC(_, id, _, exdesc_opt) =>
	     M.StE_plus_StE(M.singleStE(C.Excon.un_excon id, M.e),
			    (case exdesc_opt
			       of Some exdesc => evalExdesc exdesc
				| None => M.emptyStE
			    ))
(* end leszczyk#1.1 & 1.6 *)

    and evalSigexp(IB, sigexp): M.Int =
      case sigexp
	of SIGsigexp(_, spec) =>
	     evalSpec(IB, spec)

	 | SIGIDsigexp(_, sigid) =>
	     M.lookup_SigId(M.G_of_IB IB, sigid)

(* mju#1.5 *)
    and evalPsigexp(IB, psigexp): M.Int =
      case psigexp
	of PRINCIPpsigexp(_, sigexp) =>
	     evalSigexp(IB, sigexp)
(* end of mju#1.5 *)

    and evalStrexp(B, strexp): M.Env =
      case strexp
	of STRUCTstrexp(_, strdec) =>
	     evalStrdec(B, strdec)

	 | LONGSTRIDstrexp(_, longstrid) =>
	     M.lookup_LongStrId_B(B, longstrid)

	 | APPstrexp(_, funid, strexp) =>
	     let
	       val ((strid, I), (strexp', I'_opt), B') =
		 M.unClosure(M.lookup_FunId(M.F_of_B B, funid))

	       val E = evalStrexp(B, strexp)

	       val _ = debug("StrExp.E", fn () => C.layoutEnv E)

	       val _ = debug("StrExp.(E cut I)", fn () => C.layoutEnv(E cut I))

	       val E' =
		 evalStrexp(M.B_plus_SE(B', C.singleSE(strid, E cut I)),
			    strexp'
			   )

	       val _ = debug("StrExp.E'", fn () => C.layoutEnv E')
	     in
	       case I'_opt of Some I' => E' cut I'
			    | None => E'
	     end

	 | LETstrexp(_, strdec, strexp) =>
	     let
	       val E = evalStrdec(B, strdec)
	       val E' = evalStrexp(M.B_plus_E(B, E), strexp)
	     in
	       E'
	     end

(* commented out by mju#1.5 
    and evalStrbind(B, strbind): C.StrEnv =
      case strbind
	of STRBIND(_, strid, sigexp_opt, strexp, strbind_opt) =>
	     let
	       val E = evalStrexp(B, strexp)
	       val I_opt = ifPresent (evalSigexp, M.InterB B) sigexp_opt
	       val SE_opt = ifPresent (evalStrbind, B) strbind_opt
	     in
	       (fn SE => case SE_opt of Some SE' => C.SE_plus_SE(SE, SE')
				      | None => SE
	       ) (C.singleSE(strid,
			     case I_opt of Some I => E cut I | None => E
			    )
		 )
	     end
   commented out by mju#1.5 *)

(* mju#1.5 *)
    and evalStrbind(B, strbind): C.StrEnv =
      case strbind
	of STRBIND(_, sglstrbind, strbind_opt) =>
	     let
	       val SE = evalSglstrbind(B, sglstrbind)
	       val SE_opt = ifPresent (evalStrbind, B) strbind_opt
	     in
	       case SE_opt of Some SE' => C.SE_plus_SE(SE, SE')
			    | None => SE
	     end

    and evalSglstrbind(B, sglstrbind): C.StrEnv =
      case sglstrbind
	of SINGLEsglstrbind(_, strid, psigexp, strexp) =>
	     let
	       val E = evalStrexp(B, strexp)
	       val I = evalPsigexp(M.InterB B, psigexp)
	     in
	       C.singleSE(strid, E cut I)
	     end
	     
	 | UNDEFsglstrbind(_, strid, psigexp) =>
	     let
	       val I = evalPsigexp(M.InterB B, psigexp)
(* leszczyk#1.2 *)
	       val E = M.TrivEnv I
(* end leszczyk#1.2 *)
	     in
	       C.singleSE(strid, E) 
	     end

	 | UNGUARDsglstrbind(_, strid, strexp) => 
	     let
	       val E = evalStrexp(B, strexp)
	     in
	       C.singleSE(strid, E)
	     end
(* end of mju#1.5 *)

    and evalStrdec(B, strdec): M.Env =
      case strdec
	of DECstrdec(_, dec) =>
	     EvalDec.eval(M.E_of_B B, dec)

(* mikon#1.3 *)
         | AXIOMstrdec(_, ax) =>
	     C.emptyE
(* end mikon#1.3 *)

         | STRUCTUREstrdec(_, strbind) =>
	     C.SE_in_E(evalStrbind(B, strbind))

         | LOCALstrdec(_, strdec1, strdec2) =>
	     let
	       val E1 = evalStrdec(B, strdec1)
	       val B' = M.B_plus_B(B, M.E_in_B E1)
	       val E2 = evalStrdec(B', strdec2)
	     in
	       E2
	     end

	 | EMPTYstrdec _ =>
	     C.emptyE

	 | SEQstrdec(_, strdec1, strdec2) =>
	     let
	       val E1 = evalStrdec(B, strdec1)
	       val B' = M.B_plus_B(B, M.E_in_B E1)
	       val E2 = evalStrdec(B', strdec2)
	     in
	       C.E_plus_E(E1, E2)
	     end

    and evalSigbind(IB, sigbind): M.SigEnv =
      case sigbind
(* mju#1.5 *)
	of SIGBIND(_, sigid, psigexp, sigbind_opt) =>
	     let
	       val I = evalPsigexp(IB, psigexp)
(* end of mju#1.5 *)
	       val G_opt = ifPresent (evalSigbind, IB) sigbind_opt
	     in
	       (fn G => case G_opt of Some G' => M.G_plus_G(G, G')
				    | None => G
	       ) (M.singleG(sigid, I))
	     end

    and evalSigdec(IB, sigdec): M.SigEnv =
      case sigdec
	of SIGNATUREsigdec(_, sigbind) =>
	     evalSigbind(IB, sigbind)

	 | EMPTYsigdec _ =>
	     M.emptyG

	 | SEQsigdec(_, sigdec1, sigdec2) =>
	     let
	       val G1 = evalSigdec(IB, sigdec1)
	       val G2 = evalSigdec(M.IB_plus_G(IB, G1), sigdec2)
	     in
	       M.G_plus_G(G1, G2)
	     end

    and evalFundec(B, fundec): M.FunEnv =
      case fundec
	of FUNCTORfundec(_, funbind) =>
	     evalFunbind(B, funbind)

	 | EMPTYfundec _ =>
	     M.emptyF

	 | SEQfundec(_, fundec1, fundec2) =>
	     let
	       val F1 = evalFundec(B, fundec1)
	       val F2 = evalFundec(M.B_plus_F(B, F1), fundec2)
	     in
	       M.F_plus_F(F1, F2)
	     end

(* mju#1.5 *)
    and evalFunbind(B, funbind): M.FunEnv =
      case funbind
	of FUNBINDfunbind(_, funid, strid, psigexp, psigexp', strexp, funbind_opt) =>
	     let
	       val I = evalPsigexp(M.InterB B, psigexp)
	       val I' = evalPsigexp(M.IB_plus_IE(M.InterB B, M.singleIE(strid, I)),
				    psigexp')
	       val F_opt = ifPresent (evalFunbind, B) funbind_opt
	     in
	       (fn F => case F_opt of Some F' => M.F_plus_F(F, F')
				    | None => F
	       ) (M.singleF(funid, M.mkClosure((strid, I), (strexp, Some I'), B)))
	     end

                     (* to i pod literka t to bzdura - sluzy tylko zaslepce kilka linii ponizej ! *)
	 | UNDEFfunbind(i, funid, strid, psigexp, psigexp', funbind_opt) =>
	     let
	       val I = evalPsigexp(M.InterB B, psigexp)
	       val I' = evalPsigexp(M.IB_plus_IE(M.InterB B, M.singleIE(strid, I)),
				    psigexp')
	       val F_opt = ifPresent (evalFunbind, B) funbind_opt	       
	     in
	       (fn F => case F_opt of Some F' => M.F_plus_F(F, F')
				    | None => F
	       ) (M.singleF(funid, M.mkClosure((strid, I),
(* leszczyk#1.3 *) 					       
			(M.TrivStrExp I', Some I'), B)))
(* end leszczyk#1.3 *)	       
	     end
(* end of mju#1.5 *)

(* begin: commented out by mju#1.5 
    and evalFunbind(B, funbind): M.FunEnv =
      case funbind
	of FUNBIND(_, funid, strid, sigexp, sigexp_opt, strexp, funbind_opt) =>
	  let
	    val _ = debug("FunBind.I", fn () => M.layoutInt I);
	  in
	    (fn F => case F_opt of Some F' => M.F_plus_F(F, F')
				 | None => F
	    ) (M.singleF(funid, M.mkClosure((strid, I), (strexp, I'_opt), B)))
	  end
   end: commented out by mju#1.5 *)

   (* export the following: *)
    type Pack = EvalDec.Pack
    exception UNCAUGHT = EvalDec.UNCAUGHT
    val pr_Pack = EvalDec.pr_Pack
    val RE_RAISE = EvalDec.RE_RAISE
    val FAIL_USE = EvalDec.FAIL_USE

    fun eval(B, topdec) =
      case topdec
	of STRtopdec(_, strdec) =>
	     M.E_in_B(evalStrdec(B, strdec))
					(* UNCAUGHT(p) might propagate. *)

	(* SIGtopdec and FUNtopdec always succeed at evaluation, since
	   they aren't generative. *)

	 | SIGtopdec(_, sigdec) =>
	     M.G_in_B(evalSigdec(M.InterB B, sigdec))

	 | FUNtopdec(_, fundec) =>
	     M.F_in_B(evalFundec(B, fundec))
  end;
