(* Trace *)

(*
$File: Common/Trace.sml $
$Date: 1995/12/10 01:41:17 $
$Revision: 1.0 $
$Locker: mikon $
*)

(*$Trace:
	MODULE_ENVIRONMENTS
	CORE_TRACE TRACE
 *)

functor Trace
    ( structure CoreTrace : CORE_TRACE
      structure ModuleEnvironments : MODULE_ENVIRONMENTS ) : TRACE =
struct

    type TraceCOR = CoreTrace.Trace
    type NameSet = ModuleEnvironments.NameSet
    and StrName  = ModuleEnvironments.StrName
    and Rea      = ModuleEnvironments.Realisation
    and VarEnv   = ModuleEnvironments.VarEnv 
    and TyEnv    = ModuleEnvironments.TyEnv
    and Env      = ModuleEnvironments.Env

    datatype Trace = 
	TRACE_COR of TraceCOR
      | SIM_TRACE of SimTrace
      | BOUND_TRACE of BoundTrace 
	
    and BoundTrace = 
	BOUND of NameSet

    and SimTrace = 
	STRNAME of StrName
      | REA of Rea
      | VARENV of VarEnv
      | TYENV of TyEnv
      | ENV of Env 

    val TraceCOR_in_Trace = TRACE_COR

    fun unTraceCoreTrace (TRACE_COR(core_trace)) = Some(core_trace)
      | unTraceCoreTrace _ = None

end;