(* Grammar for modules - Definition v3 pages 12-14 *)

(*
$File: Common/TOPDEC_GRAMMAR.sml $
$Date: 1993/03/05 14:39:09 $
$Revision: 1.12 $
$Locker: birkedal $
*)

(*$TOPDEC_GRAMMAR*)

signature TOPDEC_GRAMMAR =
  sig
    (* Core declarations. *)

    type dec

    (* Various kinds of module identifiers. *)

    type strid
    type longstrid
    type funid
    type sigid

    (* Objects from the core syntax (needed for specs). *)

    type id
    type tyvar
    type ty
(* robmar#1 *)
    type exp
    type tycon
    type longtycon
    type con
    type excon

    (* info place-holder. *)

    type info

    datatype 'a WithInfo = WITH_INFO of info * 'a

			    (* Figure 6 *)

    datatype strexp =
      STRUCTstrexp of info * strdec |
      LONGSTRIDstrexp of info * longstrid |
      APPstrexp of info * funid * strexp |
      LETstrexp of info * strdec * strexp

    and strdec =
      DECstrdec of info * dec |
(* mju#1.2 *)
      AXIOMstrdec of info * ax |
(* end mju#1.2 *)
      STRUCTUREstrdec of info * strbind |
      LOCALstrdec of info * strdec * strdec |
(* mju#1.2 *)
      SEQstrdec of info * strdec * strdec |
      EMPTYstrdec of info 

    and ax =
      AXIOMax of info * axexp * ax Option

    and axexp = 
      AXIOM_EXPaxexp of info * exp

    and strbind =
      STRBIND of info * sglstrbind * strbind Option

    and sglstrbind =
      SINGLEsglstrbind of info * strid * psigexp * strexp |
      UNDEFsglstrbind of info * strid * psigexp |
      UNGUARDsglstrbind of info * strid * strexp
(* end mju#1.2 *)

    and sigexp =
      SIGsigexp of info * spec |
      SIGIDsigexp of info * sigid

(* mju#1.2 *)
    and psigexp =
      PRINCIPpsigexp of info * sigexp
(* end mju#1.2 *)

    and sigdec =
      SIGNATUREsigdec of info * sigbind |
(* mju#1.2 *)
      SEQsigdec of info * sigdec * sigdec |
      EMPTYsigdec of info 

    and sigbind =
      SIGBIND of info * sigid * psigexp * sigbind Option
(* end mju#1.2 *)

			    (* Figure 7 *)

    and spec =
      VALspec of info * valdesc |
      TYPEspec of info * typdesc |
      EQTYPEspec of info * typdesc |
      DATATYPEspec of info * datdesc |
      EXCEPTIONspec of info * exdesc |
(* mju#1.2 *)
      AXIOMspec of info * axdesc |
(* end mju#1.2 *)
      STRUCTUREspec of info * strdesc |
      SHARINGspec of info * shareq |
      LOCALspec of info * spec * spec |
      OPENspec of info * longstrid WithInfo list |
      INCLUDEspec of info * sigid WithInfo list |
(* mju#1.2 *)
      SEQspec of info * spec * spec |
      EMPTYspec of info 
(* end mju#1.2 *)
(* robmar#1 
      AXIOM1spec of info * exp
   commented out by mju#1.2 *)

    and valdesc =
      VALDESC of info * id * ty * valdesc Option

    and typdesc =
      TYPDESC of info * tyvar list * tycon * typdesc Option

    and datdesc =
      DATDESC of info * tyvar list * tycon * condesc * datdesc Option

    and condesc =
      CONDESC of info * con * ty Option * condesc Option

    and exdesc =
      EXDESC of info * excon * ty Option * exdesc Option

(* mju#1.2 *)
    and axdesc = 
      AXDESC of info * specexp * axdesc Option

    and specexp =
      SPECEXP of info * strdec * axexp
(* end mju#1.2 *)

    and strdesc =
      STRDESC of info * strid * sigexp * strdesc Option

    and shareq =
      STRUCTUREshareq of info * longstrid WithInfo list |	(* >= 2 *)
      TYPEshareq of info * longtycon WithInfo list |		(* >= 2 *)
      ANDshareq of info * shareq * shareq

			    (* Figure 8 *)

    and fundec =
      FUNCTORfundec of info * funbind |
(* mju#1.2 *)
      SEQfundec of info * fundec * fundec |
      EMPTYfundec of info 

    and funbind =
      FUNBINDfunbind of info * funid * strid * psigexp * psigexp * strexp * funbind Option |
      UNDEFfunbind of info * funid * strid * psigexp * psigexp * funbind Option
(* end mju#1.2 *)

    and topdec =
      STRtopdec of info * strdec |
      SIGtopdec of info * sigdec |
      FUNtopdec of info * fundec

    val getExplicitTyVarsCondesc : condesc -> tyvar list
  end;



