(* Propagated objects of the static semantics - Definition page 16-22 *)

(*
$File: Common/STATOBJECT_PROP.sml $
$Date: 1992/12/30 14:48:16 $
$Revision: 1.24 $
$Locker: birkedal $
*)

(*$STATOBJECT_PROP *)

signature STATOBJECT_PROP =
  sig 
    (********
    Unqualified identifiers
    ********)

    eqtype id
    type longid

    val pr_id: id -> string
    and pr_longid: longid -> string

    (********
    Unqualified variables
    ********)

    type var

    (********
    Conversion of ids to vars
    ********)

    val mk_var : id -> var

    (********
    Constructed types
    ********)

    type ConsType

    (********
    Type Names
    ********)

    type TyName

    (****
    Types
    ****)

    eqtype Type

    val mkConsType     : Type list * TyName -> ConsType
    and mkTypeConsType : ConsType -> Type
    and existsRecVarsType : Type -> bool

    val pr_Type: Type -> string

    (********
    Derived constructors and destructors
    ********)

    val mkTypeArrow : Type * Type -> Type
    and unTypeArrow : Type -> (Type * Type) Option
    and mkTypeRef   : Type -> Type
    and mkTypePair  : Type * Type -> Type
    and TypeUnit    : Type
    and TypeExn     : Type
    and TypeInt	    : Type		(* needed for `prim'. *)
    and TypeBool    : Type              (* needed for initial TE and VE *)

    val isTypeExn: Type -> bool

    (********
    The type SyntaxTyVar is the type of syntactic type variables
    ********)

    type SyntaxTyVar

    (********
    Type variables
    ********)

    eqtype TyVar
    val impTyVar : TyVar -> bool
    and mkExplicitTyVar : SyntaxTyVar -> TyVar
    and freshTyVar : {equality : bool, imperative : bool, overloaded: bool} -> TyVar

    val mkTypeTyVar : TyVar -> Type

    val pr_TyVar: TyVar -> string

    (********
    TypeSchemes
    ********)

    eqtype TypeScheme

    val mkTypeScheme : TyVar list * Type -> TypeScheme
    and unTypeScheme : TypeScheme -> TyVar list * Type
    val TySch_generalises_TySch : TypeScheme * TypeScheme -> bool
    val TySch_generalises_Type  : TypeScheme * Type -> bool
(*    val existsRecVarsTypeScheme : TypeScheme -> bool *)

    val pr_TypeScheme: TypeScheme -> string

   (* Printing with pretty type-variable names. *)
    type TVNames
    val newTVNames: unit -> TVNames
    val pr_TypePRETTY: TVNames -> Type -> string
    val pr_TypeSchemePRETTY: TVNames -> TypeScheme -> string

    (********
    Make a type into a typescheme with no bound variables
    ********)

    val Type_in_TypeScheme : Type -> TypeScheme

    (********
    Close a typescheme using the specified type variables
    ********)

    val Close : (TyVar list * TypeScheme) -> TypeScheme

    (********
    Find free type variables
    ********)

    val tyvarsTySch : TypeScheme -> TyVar list
    and tyvarsTy    : Type -> TyVar list

    (********
    Substitutions
    ********)

    type Substitution
    val onScheme : Substitution * TypeScheme -> TypeScheme
    and on : Substitution * Type  -> Type
    and oo : Substitution * Substitution -> Substitution
    and Id : Substitution

    (********
    TyName sets
    ********)

    type TyNameSet

    val isIn     : TyName * TyNameSet -> bool
    val isemptyT : TyNameSet -> bool

    val emptyTyNameSet     : TyNameSet
    and singleTyNameSet    : TyName -> TyNameSet
    and eqTyNameSet        : TyNameSet * TyNameSet -> bool
    and TyNameSetUnion     : TyNameSet * TyNameSet -> TyNameSet
    and TyNameSetIntersect : TyNameSet * TyNameSet -> TyNameSet
    and TyNameSetMinus     : TyNameSet * TyNameSet -> TyNameSet
    val TyNameSetFold      : (TyName * 'a -> 'a) -> 'a -> TyNameSet -> 'a

    (********
    Type functions
    ********)

    eqtype TypeFcn
    val mkTypeFcn         : TyVar list * Type -> TypeFcn
    and admits_equality   : TypeFcn -> bool
    and grounded_TypeFcn  : TypeFcn * TyNameSet -> bool
    and TyName_in_TypeFcn : TyName -> TypeFcn
    and applyTypeFcn      : TypeFcn * Type list -> Type
    and arity_TypeFcn     : TypeFcn -> int
    and unTyName_TypeFcn  : TypeFcn -> TyName Option

    val bogus_TypeFcn: TypeFcn

   (* Printing of type functions returns two strings. This is because
      something like

	type ('a, 'b) Foo = int

      maps Foo to "/\('a, 'b).int" and we need to take this apart to get
      the correct printout. *)

    val pr_TypeFcnPRETTY: TVNames -> TypeFcn -> {vars: string, body: string}
(* mju#1.6 *)
    val pr_TypeFcn : TypeFcn -> string
(* endmju#1.6 *)

    (********
    Get TyNames
    ********)

    val TyNamesTySch   : TypeScheme -> TyNameSet
    and TyNamesTy      : Type -> TyNameSet
    and TyNamesTypeFcn : TypeFcn -> TyNameSet

    (*********
    Type Realisations
    *********)

    type tyrea
    val id_tyrea            : tyrea
    val oo_tyrea            : tyrea * tyrea -> tyrea
    val mktyrea             : TyName * TypeFcn -> tyrea
    val mktyrea_class       : TyName list * TypeFcn -> tyrea
    val restrict_tyrea      : TyNameSet -> tyrea -> tyrea
    val tyrea_on_TyName     : tyrea -> TyName -> TypeFcn
    val tyrea_on_Type       : tyrea -> Type -> Type
    val tyrea_on_TypeFcn    : tyrea -> TypeFcn -> TypeFcn
    val tyrea_on_TypeScheme : tyrea -> TypeScheme -> TypeScheme

    (********
    Function which generates a type realisation from a TyNameSet.
    *********
    All the TyNames in the TyNameSet are renamed to fresh TyNames with
    their equality attributes set to be true.
    ********)

    val generate_tyrea : TyNameSet -> tyrea

    (********
    Function which checks if the typescheme of a contructor violates equality
    *********
    Respecting equality for constructors is as defined in the Definition on page 21.
    All the tynames in the TyNameSet are considered to admit equality.
    ********)

    val violates_equality : TyNameSet * TypeScheme -> bool

    (********
    PrettyPrinter hooks
    ********)

    type StringTree
    val layoutType       : Type       -> StringTree
    and layoutTypeFcn    : TypeFcn    -> StringTree
    and layoutTypeScheme : TypeScheme -> StringTree
    and layoutTyNameSet  : TyNameSet  -> StringTree
  end;
