(* Objects of the static semantics - Definition page 16-22 *)

(*
$File: Common/STATOBJECT.sml $
$Date: 1992/12/30 14:48:15 $
$Revision: 1.9 $
$Locker: birkedal $
*)

(*$STATOBJECT *)

signature STATOBJECT =
  sig 
    type TVNames			(* Association list for the printing *)
    val newTVNames: unit -> TVNames	(* of type variables. *)

    (********
    The type SyntaxTyVar is the type of syntactic type variables
    ********)

    type SyntaxTyVar

    (********
    Type variables
    ********)

    eqtype TyVar
    val freshTyVar : {equality : bool, imperative : bool, overloaded : bool} -> TyVar
    and mkExplicitTyVar : SyntaxTyVar -> TyVar
    val pr_TyVar: TyVar -> string
    val pr_TyVarPRETTY: TVNames -> TyVar -> string

    (****
    Types
    ****)

    eqtype Type and FunType and ConsType and RecType
    val getOverloadedTyVar : Type -> TyVar Option  
    val isImperativeType : Type -> bool
    val existsRecVarsType : Type -> bool
    val tyvarsTy : Type -> TyVar list
    val pr_Type: Type -> string
    val pr_TypePRETTY: TVNames -> Type -> string

    (********
    TypeSchemes
    ********)

    type TypeScheme
(* mikon#1.37 *)
     val tyvarsTySch : TypeScheme -> TyVar list
(* end mikon#1.37 *)

    (********
    Type constructors
    ********)

    type tycon

    (********
    Type names
    ********)

    type TyName
    val freshTyName : {name : tycon, arity : int, equality : bool} -> TyName

    (********
    Get an instance of a TypeScheme
    ********)

    val instance : TypeScheme -> Type

    (********
    Construct and destruct types
    ********)

    val mkTypeTyVar : TyVar -> Type
    and unTypeTyVar : Type -> TyVar Option

    val mkTypeRecType : RecType -> Type
    and unTypeRecType : Type -> RecType Option

  (*
    val mkTypeFunType : FunType -> Type
    and unTypeFunType : Type -> FunType Option
  *)

    val mkTypeConsType : ConsType -> Type
    and unTypeConsType : Type -> ConsType Option

    (********
    Record labels
    ********)

    type lab

    (********
    Construct and destruct record types
    ********)

    val emptyRecType : RecType			(* "{}" *)
    val emptyFlexRecType: unit -> RecType	(* "{...}" *)

    val addField     : lab * Type -> RecType -> RecType

    val mkTypePair : Type * Type -> Type
    and unRecPair : RecType -> Type * Type

    val sortedLabsOfRecType: RecType -> lab list
					(* Needed by compiler. *)


    val TypeUnit : Type

    (********
    Construct and destruct function types
    ********)

    val mkFunType : Type * Type -> FunType
    and unFunType : FunType -> (Type * Type) Option

    (********
    Construct and destruct constructed types
    ********)

    val mkConsType : Type list * TyName -> ConsType
    and unConsType : ConsType -> (Type list * TyName) Option

    (********
    Construct and destruct type schemes
    ********)

    val unTypeScheme : TypeScheme -> TyVar list * Type

    (********
    Make a type into a typescheme with no bound variables
    ********)

    val Type_in_TypeScheme : Type -> TypeScheme

    (********
    Derived constructors and destructors
    ********)

    val TypeExn: Type
    and isTypeExn: Type -> bool

    val mkTypeArrow: Type * Type -> Type
    and unTypeArrow: Type -> (Type * Type) Option
    val isTypeArrow: Type -> bool

    (********
    Special constants
    ********)

    type scon

    (********  
    Get type of special constants
    ********)

    val TypeInt : Type
    and TypeReal : Type
    val GetTypescon : scon -> Type

(* mikon#2 *)
    val TypeBool : Type
(* end mikon#2 *)

    (********
    Substitutions
    ********)

    type Substitution
    val on : Substitution * Type  -> Type
    and oo : Substitution * Substitution -> Substitution
    and Id : Substitution

    val bogus_Subst: Substitution	(* Substitution to use on error. *)

    (********
    Unification of types
    ********)

    val unify : Type * Type -> Substitution Option

    (********
    Qualified identifiers
    ********)

    type longid

    (********
    Structure identifiers
    ********)

    type strid

    (********
    Unqualified identifiers
    ********)

    eqtype id

    (********
    Function for decomposing a qualified identifier
    ********)

    val decomposeLongId : longid -> strid list * id

    (********
    Unqualified variables
    ********)

    type var

    (********
    Conversion of ids to vars
    ********)

    val mk_var : id -> var

    (********
    Qualified variables
    ********)

    type longvar

    val decomposeLongVar: longvar -> strid list * var
					(* That's needed when decomposing
					   identifiers in a *resolved*
					   grammar (it happens in RECVALbind
					   elaboration). *)

    (********
    Qualified constructors
    ********)

    type longcon

    (********
    Qualified exception constructors
    ********)

    type longexcon

    (********
    Conversion of longids to longvars, longcons and longexcons
    ********)

    val mk_longcon   : longid -> longcon
    and mk_longvar   : longid -> longvar
    and mk_longexcon : longid -> longexcon

    (********
    Bogus values used to build dummy nodes on the syntax tree
    ********)

    val bogusVar   : longvar
    and bogusCon   : longcon
    and bogusExcon : longexcon

    (********
    Type functions
    ********)

    eqtype TypeFcn
    val mkTypeFcn     : TyVar list * Type   -> TypeFcn
    and applyTypeFcn  : TypeFcn * Type list -> Type
(* mikon#1.9 *)
    and admits_equality : TypeFcn -> bool
(* end mikon#1.9 *)
    and arity_TypeFcn : TypeFcn -> int
    and TyName_in_TypeFcn : TyName  -> TypeFcn
    and unTyName_TypeFcn  : TypeFcn -> TyName Option
(* mju#1.6 *)
    and bogus_TypeFcn : TypeFcn
(* endmju#1.6 *)

    (********
    Printing functions for longid's (for error reporting)
    ********)

    val pr_longid : longid -> string

    (********
    PrettyPrinter hooks
    ********)

    type StringTree
    val layoutTyName: TyName -> StringTree
    val layoutTyVar: TyVar -> StringTree
    val layoutType : Type -> StringTree
  end;
