(* Information attached to parsetree before elaboration *)

(*
$File: Common/PRE_GRAMMAR_INFO.sml $
$Date: 1995/12/16 19:21:30 $
$Revision: 1.0 $
$Locker: mikon $
*)

(*$PRE_GRAMMAR_INFO*)
signature PRE_GRAMMAR_INFO =
sig
   (* The constituent info types. *)

    type SourceInfo and DFInfo 

   (* The composite info type *)

    type PreElabGrammarInfo 

    val emptyPreElabGrammarInfo:  PreElabGrammarInfo

    val addPreElabSourceInfo:
      PreElabGrammarInfo -> SourceInfo -> PreElabGrammarInfo

    val addPreElabDFInfo:
      PreElabGrammarInfo -> DFInfo -> PreElabGrammarInfo

    val getPreElabSourceInfo: PreElabGrammarInfo -> SourceInfo Option
    val getPreElabDFInfo:     PreElabGrammarInfo -> DFInfo Option

    type StringTree
    val layoutDFInfo:          DFInfo -> StringTree
    val layoutSourceInfo:      SourceInfo -> StringTree

    val layoutPreElabGrammarInfo:  PreElabGrammarInfo -> StringTree

end;
