(* Core Trace *)

(*
$File: Common/CoreTrace.sml $
$Date: 1995/12/11 21:24:17 $
$Revision: 1.0 $
$Locker: mikon $
*)

(*$CoreTrace:
	ENVIRONMENTS CORE_TRACE
 *)

functor CoreTrace
    ( structure Crash: CRASH
      structure Environments : ENVIRONMENTS ) : CORE_TRACE =
struct
    
    type Type   = Environments.Type
    and Env     = Environments.Env
    and Context = Environments.Context
    and TyEnv   = Environments.TyEnv 
    and VarEnv  = Environments.VarEnv
    and TyRea   = Environments.tyrea
    and TyVar   = Environments.TyVar
(* mikon#1.37 *)
    and Substitution = Environments.Substitution
(* end mikon#1.37 *)
(* mikon#1.39 *)
    and TyName = Environments.TyName
(* end mikon#1.39 *)

    datatype Trace = 
	TRACE of SchemeTrace Option * SimTrace Option

    and SimTrace = 
	TYPE of Type
      | ENV of Env
      | CONTEXTxTYPE of Context * Type
      | CONTEXTxENV of Context * Env
      | TYENV of TyEnv
      | VARENVxTYREA of VarEnv * TyRea
(* mikon#1.39 *)
      | CONTEXTxTYNAME of Context * TyName
(* end mikon#1.39 *)

    and SchemeTrace =
	SCHEME_C of Context
      | TYVARS of TyVar list

(* mikon#1.37 *)
    fun onScheme (S, SCHEME_C(C)) = SCHEME_C(Environments.onC (S, C))
      | onScheme (S, TYVARS(_))   = Crash.impossible "CoreTrace.onScheme"

    fun onScheme_opt (S, Some(scheme)) = Some(onScheme (S, scheme))
      | onScheme_opt (S, None)          = None

    fun onSim (S, TYPE(tau)) = TYPE(Environments.on (S, tau))
      | onSim (S, ENV(E)) = ENV(Environments.onE (S, E))
      | onSim (S, CONTEXTxTYPE(C, tau)) = CONTEXTxTYPE(Environments.onC (S, C), Environments.on (S, tau))
      | onSim (S, CONTEXTxENV(C, E)) = CONTEXTxENV(Environments.onC (S, C), Environments.onE (S, E))
      | onSim (S, TYENV(TE)) = TYENV(TE)
      | onSim (S, VARENVxTYREA(VE, phi_Ty)) = VARENVxTYREA(VE, phi_Ty)
(* mikon#1.39 *)
      | onSim (S, CONTEXTxTYNAME(C, t)) = CONTEXTxTYNAME(Environments.onC (S, C), t)
(* end mikon#1.39 *)

    fun onSim_opt (S, Some(sim)) = Some(onSim (S, sim))
      | onSim_opt (S, None)      = None

    fun onCoreTrace (S, TRACE(scheme_opt, sim_opt)) = 
	TRACE(onScheme_opt (S, scheme_opt), onSim_opt (S, sim_opt))   

    fun tyvars_sim (TYPE(tau)) = Environments.tyvarsTy tau
      | tyvars_sim (ENV(E)) = Environments.tyvarsE E
      | tyvars_sim (CONTEXTxTYPE(C, tau)) = (Environments.tyvarsC C) @ (Environments.tyvarsTy tau)
      | tyvars_sim (CONTEXTxENV(C, E)) = (Environments.tyvarsC C) @ (Environments.tyvarsE E)
      | tyvars_sim (TYENV(TE)) = []
      | tyvars_sim (VARENVxTYREA(VE, phi_Ty)) = []
(* mikon#1.39 *)
      | tyvars_sim (CONTEXTxTYNAME(C, t)) = Environments.tyvarsC C
(* end mikon#1.39 *)

    fun tyvars_sim_opt (Some(sim)) = tyvars_sim sim
      | tyvars_sim_opt None = []

    fun minus(list1, list2) =
      List.all (fn x => not(List.member x list2)) list1

    fun process_core_trace_and_tvs (core_trace, tvs) S = 
	      let  
		  val core_trace' as (TRACE(scheme_opt, sim_opt)) = onCoreTrace (S, core_trace)
		  val sim_opt_tvs = tyvars_sim_opt sim_opt
		  val free_tvs = sim_opt_tvs @ tvs
	      in
		  case scheme_opt 
		    of None => (core_trace', free_tvs)
		     | Some(SCHEME_C(C)) => 
			let
			    val tvs_to_bind = minus (free_tvs, Environments.tyvarsC C)
			in
			    (TRACE(Some(TYVARS(tvs_to_bind)), sim_opt), minus (free_tvs, tvs_to_bind))
			end
		     | Some(TYVARS(_)) => Crash.impossible "CoreTrace.process_core_trace_and_tvs" 
	      end
(* end mikon#1.37 *)
	
end;
