(* constructors - Definition v3 page 4 *)

(*
$File: Common/CON.sml $
$Date: 1992/03/09 15:00:31 $
$Revision: 1.15 $
$Locker: birkedal $
*)

(*$CON *)

signature CON = 
  sig 
    type id and longid and strid

    eqtype longcon
    val mk_longcon : longid  -> longcon
    and pr_longcon : longcon -> string

    eqtype con
    val mk_con : id  -> con
(* leszczyk#1.6 *)
    and un_con : con -> id
(* end leszczyk#1.6 *)
    and pr_con : con -> string

    val mk_Con: string -> con		(* NEW PARSER *)

    val decompose : longcon -> strid list * con

    val < : con * con -> bool

    val con_to_id : con -> id

   (* The constructor "ref" *)
    val con_REF : con

   (* `true' and `false' are needed as constructors for the *dynamic* semantics
      so that the pervasives can return boolean results. They mustn't be used
      for the static semantics since datatype `bool' is defined in the
      prelude. *)

    val con_TRUE: con
    val con_FALSE: con

   (* `nil' and `::' needed similarly (implementation of `implode' and
      `explode' for instance). Again, the prelude carries the definitions
      for the static environment. *)

    val con_NIL: con
    val con_CONS: con

   (* A bogus long constructor *)
    val bogus : longcon
  end;
