(setq auto-mode-alist
       (append '(("\\.dul$" . caml-mode)
		 ) auto-mode-alist))

(if window-system

(progn

(cond
 ((and (x-display-color-p)
       (not (memq 'font-lock-type-face (face-list))))
  ; make the necessary faces
  (make-face 'Firebrick)
  (set-face-foreground 'Firebrick "Firebrick")
  (make-face 'RosyBrown)
  (set-face-foreground 'RosyBrown "RosyBrown")
  (make-face 'Purple)
  (set-face-foreground 'Purple "Purple")
  (make-face 'MidnightBlue)
  (set-face-foreground 'MidnightBlue "MidnightBlue")
  (make-face 'DarkGoldenRod)
  (set-face-foreground 'DarkGoldenRod "DarkGoldenRod")
  (make-face 'DarkOliveGreen)
  (set-face-foreground 'DarkOliveGreen "DarkOliveGreen4")
  (make-face 'CadetBlue)
  (set-face-foreground 'CadetBlue "CadetBlue")
  ; assign them as standard faces
  (setq font-lock-comment-face 'Firebrick)
  (setq font-lock-string-face 'RosyBrown)
  (setq font-lock-keyword-face 'Purple)
  (setq font-lock-function-name-face 'MidnightBlue)
  (setq font-lock-variable-name-face 'DarkGoldenRod)
  (setq font-lock-type-face 'DarkOliveGreen)
  (setq font-lock-reference-face 'CadetBlue)))

  (make-face 'Coral)
  (set-face-foreground 'Coral "coral2")
  (setq font-lock-builtin-face 'Coral)

  ; extra faces for documention
  (make-face 'Stop)
  (set-face-foreground 'Stop "White")
  (set-face-background 'Stop "Red")
  (make-face 'Doc)
  (set-face-foreground 'Doc "Red")
  (setq font-lock-stop-face 'Stop)
  (setq font-lock-doccomment-face 'Doc)

(defvar caml-quote-char "'"
  "*Quote for character constants. \"'\" for Objective Caml, \"`\" for Caml-Light.")

(defconst caml-font-lock-keywords
  (list
;stop special comments
   '("\\(^\\|[^\"]\\)\\((\\*\\*/\\*\\*)\\)"
     2 font-lock-stop-face)
;doccomments
   '("\\(^\\|[^\"]\\)\\((\\*\\*[^*]*\\([^)*][^*]*\\*+\\)*)\\)"
     2 font-lock-doccomment-face)
;comments
   '("\\(^\\|[^\"]\\)\\((\\*[^*]*\\*+\\([^)*][^*]*\\*+\\)*)\\)"
     2 font-lock-comment-face)
;character literals
   (cons (concat caml-quote-char "\\(\\\\\\([ntbr" caml-quote-char "\\]\\|"
                 "[0-9][0-9][0-9]\\)\\|.\\)" caml-quote-char
                 "\\|\"[^\"\\]*\\(\\\\\\(.\\|\n\\)[^\"\\]*\\)*\"")
         'font-lock-string-face)
;dule constructors
   '("`\\<[A-Za-z][A-Za-z0-9_']*\\>" . font-lock-builtin-face)
;modules and ocaml constructors
   '("\\<[A-Z][A-Za-z0-9_']*\\>" . font-lock-function-name-face)
;definition
   (cons "\\<\\(a\\(nd\\|s\\|ssert\\)\\|c\\(?:lass\\|o\\(?:ind\\|n\\(?:straint\\)?\\)\\)\\|de\\|ex\\(?:ception\\|ternal\\)\\|f\\(?:old\\|un\\(?:ct\\(?:ion\\|or\\)\\)?\\)\\|in\\(?:d\\|herit\\|itializer\\)?\\|l\\(?:et\\|ibrary\\)\\|m\\(?:ap\\|ethod\\|\\(?:odu\\|utab\\)le\\)\\|of\\|p\\(?:arser\\|rivate\\)\\|rec\\|spec\\|type\\|un\\(?:con\\|de\\|fold\\)\\|v\\(al\\(ue\\)?\\|irtual\\)\\)\\>"

;(concat
;          "\\<\\(a\\(nd\\|s\\|ssert\\)\\|c\\(onstraint\\|lass\\)"
;          "\\|ex\\(ception\\|ternal\\)\\|fun\\(ct\\(ion\\|or\\)\\)?"
;          "\\|in\\(herit\\|itializer\\)?\\|let"
;          "\\|m\\(ethod\\|utable\\|odule\\)"
;          "\\|of\\|p\\(arser\\|rivate\\)\\|rec\\|type"
;"\\|library\\|spec\\|ind\\|coind\\|map\\|con\\|fold\\|de\\|uncon\\|unfold\\|unde" 
;          "\\|v\\(al\\(ue\\)?\\|irtual\\)\\)\\>")

         'font-lock-type-face)
;blocking --- link added
   '("\\<\\(begin\\|end\\|link\\|object\\|s\\(ig\\|truct\\)\\)\\>"
     . font-lock-keyword-face)
;control --- load added
   (cons (concat
          "\\<\\(do\\(ne\\|wnto\\)?\\|else\\|for\\|i\\(f\\|gnore\\)"
          "\\|l\\(azy\\|oad\\)\\|match\\|new\\|or\\|t\\(hen\\|o\\|ry\\)"
          "\\|w\\(h\\(en\\|ile\\)\\|ith\\)\\)\\>"
          "\\|\|\\|->\\|&\\|#")
         'font-lock-reference-face)
   '("\\<\\(fail\\|raise\\)\\>" . font-lock-comment-face)
;labels (and open)
   '("\\(\\([~?]\\|\\<\\)[a-zA-Z][a-zA-Z0-9_']*:\\)[^:=]" 1
     font-lock-variable-name-face)
   '("\\<\\(open\\|include\\)\\>\\|[~?][ (]*[a-zA-Z][a-zA-Z0-9_']*\\|[~]"
     . font-lock-variable-name-face)
))

(defconst inferior-caml-font-lock-keywords
  (append
   (list
;inferior
    '("^[#-]" . font-lock-comment-face))
   caml-font-lock-keywords))

(setq caml-mode-hook
      '(lambda ()
         (cond
          ((fboundp 'global-font-lock-mode)
           (make-local-variable 'font-lock-defaults)
           (setq font-lock-defaults
                 '(caml-font-lock-keywords nil nil ((?' . "w") (?_ . "w")))))
          (t
           (setq font-lock-keywords caml-font-lock-keywords)))
         (make-local-variable 'font-lock-keywords-only)
         (setq font-lock-keywords-only t)
         (font-lock-mode 1)))

(defun inferior-caml-mode-font-hook ()
  (cond
   ((fboundp 'global-font-lock-mode)
    (make-local-variable 'font-lock-defaults)
    (setq font-lock-defaults
          '(inferior-caml-font-lock-keywords
            nil nil ((?' . "w") (?_ . "w")))))
   (t
    (setq font-lock-keywords inferior-caml-font-lock-keywords)))
  (make-local-variable 'font-lock-keywords-only)
  (setq font-lock-keywords-only t)
  (font-lock-mode 1))

(add-hook 'inferior-caml-mode-hooks 'inferior-caml-mode-font-hook)))

;;;(provide 'caml-font)
