/* Patryk Czarnik */
/* Systemy Operacyjne zad3 */

#include <linux/config.h>
#include <linux/module.h>

#include <linux/errno.h>
#include <linux/major.h>
#include <asm/uaccess.h>
#include <linux/kernel.h>
#include <linux/signal.h>

/* Deal with CONFIG_MODVERSIONS */
#if CONFIG_MODVERSIONS==1
#define MODVERSIONS
#include <linux/modversions.h>
#endif

/* For character devices */
#include <linux/fs.h>
#include <linux/wrapper.h>

/* We use proc fs */
#include <linux/proc_fs.h>

#ifndef AZT_KERNEL_PRIOR_2_1 
#define  memcpy_fromfs copy_from_user
#define  memcpy_tofs   copy_to_user
#endif

#include <linux/malloc.h>

#ifndef KERNEL_VERSION
#define KERNEL_VERSION(a,b,c) ((a)*65536+(b)*256+(c))
#endif

/* Conditional compilation. LINUX_VERSION_CODE is
 * the code (as per KERNEL_VERSION) of this version. */
#if LINUX_VERSION_CODE > KERNEL_VERSION(2,2,0)
#include <asm/uaccess.h>  /* for put_user */
#endif

extern int printk(const char *, ...);
extern int sprintf(char *, const char *, ...);
extern size_t strlen(const char *);

/* W jadrze 2.2.12 trzeba bylo: */
/* extern int module_unregister_chrdev(int, const char*); */
/* extern int module_register_chrdev(int, const char*, struct file_operations*); */

/* dlugosc napisu mieszczacego liczbe typu int */
#define DLUG_INT 12

#define SUCCESS 0

/*  Definicje dotyczace urzadzenia */

#define DEVICE_NAME "buf_dev"

/* Domyslny glowny urzadzenia - 0 oznacza dynamiczne znajdowanie wolnego */
#define DEF_MAJOR 0

#define MAKS_ROZM_BUF 131071  /* 128 kB - 1 */
/* Domyslny rozmiar bufora */
#define DOM_ROZM_BUF 20

/* priority dla funkcji kmalloc */
#define KM_PRIORITY 0

/* Bufor bedzie buforem cyklicznym z indeksami poczatku i konca.
 * Wpisuje sie do niego na koniec, czyta z poczatku.
 * pocz_buf i konc_buf mieszcza sie w przedziale od 0 do rozm_buf-1
 * pocz_buf == konc_buf oznacza pusty bufor
 * konc_buf - pocz_buf == 1 (mod rozm_buf) oznacza pelny
 * bufor miesci wiec rozm_buf-1 znakow
 */
static char *moj_bufor;
static int rozm_buf;
static int pocz_buf;
static int konc_buf;

/* Moja implementacja funkcji pomocniczej (dziala dobrze w kontekscie 
 * tego zadania, nie jest uniwersalna) */
int atoi(const char *napis, int maks)
{
  int wynik;
  
  wynik = 0;
  while(*napis!='\0' && *napis !='\n' && *napis!=' ' && *napis!='\t'){
   if(*napis < '0' || *napis >'9')
     return -1;
   wynik *= 10;
   wynik += (*napis - '0');
   napis++;
   if(wynik > maks)
     return -1;
  }
  return wynik;
}

/* Funkcje obslugi urzadzenia 0 */

#if LINUX_VERSION_CODE >= KERNEL_VERSION(2,2,0)
static ssize_t read_0(struct file *file, char *buffer,
    size_t length, loff_t *offset)
#else
static int read_0(struct inode *inode, struct file *file,
    char *buffer, int length)
#endif
{
  return 0;  /* od razu koniec strumienia */
}

#if LINUX_VERSION_CODE >= KERNEL_VERSION(2,2,0)
static ssize_t write_0(struct file *file, const char *buffer,
    size_t length, loff_t *offset)
#else
static int buf_write(struct inode *inode, struct file *file,
    const char *buffer, int length)
#endif
{
  int wpisz;

  if(rozm_buf == 0)
    return length;
  wpisz = length < rozm_buf ? length : rozm_buf - 1;
  buffer += (length - wpisz);
  for(; wpisz>0; wpisz--, buffer++){
#if LINUX_VERSION_CODE >= KERNEL_VERSION(2,2,0)
    get_user(moj_bufor[konc_buf],buffer);
#else
    moj_bufor[konc_buf] = get_user(buffer);
#endif
    konc_buf = (konc_buf+1) % rozm_buf;
    if(pocz_buf == konc_buf)
      pocz_buf = (pocz_buf+1) % rozm_buf;
  }
  return length;
}

/* Funkcje obslugi urzadzenia 1 */

#if LINUX_VERSION_CODE >= KERNEL_VERSION(2,2,0)
static ssize_t read_1(struct file *file, char *buffer,
    size_t length, loff_t *offset)
#else
static int read_1(struct inode *inode, struct file *file,
    char *buffer, int length)
#endif
{
  int wczytane = 0;
  
  if(rozm_buf == 0)
    return 0;
  for(;wczytane<length && pocz_buf!=konc_buf; wczytane++,buffer++){
    put_user(moj_bufor[pocz_buf], buffer);
    pocz_buf = (pocz_buf+1) % rozm_buf;
  }
  return wczytane;
}

#if LINUX_VERSION_CODE >= KERNEL_VERSION(2,2,0)
static ssize_t write_1(struct file *file, const char *buffer,
    size_t length, loff_t *offset)
#else
static int null_write(struct inode *inode, struct file *file,
    const char *buffer, int length)
#endif
{
  return length;  /* "wczytano" wszystko */
}

/* Deklaracje globalnych obiektow niezbednych dalej */

static int Major;

static int device_open(struct inode*, struct file*);

#if LINUX_VERSION_CODE >= KERNEL_VERSION(2,2,0)
static int device_release(struct inode*, struct file*);
#else
static void device_release(struct inode*,struct file*);
#endif

/* Zbiory operacji na urzadzeniach 0 i 1 */

static struct file_operations fops_0 = {
  NULL,   /* seek */
  read_0,
  write_0,
  NULL,   /* readdir */
  NULL,   /* select */
  NULL,   /* ioctl */
  NULL,   /* mmap */
  device_open,
#if LINUX_VERSION_CODE >= KERNEL_VERSION(2,2,0)
  NULL,   /* flush */
#endif
  device_release
};

static struct file_operations fops_1 = {
  NULL,   /* seek */
  read_1,
  write_1,
  NULL,   /* readdir */
  NULL,   /* select */
  NULL,   /* ioctl */
  NULL,   /* mmap */
  device_open,
#if LINUX_VERSION_CODE >= KERNEL_VERSION(2,2,0)
  NULL,   /* flush */
#endif
  device_release
};

/* Funkcje open i close - wspolne dla obu urzadzen */

static int device_open(struct inode *ino,
                       struct file *filep)
{
  MOD_INC_USE_COUNT;

  switch(MINOR(ino->i_rdev)){ /* przypisz odpowiedni zbior operacji */
    case 0: filep->f_op = &fops_0; break;
    case 1: filep->f_op = &fops_1; break;
  }

  return SUCCESS;
}

#if LINUX_VERSION_CODE >= KERNEL_VERSION(2,2,0)
static int device_release(struct inode *ino,
                          struct file *filep)
#else
static void device_release(struct inode *ino,
                           struct file *filep)
#endif
{
  MOD_DEC_USE_COUNT;

#if LINUX_VERSION_CODE >= KERNEL_VERSION(2,2,0)
  return 0;
#endif
}

/* Funkcje proc */

/* Funkcja pomocnicza */
static ssize_t proc_read(char *buf, size_t len, int wartosc)
{
  char napis[DLUG_INT];
  char *p = napis;
  
  sprintf(napis,"%d",wartosc);
  if(len <= strlen(napis))
    return -1;
  while(*p){
    put_user(*p, buf);
    p++; buf++;
  }
  put_user('\0', buf);
    
  return p - napis +1;
}

#if LINUX_VERSION_CODE >= KERNEL_VERSION(2,2,0)
static ssize_t null_data_size_read(struct file *file, char *buf,
    size_t len, loff_t *offset)
#else
static int null_data_size_read(struct inode *inode, struct file *file,
    char *buf, int len)
#endif
{
  static int uzyto = 0; /* zeby nie pisac w petli nieskonczonej */
  
  if(uzyto) {
    uzyto = 0;
    return 0;
  }
  else {
    uzyto = 1;
    return proc_read(buf, len, (rozm_buf + konc_buf - pocz_buf) % rozm_buf);
  }
}

#if LINUX_VERSION_CODE >= KERNEL_VERSION(2,2,0)
static ssize_t null_size_read(struct file *file, char *buf,
    size_t len, loff_t *offset)
#else
static int null_size_read(struct inode *inode, struct file *file,
    char *buf, int len)
#endif
{
  static int uzyto = 0;
  
  if(uzyto) {
    uzyto = 0;
    return 0;
  }
  else {
    uzyto = 1;
    return proc_read(buf, len, rozm_buf - 1);
  }
}

#if LINUX_VERSION_CODE >= KERNEL_VERSION(2,2,0)
static ssize_t null_size_write(struct file *file, const char *buf,
    size_t length, loff_t *offset)
#else
static int null_size_write(struct inode *inode, struct file *file,
    const char *buf, int length)
#endif
{
  char napis[DLUG_INT];
  int i, liczba;

  if(length >= DLUG_INT){
    printk("za dlugi\n");
    return length;
  }
  for(i=0; i<length; i++)
#if LINUX_VERSION_CODE >= KERNEL_VERSION(2,2,0)
    get_user(napis[i], buf+i);
#else
    napis[i] = get_user(buf+i);
#endif
  napis[i] = '\0';
  liczba = atoi(napis, MAKS_ROZM_BUF);
  if(liczba >= 0 && liczba < MAKS_ROZM_BUF){
    rozm_buf = liczba + 1;
    if(moj_bufor != 0)
      kfree(moj_bufor);
    if(rozm_buf > 1){
      moj_bufor = (char *)kmalloc(rozm_buf, KM_PRIORITY);
      if(moj_bufor == 0){
        rozm_buf = 0;
        printk("Brak pamieci! rozmiar bufora zero\n");
      }
    } else
      rozm_buf = 0;
    pocz_buf = 0;
    konc_buf = 0;
  }
  return length;
}

/* Uprawnienia dostepu do plikow proc */
static int null_size_perm(struct inode *inode, int op)
{
  /* Kazdy moze czytac i pisac */
  if (op == 4 || op == 2)
    return 0;
  else
    return -EACCES;
}

static int null_data_size_perm(struct inode *inode, int op)
{
  /* Kazdy moze czytac i nic wiecej */
  if (op == 4)
    return 0;
  else
    return -EACCES;
}

int proc_open(struct inode *inode, struct file *file)
{
  MOD_INC_USE_COUNT;

  return 0;
}

#if LINUX_VERSION_CODE >= KERNEL_VERSION(2,2,0)
int proc_close(struct inode *inode, struct file *file)
#else
void proc_close(struct inode *inode, struct file *file)
#endif
{
  MOD_DEC_USE_COUNT;

#if LINUX_VERSION_CODE >= KERNEL_VERSION(2,2,0)
  return 0;  /* success */
#endif
}

/* Struktury dla plikow systemu proc */
/* null_size */

static struct file_operations null_size_fops =
  {
    NULL,  /* lseek */
    null_size_read,
    null_size_write,
    NULL,  /* readdir */
    NULL,  /* select */
    NULL,  /* ioctl */
    NULL,  /* mmap */
    proc_open,    /* Somebody opened the file */
#if LINUX_VERSION_CODE >= KERNEL_VERSION(2,2,0)
    NULL,   /* flush, added here in version 2.2 */
#endif
    proc_close
  };

static struct inode_operations null_size_iops =
  {
    &null_size_fops,
    NULL, /* create */
    NULL, /* lookup */
    NULL, /* link */
    NULL, /* unlink */
    NULL, /* symlink */
    NULL, /* mkdir */
    NULL, /* rmdir */
    NULL, /* mknod */
    NULL, /* rename */
    NULL, /* readlink */
    NULL, /* follow_link */
    NULL, /* readpage */
    NULL, /* writepage */
    NULL, /* bmap */
    NULL, /* truncate */
    null_size_perm
  };

static struct proc_dir_entry null_size_entry =
  {
    0, /* Inode number - ignore, it will be filled by
        * proc_register[_dynamic] */
    9, /* Length of the file name */
    "null_size", /* The file name */
    S_IFREG | S_IRUGO | S_IWUSR,
    1,  /* Number of links (directories where the
         * file is referenced) */
    0, 0,  /* The uid and gid for the file -
            * we give it to root */
    DLUG_INT, /* The size of the file reported by ls. */
    &null_size_iops,
    NULL
    /* The read function for the file. Irrelevant,
     * because we put it in the inode structure above */
  };

/* null_data_size */

static struct file_operations null_data_size_fops =
  {
    NULL,  /* lseek */
    null_data_size_read,
    NULL,  /* write */
    NULL,  /* readdir */
    NULL,  /* select */
    NULL,  /* ioctl */
    NULL,  /* mmap */
    proc_open,
#if LINUX_VERSION_CODE >= KERNEL_VERSION(2,2,0)
    NULL,   /* flush, added here in version 2.2 */
#endif
    proc_close
  };

static struct inode_operations null_data_size_iops =
  {
    &null_data_size_fops,
    NULL, /* create */
    NULL, /* lookup */
    NULL, /* link */
    NULL, /* unlink */
    NULL, /* symlink */
    NULL, /* mkdir */
    NULL, /* rmdir */
    NULL, /* mknod */
    NULL, /* rename */
    NULL, /* readlink */
    NULL, /* follow_link */
    NULL, /* readpage */
    NULL, /* writepage */
    NULL, /* bmap */
    NULL, /* truncate */
    null_data_size_perm
  };

static struct proc_dir_entry null_data_size_entry =
  {
    0, /* Inode number - ignore, it will be filled by
        * proc_register[_dynamic] */
    14, /* Length of the file name */
    "null_data_size", /* The file name */
    S_IFREG | S_IRUGO,
    1,  /* Number of links (directories where the
         * file is referenced) */
    0, 0,  /* The uid and gid for the file -
            * we give it to root */
    DLUG_INT, /* The size of the file reported by ls. */
    &null_data_size_iops,
    NULL
    /* The read function for the file. Irrelevant,
     * because we put it in the inode structure above */
  };

/* Funkcje modulu */

/* parametr */

int bufsize = DOM_ROZM_BUF;
#if LINUX_VERSION_CODE >= KERNEL_VERSION(2,2,0)
  MODULE_PARM(bufsize, "i");
#endif

int init_module()
{
  int ret;
  
  if(bufsize < 0 || bufsize > MAKS_ROZM_BUF){
    printk("Nieprawidowa wartosc parametru\n");
    return -EINVAL;
  }
  
  Major = module_register_chrdev(DEF_MAJOR, DEVICE_NAME, &fops_0);
  if (Major < 0) {
    printk ("device failed with %d\n", Major);
    return Major;
  }
  printk ("Zainstalowano urzadzenie pod numerem glownym %d.\n", Major);

/* inicjalizacja bufora */
  rozm_buf = bufsize+1;
  if(rozm_buf >1){
    moj_bufor = (char *)kmalloc(rozm_buf, KM_PRIORITY);
    if(moj_bufor == 0){
      rozm_buf = 0;
      printk("Brak pamieci! rozmiar bufora zero\n");
    }
  } else
    rozm_buf = 0;
  pocz_buf = 0;
  konc_buf = 0;

  /* Zainstalowanie plikow systemu proc */
#if LINUX_VERSION_CODE >= KERNEL_VERSION(2,2,0)
  ret = proc_register(&proc_root, &null_size_entry);
  if(ret >= 0)
   ret = proc_register(&proc_root, &null_data_size_entry);
#else
  ret = proc_register_dynamic(&proc_root, &null_size_entry);
  if(ret >= 0)
    ret = proc_register_dynamic(&proc_root, &null_data_size_entry);
#endif
  return ret;
}

void cleanup_module()
{
  int ret;

  if(moj_bufor != 0)
    kfree(moj_bufor);
  
  proc_unregister(&proc_root, null_size_entry.low_ino);
  proc_unregister(&proc_root, null_data_size_entry.low_ino);

  ret = module_unregister_chrdev(Major, DEVICE_NAME);

  if (ret < 0)
    printk("Error in unregister_chrdev: %d\n", ret);
}
