#include <stdio.h>
#include <string.h>
#include <pwd.h>
#include <sys/types.h>

#define PAM_SM_AUTH
#define PAM_SM_ACCOUNT
#include <security/pam_modules.h>

#define NIE_MA 0
#define ZABRONIONY 1
#define DOZWOLONY 2

static const char *PLIK_UDENIED = "/etc/udenied";

/* lokalne funkcje */
int sprawdz_w_pliku(const char *user, const char *serwis)
{
  FILE *plik;
  int wynik, ten_serwis;
  char napis[256];
  char c;

  if((plik = fopen(PLIK_UDENIED, "r")) == NULL)
    return(NIE_MA);
  wynik = NIE_MA;
  while(1){
    if(fscanf(plik, "%[^:]:", napis) != 1)
      break;  /* Koniec pliku lub zly wpis - koncze sprawdzanie */
    if(strcmp(napis, user) != 0)
      fscanf(plik, "%*[^\n]\n"); /* przejscie do nast. wiersza */
    else{
      ten_serwis = 0;
      do{
        if(fscanf(plik, "%[^,:]%c", napis, &c) !=2 )
	  break;
        if(strcmp(serwis, napis) == 0)
          ten_serwis = 1;
      } while(c != ':');
      if(fscanf(plik, "%[^\n]\n", napis) != 1)
        break;
      if(ten_serwis)
        if(strcmp(napis, "deny") == 0)
	  wynik = ZABRONIONY;
        else if(strcmp(napis, "allow") == 0)
          wynik = DOZWOLONY;
    }
  }
  fclose(plik);
  return(wynik);
}

/* sekcja AUTH */

PAM_EXTERN int pam_sm_setcred(pam_handle_t *pamh, int flags, int
     argc, const char **argv)
{
// Nic tu nie robie
    return PAM_SUCCESS;
}

PAM_EXTERN int pam_sm_authenticate(pam_handle_t *pamh, int flags,
     int argc, const char **argv)
{
  int ret;
  const char *user = NULL;
  const char *serwis = NULL;
    
/* Parametry sa niewazne */
/* Wez nazwe uzytk. i nazwe serwisu */
  if(( ret = pam_get_user(pamh, &user, "Nazwa uzytkownika: ")) != PAM_SUCCESS){
    fprintf(stderr,"Nie mam nazwy uzytkownika (sekcja AUTH)\n");
    return ret;
  }
  if((ret = pam_get_item(pamh, PAM_SERVICE, (const void **)&serwis)) != PAM_SUCCESS){
    fprintf(stderr,"Nie mam nazwy serwisu (sekja AUTH)\n");
    return ret;
  }
/* Funkcja konczy sie sukcesem, jesli nie ma wpisu w pliku lub jest dozwolony */
  ret = (sprawdz_w_pliku(user, serwis) == ZABRONIONY) ?
         PAM_AUTH_ERR : PAM_SUCCESS;
  return ret;
}

/* sekcja ACCOUNT */

PAM_EXTERN int pam_sm_acct_mgmt(pam_handle_t *pamh, int flags, int
     argc, const char **argv)
{
  int ret;
  const char *user = NULL, *serwis = NULL;
  char *napis;
  FILE *plik;

  if(argc != 1){ /* Musi byc jeden parametr - nazwa pliku */
    fprintf(stderr,"Parametry\n");
    return PAM_AUTH_ERR;
  }
  
  /* Wez nazwe uzytkownika i serwisu */
  if((ret = pam_get_user(pamh, &user, "Nazwa uzytkownika: ")) != PAM_SUCCESS){
    fprintf(stderr,"Nie mam nazwy uzytkownika (sekcja ACCOUNT)\n");
    return ret;
  }
  if((ret = pam_get_item(pamh, PAM_SERVICE, (const void **)&serwis)) != PAM_SUCCESS){
    fprintf(stderr,"Nie mam nazwy serwisu (sekja ACCOUNT)\n");
    return ret;
  }
  ret = sprawdz_w_pliku(user, serwis);
  if(ret != NIE_MA){ /* Wpis tylko dla wpisanych uzytkownikow */
    if((plik = fopen(argv[0], "a")) == NULL){
      fprintf(stderr,"Nie moge otworzyc pliku\n");
      return PAM_AUTH_ERR;
    }
    if(ret == DOZWOLONY)
      napis="allow";
    else
      napis="deny";
    fprintf(plik,"%s:%s:%s\n", user, serwis, napis);
    fclose(plik);
  }  
  return PAM_SUCCESS;
}

/* shouldn't be needed */
#ifdef PAM_STATIC             /* for the case that this module is static */
  struct pam_module _pam_sol_modstruct = {       /* static module data */
       "pam_udenied",
       pam_sm_authenticate,
       pam_sm_setcred,
       pam_sm_acct_mgmt,
       NULL,
       NULL,
       NULL,
  };
#endif                                                 /* end PAM_STATIC */
