/* Patryk Czarnik */
/* Sieci komputerowe - zadanie 2 */

/* Nagwki funkcji obsugujcych serwis nazw */

#ifndef SERWIS_NAZW_H
#define SERWIS_NAZW_H

#include "mimo.hh"

namespace SerwNazw {

// Zwraca rootContext serwisu nazw dla podanego orba
extern CosNaming::NamingContext_var wez_kontekst_roota(CORBA::ORB_ptr orb);

// Tworzy nowy kontekst o podanej nazwie i typie jako podkontekst parametru "kontekst"
extern CosNaming::NamingContext_var stworz_kontekst(
     CosNaming::NamingContext_var &kontekst, const char *nazwa, const char *typ);

// Rejestruje obiekt objref w serwisie nazw pod podan nazw i typem
// w kontekscie "kontekst"
extern void zarejestruj_obiekt(CORBA::Object_ptr objref,
       CosNaming::NamingContext_var &kontekst, const char *nazwa, const char *typ);

// W kontekcie "kontekst" szuka podkontekstu o podanej nazwie i typie
// i zwraca go, jeli jest, jeli nie ma wyrzuca wyjtek Blad
extern CosNaming::NamingContext_var wez_kontekst(
     CosNaming::NamingContext_var &kontekst, const char *nazwa, const char *typ);

// Zwraca referencj do obiektu (czymkolwiek on jest) zarejestrowanego
// w serwisie nazw w kontekscie "kontekst" pod podan nazw i typem
extern CORBA::Object_ptr wez_obiekt(CosNaming::NamingContext_var &kontekst,
     const char *nazwa, const char *typ);
}

#endif
