/* Patryk Czarnik */
/* Sieci komputerowe - zadanie 2 */

/* Implementacja funkcji obsugujcych serwis nazw */

#include "serwis_nazw.h"
#include "wyjatki.h"

CosNaming::NamingContext_var SerwNazw::wez_kontekst_roota(CORBA::ORB_ptr orb)
{
  CosNaming::NamingContext_var wynik;

  try {
    CORBA::Object_var obj;

    // Pobranie referencji do serwisu nazw
    obj = orb->resolve_initial_references("NameService");

    // To jest wanie wynik
    wynik = CosNaming::NamingContext::_narrow(obj);
    if( CORBA::is_nil(wynik) )
      throw Blad("Failed to narrow the root naming context.");
  }
  catch(CORBA::ORB::InvalidName& ex){
    throw Blad("Service required is invalid [does not exist].");
  }
  return wynik;
}

CosNaming::NamingContext_var SerwNazw::stworz_kontekst(
     CosNaming::NamingContext_var &kontekst, const char *nazwa, const char *typ)
{
  try {
    // Tworz odpowiedni obiekt Name
    CosNaming::Name contextName;
    contextName.length(1);
    contextName[0].id   = nazwa;
    contextName[0].kind = typ;

    CosNaming::NamingContext_var nowy;
    try {
      // Tworz nowy kontekst
      nowy = kontekst->bind_new_context(contextName);
    }
    catch(CosNaming::NamingContext::AlreadyBound& ex) {
      // Albo sprawdzam czy ju istniejcy jest poprawny
      CORBA::Object_var obj;
      obj = kontekst->resolve(contextName);
      nowy = CosNaming::NamingContext::_narrow(obj);
      if( CORBA::is_nil(nowy) )
        throw Blad("Failed to narrow naming context.");
    }
    return nowy;
  }
  catch(CORBA::COMM_FAILURE& ex) {
    throw Blad("Caught system exception COMM_FAILURE -- unable to contact the naming service.");
  }
  catch(CORBA::SystemException&) {
    throw Blad("Caught a CORBA::SystemException while using the naming service.");
  }
}

void SerwNazw::zarejestruj_obiekt(CORBA::Object_ptr objref,
       CosNaming::NamingContext_var &kontekst, const char *nazwa, const char *typ)
{
  try {
    // Tworz odpowiedni obiekt Name
    CosNaming::Name objectName;
    objectName.length(1);
    objectName[0].id   = nazwa;
    objectName[0].kind = typ;

    try {
      // Przypinam obiekt objref
      kontekst->bind(objectName, objref);
    }
    catch(CosNaming::NamingContext::AlreadyBound& ex) {
      // A jeli ju by jaki pod t nazw, to zamieniam na objref
      kontekst->rebind(objectName, objref);
    }
  }
  catch(CORBA::COMM_FAILURE& ex) {
    throw Blad("Caught system exception COMM_FAILURE -- unable to contact the naming service.");
  }
  catch(CORBA::SystemException&) {
    throw Blad("Caught a CORBA::SystemException while using the naming service.");
  }
}

CosNaming::NamingContext_var SerwNazw::wez_kontekst(
     CosNaming::NamingContext_var &kontekst, const char *nazwa, const char *typ)
{
  //Tworz odpowiedni obiekt Name
  CosNaming::Name name;
  name.length(1);
  name[0].id   = nazwa;
  name[0].kind = typ;

  try {
    // Pobieram referencj do czego, co jest pod t nazw
    CORBA::Object_ptr objref = kontekst->resolve(name);
    // Rzutuje na typ kontektu
    CosNaming::NamingContext_var wynik = CosNaming::NamingContext::_narrow(objref);
    if( CORBA::is_nil(wynik) )
      // Moe to nie by jednak kontekst
      throw Blad("Odczytany kontekst jest nilem.");
    return wynik;
  }
  catch(CosNaming::NamingContext::NotFound& ex) {
    throw Blad("Context not found.");
  }
  catch(CORBA::COMM_FAILURE& ex) {
    throw Blad("Caught system exception COMM_FAILURE -- unable to contact the naming service.");
  }
  catch(CORBA::SystemException&) {
    throw Blad("Caught a CORBA::SystemException while using the naming service.");
  }

  throw Blad("Brak obiektu w serwisie nazw?");
}

CORBA::Object_ptr SerwNazw::wez_obiekt(CosNaming::NamingContext_var &kontekst,
     const char *nazwa, const char *typ)
{
  //Tworz odpowiedni obiekt Name
  CosNaming::Name name;
  name.length(1);
  name[0].id   = nazwa;
  name[0].kind = typ;

  try {
    // Pobieram referencj do czego, co jest pod t nazw - to wynik funkcji (cokolwiek to jest)
    return kontekst->resolve(name);
  }
  catch(CosNaming::NamingContext::NotFound& ex) {
    throw Blad("Context not found.");
  }
  catch(CORBA::COMM_FAILURE& ex) {
    throw Blad("Caught system exception COMM_FAILURE -- unable to contact the naming service.");
  }
  catch(CORBA::SystemException&) {
    throw Blad("Caught a CORBA::SystemException while using the naming service.");
  }

  throw Blad("Brak obiektu w serwisie nazw?");
}
