/* Patryk Czarnik */
/* Sieci komputerowe - zadanie 2 */

/* Implementacja obiektow Corby i program serwera */

#include <vector>
#include <map>
#include <string>
#include <iostream>
#include <fstream>
#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include "mimo.hh"
#include "wyjatki.h"
#include "serwis_nazw.h"

const char* PlikPlanszy = "plansza";
const char* PlikSzans = "szanse";
const char KONIEC_OPISU = '#';
const CORBA::Long STARTOWE_KONTO = 500;
const int MAX_HOTELI = 5;

// Zmienne globalne
class Pole_i;

int rozmiar_planszy = 0;
vector<char*> *plansza = NULL;
vector<Pole_i*> *pola = NULL;

class Bank_i *bank = NULL;

// ** Obiekty CORBY **

class Bank_i : public POA_Bank,
	       public PortableServer::RefCountServantBase
{
 private:
  // konta graczy przechowuj w sowniku
  typedef map<string, CORBA::Long> Tslownik;
  Tslownik konta;
 public:
  Bank_i(void) {}
  ~Bank_i(void) {}
  virtual void zalozKonto(const char *nazwa);
  virtual void zmienStanKonta(const char *nazwa, CORBA::Long zmiana);
  virtual CORBA::Long dajSaldo(const char *nazwa);
  virtual void skasujKonto(const char *nazwa);
};

void Bank_i::zalozKonto(const char *nazwa)
{
  // dodaje nowe konto lub zmienia stan istniejcego
  konta[nazwa] = STARTOWE_KONTO;
}

void Bank_i::zmienStanKonta(const char *nazwa, CORBA::Long zmiana)
{
cout << "Zmiana stanu konta " << nazwa << " o " << zmiana << '\n';
 
  Tslownik::iterator it = konta.find(string(nazwa));
  if(it == konta.end()){
    throw Bank::BrakKonta();
}  else {
    CORBA::Long stan = it->second;
    if(stan + zmiana < 0)
      throw Bank::BrakPieniedzy();
    else {
      konta[string(nazwa)] = stan + zmiana;
    }
  }
}

CORBA::Long Bank_i::dajSaldo(const char *nazwa)
{
cout << "Pytanie o saldo konta " << nazwa << '\n';
  Tslownik::iterator it = konta.find(string(nazwa));
  if(it == konta.end())
    throw Bank::BrakKonta();
  else
    return it->second;
}

void Bank_i::skasujKonto(const char *nazwa)
{
  cout << "Kasowanie konta " << nazwa << '\n';
  konta.erase(string(nazwa));
}

// Pola

// Funkcje pomocnicze

int rzut_kostka(void)
// Suma ILE_KOSTEK losowych liczb z przedziau OD DO
{
  const int OD = 1;
  const int DO = 6;
  const int ILE_KOSTEK = 2;  // dla chtnych ?

  int wynik = 0;
  for(int i=0; i<ILE_KOSTEK; i++)
   wynik += OD + (int)(rand()*(DO - OD +1)/(RAND_MAX+1.0));

  return wynik;
}

// Inicjuje *wynik podanymi wartociami
void akcja_dla_gracza(AkcjaDlaGracza *wynik, Akcje akcja, const char *opis)
{
  wynik->akcja = akcja;
  wynik->opis = CORBA::string_dup(opis);
}

class Pole_i : public POA_Pole,
	       public PortableServer::RefCountServantBase
{
 private:
  int numer;     // numer na planszy - potrzebny przy rzutach kostk
  string nazwa;  // tej nazwy uywa serwis nazw
  string opis;   // opis pola dla gracza
  string gracz;  // jesli pole zajete, to tu jest nazwa gracza, ktry na nim stoi
  bool zajete;   // czy kto stoi na polu
  
 protected:
  void zejdz(void)
   { zajete = false; }
  virtual char* nastepne(void);  // daje nazw wylosowanego nastpnego pola
  // akcje
  virtual char* akcjaPrzegraj(void);
  virtual char* akcjaDalej(void);

 public:
  Pole_i(int n) : zajete(false), numer(n) { }
  Pole_i(int n, istream &wej);
  ~Pole_i(void) {}

  int dajNumer(void) const
   { return numer; }
  const string& dajNazwe(void) const
   { return nazwa; }
  const string& dajOpis(void) const
   { return opis; }
  const string& dajGracza(void) const
   { return gracz; }
  bool czyZajete(void) const
   { return zajete; }
   
  // te metody daj kopie napisw
  char* dajKopieNazwy(void)
   { return CORBA::string_dup(nazwa.c_str()); }
  virtual char* dajOpisDlaGracza(void) const
   { return CORBA::string_dup(opis.c_str()); }

  char* wejdz(const char *nazwa_gracza);
  virtual SekwAkcji* dajAkcje(void)=0;
  virtual char* wykonajAkcje(Akcje akcja)
=0;
}
;

Pole_i::Pole_i(int n, istream &wej) : zajete(false), numer(n)
{
  wej >> nazwa;
  getline(wej, opis, KONIEC_OPISU);
}

char* Pole_i::wejdz(const char *nazwa_gracza)
{
  cout << "Wejcie na pole " << nazwa << " przez " << nazwa_gracza << '\n';
  if(zajete)
    throw Pole::Zajete();
  else {
    gracz = string(nazwa_gracza);
    zajete = true;
    return dajOpisDlaGracza();
  }
}

char* Pole_i::nastepne(void)
{
  int pozycja = (dajNumer() + rzut_kostka()) % rozmiar_planszy;
  return CORBA::string_dup((*plansza)[pozycja]);
}

char* Pole_i::akcjaPrzegraj(void)
{
  bank->skasujKonto(dajGracza().c_str());
  zejdz();
   // ta akcja zwraca pust nazw - klient zakoczy dziaanie
  return CORBA::string_dup("");  
}

char* Pole_i::akcjaDalej(void)
{
  zejdz();
  return nastepne();
}

// Rne typy pl

class PoleRelaks : public Pole_i
{
 public:
  PoleRelaks(int n, istream &wej): Pole_i(n, wej) { }
  virtual SekwAkcji* dajAkcje(void);
  virtual char* wykonajAkcje(Akcje akcja)
;
};

SekwAkcji* PoleRelaks::dajAkcje(void)
{
  SekwAkcji *wynik;
  AkcjaDlaGracza *buf = SekwAkcji::allocbuf(2);

  akcja_dla_gracza(buf, A_Przegraj, "Przegraj i zakocz gr");
  akcja_dla_gracza(buf+1, A_Dalej, "Przejd dalej");

  wynik = new SekwAkcji(2, 2, buf, 1);
  return wynik;
}

char* PoleRelaks::wykonajAkcje(Akcje akcja)
{
  switch(akcja){
    case A_Przegraj : return akcjaPrzegraj();
    case A_Dalej    : return akcjaDalej();
    default: throw Pole::NieMamTejAkcji();
  }
}


class PoleStart : public Pole_i
{
  private:
   CORBA::Long wyplata;
  protected:
   virtual char* akcjaWyplata(void);
 public:
  PoleStart(int n, istream &wej);
  virtual SekwAkcji* dajAkcje(void);
  virtual char* wykonajAkcje(Akcje akcja)
;
};

PoleStart::PoleStart(int n, istream &wej)
  : Pole_i(n, wej)
{
  wej >> wyplata;
}

SekwAkcji* PoleStart::dajAkcje(void)
{
  char napis[60];
  
  SekwAkcji *wynik;
  AkcjaDlaGracza *buf = SekwAkcji::allocbuf(2);

  akcja_dla_gracza(buf, A_Przegraj, "Przegraj i zakocz gr");
  sprintf(napis, "Przejd dalej pobierajc wypat %d $", wyplata);
  akcja_dla_gracza(buf+1, A_Wyplata, napis);

  wynik = new SekwAkcji(2, 2, buf, 1);
  return wynik;
}

char* PoleStart::akcjaWyplata(void)
{
  bank->zmienStanKonta(dajGracza().c_str(), wyplata);
  zejdz();
  return nastepne();
}

char* PoleStart::wykonajAkcje(Akcje akcja)
{
  switch(akcja){
    case A_Przegraj : return akcjaPrzegraj();
    case A_Wyplata  : return akcjaWyplata();
    default: throw Pole::NieMamTejAkcji();
  }
}

class PoleGrunt : public Pole_i
{
  private:
   CORBA::Long cena;
   CORBA::Long cena_hotelu;
   CORBA::Long oplata[MAX_HOTELI+1];
   bool kupiony;
   string wlasciciel;
   int hotele;
  protected:
   virtual char* akcjaKup(void);
   virtual char* akcjaKupHotel(void);
   virtual char* akcjaOplata(void);
 public:
  PoleGrunt(int n, istream &wej);
  virtual char* dajOpisDlaGracza(void) const;
  virtual SekwAkcji* dajAkcje(void);
  virtual char* wykonajAkcje(Akcje akcja)
;
};

PoleGrunt::PoleGrunt(int n, istream &wej)
  : Pole_i(n, wej), kupiony(false), hotele(0)
{
  wej >> cena;
  wej >> cena_hotelu;
  for(int i=0; i<=MAX_HOTELI; i++)
    wej >> oplata[i];
}

char* PoleGrunt::dajOpisDlaGracza(void) const
{
  string wynik;
  wynik = dajOpis();
  if(kupiony){
    wynik += "\nPole wykupione, wacicielem jest ";
    wynik += wlasciciel;
  } else {
    wynik += "\nPole jest niezakupione";
  }
  return CORBA::string_dup(wynik.c_str());
}

SekwAkcji* PoleGrunt::dajAkcje(void)
{
  char napis[60];
  
  int rozmiar;

  SekwAkcji *wynik;
  AkcjaDlaGracza *buf = SekwAkcji::allocbuf(3);

  akcja_dla_gracza(buf, A_Przegraj, "Przegraj i zakocz gr");
  if(kupiony){
    if(dajGracza() == wlasciciel){
      if(hotele < MAX_HOTELI){
        sprintf(napis, "Kup hotel pacc %d $", cena_hotelu);
        akcja_dla_gracza(buf+1, A_KupHotel, napis);
        akcja_dla_gracza(buf+2, A_Dalej, "Przejd dalej");
	rozmiar = 3;
      } else {
        akcja_dla_gracza(buf+1, A_Dalej, "Przejd dalej");
	rozmiar = 2;
      }
    } else {
      sprintf(napis, "Opata za postj %d $ dla %s", oplata[hotele], wlasciciel.c_str());
      akcja_dla_gracza(buf+1, A_Oplata, napis);
      rozmiar = 2;
    }
  } else {
    sprintf(napis, "Kup grunt pacc %d $", cena);
    akcja_dla_gracza(buf+1, A_Kup, napis);
    akcja_dla_gracza(buf+2, A_Dalej, "Przejd dalej");
    rozmiar = 3;
  }
  wynik = new SekwAkcji(rozmiar, rozmiar, buf, 1);
  return wynik;
}

char* PoleGrunt::akcjaKup(void)
{
 cout << dajGracza() << " kupuje pole " << dajNazwe() << '\n';
  if(bank->dajSaldo(dajGracza().c_str()) < cena)
    throw Pole::BrakPieniedzy();
  else {
    bank->zmienStanKonta(dajGracza().c_str(), -cena);
    kupiony = true;
    wlasciciel = dajGracza();
    zejdz();
    return nastepne();
  }
}

char* PoleGrunt::akcjaKupHotel(void)
{
  if(bank->dajSaldo(dajGracza().c_str()) < cena_hotelu)
    throw Pole::BrakPieniedzy();
  else {
    bank->zmienStanKonta(dajGracza().c_str(), -cena_hotelu);
    hotele++;
    zejdz();
    return nastepne();
  }
}

char* PoleGrunt::akcjaOplata(void)
{
  CORBA::Long konto;
  
  try {
    if((konto = bank->dajSaldo(dajGracza().c_str())) < oplata[hotele]) {
      bank->zmienStanKonta(wlasciciel.c_str(), konto);
      bank->zmienStanKonta(dajGracza().c_str(), -konto);  //do zera
      zejdz();
      throw Pole::Bankrut();
    }
    else {
      bank->zmienStanKonta(wlasciciel.c_str(), oplata[hotele]);
      bank->zmienStanKonta(dajGracza().c_str(), -oplata[hotele]);
      zejdz();
    }
    return nastepne();

  } catch(Bank::BrakKonta) {
    cout << "Usuwam wlasciciela "<<wlasciciel<<" z pola " << dajNazwe() << '\n';
    kupiony = false;
    hotele = 0;
    throw Pole::NieMamTejAkcji();
    // waciciel musia przesta gra - pole stanie si znowu niezakupione,
    // a ten kto na nie wszed, jeszcze raz pobierze zestaw akcji
  }
}

char* PoleGrunt::wykonajAkcje(Akcje akcja)
{
  switch(akcja){
    case A_Przegraj : return akcjaPrzegraj();
    case A_Dalej    : return akcjaDalej();
    case A_Kup      : return akcjaKup();
    case A_KupHotel : return akcjaKupHotel();
    case A_Oplata   : return akcjaOplata();
    default: throw Pole::NieMamTejAkcji();
  }
}

// Na potrzeby pola ryzyko definiuj klas Szansa, opisujc akcj wykonywan
// na takim polu. Szansy bd trzymane w globalnej tablicy, za kadym razem
// bdzie losowana jedna z nich.
class Szansa {
 private:
  int jak_przesuwac;
  int o_ile_przesuwac;
  string opis;
  CORBA::Long zmiana_konta;
  
 public:
  Szansa(int jak, int o_ile, int zmiana, const char* op):
    jak_przesuwac(jak), o_ile_przesuwac(o_ile), zmiana_konta(zmiana), opis(op)
    { }
  Szansa(ifstream &wej)
  {
    wej >> jak_przesuwac;
    wej >> o_ile_przesuwac;
    wej >> zmiana_konta;
    getline(wej, opis, KONIEC_OPISU);
  }
  ~Szansa() { }
  const string& dajOpis(void) const
   { return opis; }
  char* wykonaj(int numer_pola, const string& gracz);
};

char* Szansa::wykonaj(int numer_pola, const string& gracz)
{
  CORBA::Long konto;
  
  // Zmiana konta gracza, jeli ma za mao pienidzy, zostaje bankrutem
  if((konto = bank->dajSaldo(gracz.c_str())) + zmiana_konta < 0) {
    bank->zmienStanKonta(gracz.c_str(), -konto);  //do zera
    throw Pole::Bankrut();
  }
  else {
    bank->zmienStanKonta(gracz.c_str(), zmiana_konta);
  }

  // Wybr nastepnego pola
  int nast_pole;
  switch(jak_przesuwac) {
    case 0 : // losowo
     nast_pole = (numer_pola + rzut_kostka()) % rozmiar_planszy;
    case 1 : // konkretne pole
     if(o_ile_przesuwac < 0 || o_ile_przesuwac >= rozmiar_planszy)
       throw Blad("Pola z szansy nie ma na planszy\n");
     else
      nast_pole = o_ile_przesuwac;
     break;
    case 2 : // przesun o podana liczbe
     nast_pole = (numer_pola + o_ile_przesuwac) % rozmiar_planszy;
     break;
  }
  return CORBA::string_dup((*plansza)[nast_pole]);
}

// Globalna tablica szans
int ile_szans=0;
vector<Szansa*> *szanse=NULL;

class PoleRyzyko : public Pole_i
{
  private:
   int wylosowana_szansa;
  protected:
   virtual char* akcjaRyzyko(void);
 public:
  PoleRyzyko(int n, istream &wej) : Pole_i(n, wej)  { }
  virtual SekwAkcji* dajAkcje(void);
  virtual char* wykonajAkcje(Akcje akcja)
;
};

SekwAkcji* PoleRyzyko::dajAkcje(void)
{
  SekwAkcji *wynik;
  AkcjaDlaGracza *buf = SekwAkcji::allocbuf(2);

  wylosowana_szansa = (int) ((rand()*ile_szans) / (RAND_MAX+1.0));
  akcja_dla_gracza(buf, A_Przegraj, "Przegraj i zakocz gr");
  akcja_dla_gracza(buf+1, A_Ryzyko, (*szanse)[wylosowana_szansa]->dajOpis().c_str());

  wynik = new SekwAkcji(2, 2, buf, 1);
  return wynik;
}

char* PoleRyzyko::akcjaRyzyko(void)
{
  zejdz();  // tutaj schodzi nawet jeli wyrzuca wyjtek (bo wtedy bankrut)
  char * wynik = (*szanse)[wylosowana_szansa]->wykonaj(dajNumer(), dajGracza());
  return wynik;
}

char* PoleRyzyko::wykonajAkcje(Akcje akcja)
{
  switch(akcja){
    case A_Przegraj : return akcjaPrzegraj();
    case A_Ryzyko   : return akcjaRyzyko();
    default: throw Pole::NieMamTejAkcji();
  }
}

// ** Procedury programu **

// Odczytuje plik planszy, tworzc obiekty pl, rejestrujc je w serwisie nazw
// i zapamitujc ich nazwy w sowniku pl.
void wczytaj_plansze(PortableServer::POA_var& poa,
                     CosNaming::NamingContext_var& kontekst)
{
  Pole_i *nowe_pole;
  int rodzaj;
  
  ifstream plik(PlikPlanszy);
  if(!plik)
    throw Blad("Nie mona otworzy pliku planszy.");
  plik >> rozmiar_planszy;
  if(rozmiar_planszy <= 0)
    throw Blad("Nieprawidowy rozmiar planszy.");
  plansza = new vector<char*>(rozmiar_planszy);
  pola = new vector<Pole_i*>(rozmiar_planszy);
  for(int i=0; i<rozmiar_planszy; i++){
    plik >> rodzaj;
    switch(rodzaj) {
      case 1 : nowe_pole = new PoleRelaks(i, plik); break;
      case 2 : nowe_pole = new PoleStart(i, plik); break;
      case 3 : nowe_pole = new PoleGrunt(i, plik); break;
      case 4 : nowe_pole = new PoleRyzyko(i, plik); break;
      default: throw Blad("Nie ma takiego rodzaju pola.");
    }
    (*pola)[i] = nowe_pole;
    (*plansza)[i] = nowe_pole->dajKopieNazwy();
    poa->activate_object(nowe_pole);
    SerwNazw::zarejestruj_obiekt(nowe_pole->_this(), kontekst, (*plansza)[i], "pole");
    nowe_pole->_remove_ref();
  }
}

void wczytaj_szanse(void)
{
  ifstream plik(PlikSzans);
  if(!plik)
    throw Blad("Nie mona otworzy pliku z szansami.");
  plik >> ile_szans;
  if(ile_szans <= 0)
    throw Blad("Nieprawidowa liczba szans.");
  szanse = new vector<Szansa*>(ile_szans);
  for(int i=0; i<ile_szans; i++)
    (*szanse)[i] = new Szansa(plik);
}

void porzadki(void)
{
  if(bank != NULL) {
    delete bank;
  }
  if(pola != NULL) {
    for(int i=0; i<rozmiar_planszy; i++)
      delete [] (*pola)[i];
    delete pola;
  }
  if(plansza != NULL) {
    for(int i=0; i<rozmiar_planszy; i++)
      delete [] (*plansza)[i];
    delete plansza;
  }
  if(szanse != NULL){
    for(int i=0; i<ile_szans; i++)
      delete (*szanse)[i];
    delete szanse;
  }
}
// ** Program serwera **

int main(int argc, char **argv)
{
  try { try {
    srand(time(NULL));
    wczytaj_szanse();
   // Start Corby
    CORBA::ORB_var orb = CORBA::ORB_init(argc, argv, "omniORB3");
    CORBA::Object_var obj = orb->resolve_initial_references("RootPOA");
    PortableServer::POA_var poa = PortableServer::POA::_narrow(obj);
   // Pobranie korzenia serwisu nazw i stworzenie kontekstu Mimopol
    CosNaming::NamingContext_var kontekst = SerwNazw::wez_kontekst_roota(orb);
    kontekst = SerwNazw::stworz_kontekst(kontekst, "Mimopol", "kontekst");
   // Stworzenie obiektu bank, aktywacja i dodanie do serwisu nazw
    bank = new Bank_i();
    poa->activate_object(bank);
    SerwNazw::zarejestruj_obiekt(bank->_this(), kontekst, "Bank", "bank");
    bank->_remove_ref();
   // Stworzenie kontekstu Pola
    kontekst = SerwNazw::stworz_kontekst(kontekst, "Pola", "kontekst");
   // Wczytanie planszy z pliku z tworzeniem obiektow Corby i dodawaniem
   // ich do serwisu nazw
    wczytaj_plansze(poa, kontekst);  //zmienia globalne rozmiar_planszy i plansza
   // Uruchomienie serwera obiektw
    PortableServer::POAManager_var pman = poa->the_POAManager();
    pman->activate();
    cout << "Dzialam!\n";
    orb->run();
    orb->destroy();
    porzadki();
  }
  // Wyjtki Corby
  catch(CORBA::SystemException&) {
    throw Blad("Caught CORBA::SystemException.");
  }
  catch(CORBA::Exception&) {
    throw Blad("Caught CORBA::Exception.");
  }
  catch(omniORB::fatalException& fe) {
    cerr << "Caught omniORB::fatalException:";
    cerr << "  file: " << fe.file() << endl;
    cerr << "  line: " << fe.line() << endl;
    cerr << "  mesg: " << fe.errmsg() << endl;
    throw Blad("fatal");
  }
  }
  // Wyjtki z moich funkcji
  catch(Blad& bl){
    bl.wypisz();
  }
  // Moe co jeszcze?
  catch(...) {
    cerr << "Caught unknown exception." << endl;
  }
  
  return 0;
}
