/* Patryk Czarnik */
/* Sieci komputerowe - zadanie 2 */

/* Program klienta */

#include <string>
#include <map>
#include "mimo.hh"
#include "interfejs.h"
#include "wyjatki.h"
#include "serwis_nazw.h"

const int ILE_AKCJI = 10;  // moe by za duo

// Zmienne globalne
string nazwa_gracza;
bool gramy_dalej;

bool czy_na_polu = false;
Pole_ptr biezace_pole;
string nazwa_pola = "Start";
string opis_pola = "";

Bank_var bank;

typedef map<string, Pole_var> TSlownikPol;
TSlownikPol slownik_pol;
CosNaming::NamingContext_var kontekst_pol;

// Funkcja dajca referencj do obiektu pola o danej nazwie.
// Jeli pierwszy raz jest wywoywana dla takiej nazwy,
// bierze referencj z serwisu nazw, wstawia j do globalnego sownika
// slownik_pol, a przy nastpnych wywoaniach korzysta z tego sownika.
Pole_ptr daj_ref_pola(const string &nazwa)
// Zwraca wskanik do obiektu, ktry jest (po wywoaniu) w sowniku.
{
  TSlownikPol::iterator it = slownik_pol.find(nazwa);
  if(it == slownik_pol.end()){
    // Jeli jeszcze nie ma w sowniku
    Pole_ptr nowe = Pole::_narrow(
                   (SerwNazw::wez_obiekt(kontekst_pol, nazwa.c_str(), "pole")));
    slownik_pol[nazwa] = nowe; // wstawiam do sownika, obiekt zostanie skopiowany na 'var'
    return slownik_pol[nazwa];
  }
  else {
    return it->second;
  }
}

// Klasa akcji gracza - podklasy to rne akcje do wykonania

class AkcjaGracza {
 private:
  string opis_w_menu;
 public:
  AkcjaGracza(const string &opis): opis_w_menu(opis) {}
  AkcjaGracza(const char* opis): opis_w_menu(opis) {}
  ~AkcjaGracza() {}
  const string& dajOpis(void) const {return opis_w_menu;}
  virtual void wykonaj(void) = 0;
};

class AkcjaPrzerwij: public AkcjaGracza {
 public:
  AkcjaPrzerwij(): AkcjaGracza("Przegraj") {}
  virtual void wykonaj(void);
};

void AkcjaPrzerwij::wykonaj(void)
{
  bank->skasujKonto(nazwa_gracza.c_str());
  gramy_dalej = false;
}

class AkcjaWejdz: public AkcjaGracza {
 public:
  AkcjaWejdz(): AkcjaGracza("Wejd na nastpne pole") {}
  virtual void wykonaj(void);
};

void AkcjaWejdz::wykonaj(void)
{
  biezace_pole = daj_ref_pola(nazwa_pola);
  opis_pola = biezace_pole->wejdz(nazwa_gracza.c_str());
  czy_na_polu = true; // jeli wyjtek nie wchodz na pole
}

class AkcjaPola: public AkcjaGracza {
 private:
  Akcje id_akcji;
 public:
  AkcjaPola(AkcjaDlaGracza& akcja): AkcjaGracza(akcja.opis),
    id_akcji(akcja.akcja) { }
  virtual void wykonaj(void);
};

void AkcjaPola::wykonaj(void)
{
  nazwa_pola = biezace_pole->wykonajAkcje(id_akcji);
  // jeli wyjcie przez wyjtek, nie schodz z pola
  czy_na_polu = false;
  if(nazwa_pola == "")  // to koniec gry
    gramy_dalej = false; // konto ju jest usunite
}

// Procedury programu

AkcjaGracza* menu(void)
{
  AkcjaGracza* tablica_akcji[ILE_AKCJI];
  int ile_akcji;

  if(!czy_na_polu) {
    ile_akcji = 2;
    tablica_akcji[0] = new AkcjaPrzerwij();
    tablica_akcji[1] = new AkcjaWejdz();
  } else {
    SekwAkcji_var akcje_pola = biezace_pole->dajAkcje();
    ile_akcji = akcje_pola->length();
    for(int i=0; i<ile_akcji; i++)
      tablica_akcji[i] = new AkcjaPola(akcje_pola[i]);
  }

  Inter::menu_naglowek();
  for(int i=0; i<ile_akcji; i++)
    Inter::menu_wypisz_akcje(i+1, tablica_akcji[i]->dajOpis());
  int wybor = Inter::menu_wybor(ile_akcji) - 1;
  Inter::menu_zakoncz();
  for(int i=0; i<ile_akcji; i++)
    if(i != wybor)
      delete tablica_akcji[i];
  return tablica_akcji[wybor];
}

void przedstaw_sytuacje(void)
{
  Inter::sytuacja_naglowek(nazwa_gracza);
  Inter::sytuacja_konto(bank->dajSaldo(nazwa_gracza.c_str()));
  Inter::sytuacja_pole(czy_na_polu, nazwa_pola, opis_pola);
  Inter::sytuacja_koniec();
}

// Program klienta

int main(int argc, char **argv)
{
  try { try {

    Inter::powitanie();

    CORBA::ORB_var orb = CORBA::ORB_init(argc, argv, "omniORB3");
    CosNaming::NamingContext_var kontekst = SerwNazw::wez_kontekst_roota(orb);
  
    kontekst = SerwNazw::wez_kontekst(kontekst, "Mimopol", "kontekst");
     // Pobranie referencji do obiektu Bank
    bank = Bank::_narrow(SerwNazw::wez_obiekt(kontekst, "Bank", "bank"));
     // Pobranie kontekstu Pola
    kontekst_pol = SerwNazw::wez_kontekst(kontekst, "Pola", "kontekst");

    nazwa_gracza = Inter::wez_nazwe_gracza();

    bank->zalozKonto(nazwa_gracza.c_str());
    AkcjaGracza *co_robic = NULL;
    gramy_dalej = true;
    while(gramy_dalej)
      try {
	if(co_robic != NULL)
          delete co_robic;
        przedstaw_sytuacje();
        co_robic = menu();
        co_robic->wykonaj();
      }
      catch(Pole::Bankrut){
        Inter::bankrut();
        bank->skasujKonto(nazwa_gracza.c_str());
	gramy_dalej = false;
      }
      catch(Pole::BrakPieniedzy){
        Inter::brak_pieniedzy();
	continue;
      }
      catch(Pole::Zajete){
        Inter::zajete();
	continue;
      }
      catch(Pole::NieMamTejAkcji){
        Inter::nie_ma_akcji();
	continue;
      }
  
    orb->destroy();
    Inter::pozegnanie();
  }
  // Wyjtki Corby
  catch(CORBA::COMM_FAILURE& ex) {
    throw Blad("Caught system exception COMM_FAILURE -- unable to contact the object.");
  }
  catch(CORBA::SystemException&) {
    throw Blad("Caught CORBA::SystemException.");
  }
  catch(CORBA::Exception&) {
    throw Blad("Caught CORBA::Exception.");
  }
  catch(omniORB::fatalException& fe) {
    cerr << "Caught omniORB::fatalException:";
    cerr << "  file: " << fe.file() << endl;
    cerr << "  line: " << fe.line() << endl;
    cerr << "  mesg: " << fe.errmsg() << endl;
    throw Blad("fatal");
  } }
  // Wyjtki z moich funkcji i te wyrzucone powyzej
  catch(Blad& bl){
    bl.wypisz();
  }
  // Moe co jeszcze?
  catch(...) {
    cerr << "Caught unknown exception." << endl;
  }

  return 0;
}
