/* Patryk Czarnik, sieci komp. zadanie 1 */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <unistd.h>
#include <netdb.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include "mud_common.h"

static int warunek=1;  /* czy dalej dzialac (w petli) */
static int moj_numer=-1; /* numer, pod jakim jest zalogowany gracz lub -1 jesli niezalogowany */
static int desk_tcp, desk_udp; /* deskryptory do komunikacji przez TCP i UDP */
static struct sockaddr_in serwer_tcp, serwer_udp; /* adresy serwera do kom. TCP i UDP */
static int dl_adresu_udp = sizeof(serwer_udp); /* gdzies jest potrzebna zmienna z rozmiarem adresu UDP */

/** W napisie zamienia male litery na duze. */
void upper(char *napis)
{
  while(*napis){
    *napis = toupper(*napis);
    napis++;
  }
}

/** Ta funkcja odbiera i odpowiednio interpretuje komunikat przychodzacy
  * przez TCP. */
void wez_komunikat_tcp(void)
{
  char bufor[MAX_DL_KOMUNIKATU]; /* tu wczytam komunikat */
  int r;

  if((r=read(desk_tcp, bufor, MAX_DL_KOMUNIKATU)) <= 0){
    pisz_blad("Blad przy czytaniu z TCP\n");
    if(r == 0){ /* koniec pliku? prawdopodobnie serwer padl, koncze program */
      printf("Nie mozna czytac z serwera\n");
      warunek = 0;
    }
    return;
  }
  switch(bufor[0]){
    case KOM_BLAD:
      printf("Nie zalogowales sie. %s\n", bufor+1);
      warunek = 0;
      break;
    case KOM_ZALOG:
      /* odczytanie mojego numeru */
      memcpy(&moj_numer, bufor+1, sizeof(int));
      printf("Zalogowalem sie pod numer %d\n", moj_numer);
      break;
    case KOM_PISZ:
      printf("-> %s\n",bufor+1);
      break;
    default: pisz_blad("Niezrozumialy komunikat TCP\n");
  }
}

/** Odczytuje i odpowiednio interpretuje komunikat, ktory przyszedl przez UDP.
  * Przez UDP przychodza wylacznie opisy lokacji, wiec kazdy komunikat zostanie
  * wypisany jako opis lokacji. */
void wez_komunikat_udp(void)
{
  char bufor[MAX_DL_OPISU];

  if(recvfrom(desk_udp, bufor, MAX_DL_OPISU, 0,
            (struct sockaddr*)&serwer_udp, &dl_adresu_udp) <= 0)
    pisz_blad("Blad przy czytaniu z UDP\n");
  else
    printf("Opis lokacji:\n%s\n", bufor);
}

/** Wysyla do serwera przez TCP komunikat zaczynajacy sie od komendy
  * (jeden bajt), nastepnie moj_numer, a dalej napis pusty, jesli
  * teskt==NULL, lub teskt. */
void wyslij_do_serwera(char komenda, char *tekst)
{
  char do_wyslania[MAX_DL_KOMUNIKATU];
  int dlugosc;

  if(moj_numer == -1){
    pisz_blad("Proba pisania przed zalogowaniem\n");
    return;
  }
  do_wyslania[0] = komenda;
  /* zapisuje w komunikacie wartosc numeru */
  memcpy(do_wyslania+1, &moj_numer, sizeof(int));
  dlugosc = sizeof(int) +2; /* numer, komenda i ostatni znak napisu */
  if(tekst == NULL)
    do_wyslania[sizeof(int)+1] = '\0';
  else {
    sscanf(tekst, "%[^\n]", do_wyslania+sizeof(int)+1);
    dlugosc += strlen(do_wyslania+sizeof(int)+1);
  }
  if(write(desk_tcp, do_wyslania, dlugosc) <0)
    pisz_blad("Blad przy pisaniu do TCP\n");
}

/** Rozpoznaje polecenie podane przez uzytkownika i zapisane w napis.
  * Zwraca odpowiedni kod polecenia lub KOM_BLAD jesli nie potrafi
  * zinterpretowac. Ponadto ustawi wskaznik *do_wyslania na pierwszy znak
  * tekstu, ktory (dla niektorych polecen) nalezy wyslac do serwera. */
char polecenie(const char *napis, char **do_wyslania)
{
  char komenda[MAX_DL_KOMUNIKATU];
  
  komenda[0] = '\0';
  if(sscanf(napis, "%s", komenda) != 1)
    return KOM_BLAD;
  (*do_wyslania) = (char*)(napis + strlen(komenda) +1);
  
  upper(komenda);
  if(strcmp(komenda, "QUIT") == 0)
    return KOM_QUIT;
  if(strcmp(komenda, "LOOK") == 0)
    return KOM_LOOK;
  if(strcmp(komenda, "SAY") == 0)
    return KOM_SAY;
  if(strcmp(komenda, "CHAT") == 0)
    return KOM_CHAT;
  if(strcmp(komenda, "N") == 0)
    return KOM_N;
  if(strcmp(komenda, "S") == 0)
    return KOM_S;
  if(strcmp(komenda, "E") == 0)
    return KOM_E;
  if(strcmp(komenda, "W") == 0)
    return KOM_W;
  return KOM_BLAD;
}

/** Czyta ze standardowego wejscia jego polecenie i odpowiednio na nie reaguje. */
void wez_polecenie(void)
{
  char napis[MAX_DL_KOMUNIKATU], *parametr;
  char komenda;
  
  /* Czytam ze standardowego wejscia */
  if(read(0, napis, MAX_DL_KOMUNIKATU) <0){
    pisz_blad("Blad przy czytaniu polecenia\n");
    return;
  }
  /* Rozpoznaje polecenie */
  komenda = polecenie(napis, &parametr);
  switch(komenda){
    case KOM_QUIT :
      warunek = 0;
      wyslij_do_serwera(KOM_QUIT, NULL);
      break;
    case KOM_LOOK :
    case KOM_N :
    case KOM_S :
    case KOM_E :
    case KOM_W :
      wyslij_do_serwera(komenda, NULL);
      break;
    case KOM_SAY :
    case KOM_CHAT:
      wyslij_do_serwera(komenda, parametr);
      break;
    default:
      printf("Niepoprawne polecenie\n");
  }
}

int main(int argc, char **argv)
{
  int dlug;
  struct hostent *hp;
  struct sockaddr_in klient_udp; /* moj adres udp */
  char bufor[MAX_DL_KOMUNIKATU];
  char nazwa[DL_NAZWY], haslo[DL_NAZWY], nazwa_hosta[DL_NAZWY_HOSTA];
  fd_set zbior; /* zbior deskryptorow, ktorych nalzey sluchac, w kazdym... */
  int maks_deskr; /* ...selekcie beda to stdin, tcp i udp. Tu maksymalny numer deskr ze zbioru */

  printf("Podaj swoj login i haslo (oddzielone spacja lub koncem wiersza):\n");
  scanf("%s %s", nazwa, haslo);

  /* tworze gniazdo UDP */
  if((desk_udp = socket(AF_INET, SOCK_DGRAM, 0)) <0)
    blad("Blad przy tworzeniu gniazda UDP\n");
  bzero(&klient_udp, sizeof(klient_udp));
  klient_udp.sin_family = AF_INET;
  klient_udp.sin_port = 0;
  if(gethostname(nazwa_hosta, DL_NAZWY_HOSTA) != 0)
    blad("Blad w gethostname (1)\n");
  hp=gethostbyname(nazwa_hosta);
  if (hp==0)
    blad("Nieznany adres (1)\n");
  memcpy((char*) &klient_udp.sin_addr, (char*) hp->h_addr,hp->h_length);

  dlug = sizeof(klient_udp);
  if(bind(desk_udp, (struct sockaddr*)&klient_udp, dlug) < 0)
    blad("Blad przy bindowaniu UDP\n");
  if(getsockname(desk_udp, (struct sockaddr*)&klient_udp, &dlug) < 0)
    pisz_blad("Blad przy ustalaniu adresu UDP\n");

  /* Tworze gniazdo TCP */
  if((desk_tcp = socket(AF_INET, SOCK_STREAM, 0)) <0)
    blad("Blad przy tworzeniu gniazda TCP\n");
  bzero(&serwer_tcp, sizeof(serwer_tcp));
  serwer_tcp.sin_family = AF_INET;
  serwer_tcp.sin_port = htons(NR_PORTU);

  /* Nazwe serwera mozna podac jako parametr, jesli nie ma, to biezacy host. */
  if(argc == 2)
    strcpy(nazwa_hosta, argv[1]);
  else
    if(gethostname(nazwa_hosta, DL_NAZWY_HOSTA) != 0)
      blad("Blad w gethostname\n");
 
  hp=gethostbyname(nazwa_hosta);
  if (hp==0)
    blad("Nieznany adres\n");
  memcpy((char*) &serwer_tcp.sin_addr, (char*) hp->h_addr,hp->h_length);

  /* Potrzebuje tez adresu serwera UDP, zeby wiedziec od kogo czytac */
  bzero(&serwer_udp, dl_adresu_udp);
  serwer_udp.sin_family = AF_INET;
  serwer_udp.sin_port = htons(NR_PORTU_UDP);
  memcpy((char*) &serwer_udp.sin_addr, (char*) hp->h_addr,hp->h_length);

  /* Lacze sie z serwerem przez TCP */
  if(connect(desk_tcp, (struct sockaddr*)&serwer_tcp, sizeof(serwer_tcp)) == -1)
    blad("Blad przy connect\n");

  /* Wysylam pierwszy komunikat, podaje swoj adres udp, nazwe i haslo (oddzielone #) */
  bufor[0] = KOM_NOWY;
  memcpy(bufor+1, &dlug, sizeof(int)); /* dlugosc adresu */
  memcpy(bufor+1+sizeof(int), &klient_udp, dlug);
  strcpy(bufor+1+sizeof(int)+dlug, nazwa);
  bufor[1+sizeof(int)+dlug+strlen(nazwa)] = '#';
  strcpy(bufor+2+sizeof(int)+dlug+strlen(nazwa), haslo);
  if(write(desk_tcp, bufor, 3+strlen(nazwa)+strlen(haslo)+sizeof(int)+dlug) <0)
    blad("Blad przy pierwszym komunikacie\n");

  maks_deskr = (desk_tcp > desk_udp) ? desk_tcp : desk_udp; /* to sie nie zmieni */
  
  /* W petli czytam i reaguje na komunikaty:
   * - od uzytkownika
   * - od serwera TCP
   * - od serwera UDP
   */
  while(warunek){ /* warunek jest zerowany przy poleceniu quit i gdy serwer zamyka polaczenie */
    FD_ZERO(&zbior);
    FD_SET(0, &zbior);
    FD_SET(desk_tcp, &zbior);
    FD_SET(desk_udp, &zbior);
    
    if (select(maks_deskr+1, &zbior, NULL, NULL, NULL) < 0)
      pisz_blad("Blad w select\n");
    if (FD_ISSET(0, &zbior))
      wez_polecenie();
    if (FD_ISSET(desk_tcp, &zbior))
      wez_komunikat_tcp();
    if (FD_ISSET(desk_udp, &zbior))
      wez_komunikat_udp();
  }
  close(desk_udp);
  close(desk_tcp);
  return 0;
}
