<?PHP
include("common.phps");

function wyzeruj_uslugi(&$zbior, &$licznik)
/* Tworzy pusty zbior uslug */
{
  global $all_uslugi;
  global $all_uslugi_ile;
  
  for($i=0; $i < $all_uslugi_ile; $i++)
    $zbior[$all_uslugi[$i]] = 0;
    
  $licznik = 0;
}

function daj_pierwsza_usluge(&$zbior, &$licznik)
/* zwraca id pierwszej uslugi wystepujacej w niezerowej ilosci w zbiorze */
/* NIE USUWA */
/* w tej chwili "pierwsza" oznacza pierwsza w kolenosci z tablicy all_uslugi
 * (a tam s wpisywane zgodnie z priorytetem)
 */
{
  global $all_uslugi;
  global $all_uslugi_ile;

  for($i=0; $i < $all_uslugi_ile; $i++)
    if($zbior[$all_uslugi[$i]] > 0){
      return $all_uslugi[$i];
    }
}

function dodaj_uslugi(&$jakie, &$jakie_ile, &$dokad, &$dokad_ile)
/* Dla kazdej uslugi ze zbioru jakie:
 * * jednorazowej - wszystkie wystapienia ze zbioru jakie przenosi do dokad
 * * wielorazowej - jesli jeszcze nie ma w dokad, dodaje, nie usuwa z jakie
 */
{
  global $all_uslugi;
  global $all_uslugi_ile;
  global $jednorazowa;

  for($i=0; $i < $all_uslugi_ile; $i++){
    $id = $all_uslugi[$i];
    if($jednorazowa[$id]){
      if($jakie[$id] > 0){
        $dokad[$id] += $jakie[$id];
	$dokad_ile += $jakie[$id];
	$jakie_ile -= $jakie[$id];
	$jakie[$id] = 0;
      }
    } else {
      if($jakie[$id] > 0){
        if($dokad[$id] == 0){
	  $dokad[$id] = 1;
	  $dokad_ile += 1;
	}
      }
    }
  }
}

function odejmij_uslugi(&$jakie, &$jakie_ile, &$skad, &$skad_ile)
/* Dla kazdej uslugi ze bioru jakie:
 * jednorazowej - od obu zbiorow odejmuje tyle wystapien, zeby w ktoryms sie
 *                wyzerowalo
 * wielorazowej - jesli wystepuje w skad, to usuwa ja stamtad, nie usuwa z jakie
 */
{
  global $all_uslugi;
  global $all_uslugi_ile;
  global $jednorazowa;

  for($i=0; $i < $all_uslugi_ile; $i++){
    $id = $all_uslugi[$i];
    if($jednorazowa[$id]){
      if($jakie[$id] > 0 && $skad[$id] > 0){
        if($jakie[$id] > $skad[$id]){
	  $jakie[$id] -= $skad[$id];
	  $jakie_ile -= $skad[$id];
	  $skad_ile -= $skad[$id];
	  $skad[$id] = 0;
	} else {
	  $skad[$id] -= $jakie[$id];
	  $jakie_ile -= $jakie[$id];
	  $skad_ile -= $jakie[$id];
	  $jakie[$id] = 0;
	}
      }
    } else {
      if($jakie[$id] > 0){
        if($skad[$id] > 0){
	  $skad[$id] = 0;
	  $skad_ile -= 1;
	}
      }
    }
  }
}

function wyzeruj_sprzet(&$zbior, &$licznik)
/* Tworzy pusty zbior sprzetu */
{
  global $all_sprzet;
  global $all_sprzet_ile;
  
  for($i=0; $i<$all_sprzet_ile; $i++)
    $zbior[$all_sprzet[$i]] = 0;
    
  $licznik = 0;
}

function dodaj_jeden_sprzet($sprzet, &$dokad, &$licznik)
/* Do zbioru sprzetu dodaje jedno wystapienie podanego sprzetu */
{  /* sprzt jest zawsze jednorazowy */
  $dokad[$sprzet] += 1;
  $licznik += 1;
}

function wymagania_sprzetu($id_sprzetu, &$dokad, &$licznik)
/* Do zbioru dokad dodaje uslugi, ktorych wymaga podany sprzet */
{
  /* zakadam, e jestem poczony z baz danych przez $connection */
  global $connection;
  

  $query = pg_exec($connection,
    "SELECT Uslugi.id_uslugi, Uslugi.jednorazowa
       FROM Uslugi, Wymaga
       WHERE Uslugi.id_uslugi = Wymaga.id_uslugi
         AND Wymaga.id_sprzetu = '$id_sprzetu'");

  if(! $query)
    exit(0);
  $num = pg_numrows($query);  
  for($i=0; $i < $num; $i++) {
    $res = pg_fetch_row($query, $i);
    if($res[1] == 'T'){ /* jednorazowa */
        $dokad[(string)($res[0])] += 1;
	$licznik += 1;
      } else {
        if($dokad[(string)($res[0])] == 0){
          $dokad[(string)($res[0])] = 1;
          $licznik += 1;
	}
     }
  }
  pg_freeresult($query);
}

function zapewnienia_sprzetu($id_sprzetu, &$dokad, &$licznik)
/* Do zbioru uslug dodaje uslugi, ktore zapewnia podany sprzet */
{
  /* zakadam, e jestem poczony z baz danych przez $connection */
  global $connection;
  
  $query = pg_exec($connection,
    "SELECT Uslugi.id_uslugi, Uslugi.jednorazowa FROM Uslugi, Oferuje 
       WHERE Uslugi.id_uslugi = Oferuje.id_uslugi
         AND Oferuje.id_sprzetu = '$id_sprzetu'");

  if(! $query)
    exit(0);
  $num = pg_numrows($query);  
  for($i=0; $i < $num; $i++) {
    $res = pg_fetch_row($query, $i);
    if($res[1] == 'T'){ /* jednorazowa */
        $dokad[(string)($res[0])] += 1;
	$licznik += 1;
      } else {
        if($dokad[(string)($res[0])] == 0){
          $dokad[(string)($res[0])] = 1;
          $licznik += 1;
	}
     }
  }
  pg_freeresult($query);
}

function czy_byl_typ($nr_typu)
{
  global $typ;
  global $all_sprzet;
  global $all_sprzet_ile;
  global $zestaw;
  
  for($i = 0; $i < $all_sprzet_ile; $i++)
    if(($typ[$all_sprzet[$i]] == $nr_typu) && ($zestaw[$all_sprzet[$i]] > 0))
      return true;
  return false;
}


function wybierz_sprzet($ceny1, $mnoznik, $dzielnik, $max)
/* Heurystyczna funkcja, ktora dla podanej tabeli cen o rozmiarze max
 * zwraca indeks z tej tablicy sprzetu, ktory nalezy wybrac do zestawu.
 */
{
 foreach($ceny1 as $key => $wartosc) 
   $ceny[$key] = max($mnoznik/($wartosc+$dzielnik),$max);
 $suma = 0; // suma cen
 foreach($ceny as $wartosc) $suma += $wartosc;   
 mt_srand((double)(microtime())*1000000);
 $los = mt_rand(0,$suma-1);
 $pom = 0;
 foreach($ceny as $key => $wartosc) { 
   $pom += $wartosc;
   if ($pom > $los) return $key;
 }
}

function wybierz_sprzet_zapewniajacy($usluga)
/* Wybiera sprzet, ktory nalezy dodac do zestawu, aby zapewnic usluge.
 * Jesli nie ma sprzetu zapewniajacego ta usluge, zwraca -1
 */
/* Najpierw wsrod sprzetu podanego przez uzytkownika wyszukiwany jest sprzet,
 * ktory zapewnia ta usluge. Jesli znaleziony, usuwam go ze zbioru sprzet_uzytkownika
 * i dodaje do zestawu. Jesli nie, z bazy danych pobierany jest zbior sprzetu,
 * ktory zapewnia ta usluge, i z tego zbioru funkcja wybierz_sprzet wybierany
 * jest jeden sprzet, ktory zwraca funkcja.
 */
{
  /* zaklada e jest poczony z baz przez $connection */
  global $connection;
  global $sprzet_uzytkownika;
  global $sprzet_uzytkownika_ile;
  global $wybrany_uzytkownika;
  global $wybrany_uzytkownika_ile;
  global $zakazany;
  global $typ;
  global $all_sprzet;
  global $all_sprzet_ile;
  global $zestaw;
  global $zapewnienia;

  /* sprawdzenie czy jaki sprzt uytkownika zapewnia to */
  
  for($i=0; $i < $all_sprzet_ile; $i++){
    $id = $all_sprzet[$i];
    if($sprzet_uzytkownika[$id] > 0 && ($zakazany[$id] == false)){
      $query = pg_exec($connection, "SELECT id_sprzetu FROM Oferuje
                  WHERE id_sprzetu = '$id' AND id_uslugi = '$usluga'");
      $res = pg_fetch_row($query, 0);
      if($res){
        $sprzet_uzytkownika[$id] -= 1;
	$sprzet_uzytkownika_ile -= 1;
	$wybrany_uzytkownika[$id] += 1;
	$wybrany_uzytkownika_ile += 1;
        pg_freeresult($query);

        return $id;
      }
      pg_freeresult($query);
    }
  }
  
  /* teraz bierzemy z bazy danych */
    $query = pg_exec($connection, "SELECT Sprzet.id_sprzetu, Sprzet.cena_sprzetu FROM Sprzet, Oferuje
                  WHERE Sprzet.id_sprzetu = Oferuje.id_sprzetu
		    AND id_uslugi = '$usluga' ORDER BY Sprzet.cena_sprzetu");
    $ile1 = 0; $ile2 = 0; $ile3 = 0;
    if(! $query)
      exit(0);
    $num = pg_numrows($query);  
    for($i=0; $i < $num; $i++) {
      $res = pg_fetch_row($query, $i);
      $id = (string)($res[0]);
      if(! $zakazany[$id]){
	$qu = pg_exec($connection, "SELECT id_uslugi FROM Wymaga WHERE id_sprzetu = '$id'");
	$spelnia = true;
        if(! $qu)
          exit(0);
        $num = pg_numrows($qu);
        for($j=0; $j < $num; $j++) {
          $rez = pg_fetch_row($qu, $j);
	  if($zapewnienia[(string)($rez[0])] == 0)
	    $spelnia = false;
	}
	pg_freeresult($qu);
	if($spelnia){
          $znaleziony1[$ile1] = $id;
          $ceny1[$ile1++] = $res[1];
	}
        if(czy_byl_typ($typ[$id])){
          $znaleziony3[$ile3] = $id;
          $ceny3[$ile3++] = $res[1];
	} else {
          $znaleziony2[$ile2] = $id;
          $ceny2[$ile2++] = $res[1];
	}
      }
    }
    pg_freeresult($query);

  if($ile1 > 0){
    $a = wybierz_sprzet($ceny1, 1000, 30, 2);
    return $znaleziony1[$a];
  } else if($ile2 > 0){
    $a = wybierz_sprzet($ceny2, 1000, 30, 2);
    return $znaleziony2[$a];
  } else if($ile3 > 0){
    $a = wybierz_sprzet($ceny3, 1000, 30, 2);
    return $znaleziony3[$a];
  } else
    return -1;
}


/************ MAIN *************/


if(empty($KMK_NAZWA_PLIKU))
  przekieruj_na_start();
else {
  wczytaj_stan($KMK_NAZWA_PLIKU);

  naglowek_html();
  sekcja_head("Komputerowy Majster Klepka - wyniki");
?>
<BODY>
<?PHP

/* W tabeli $wybrane sa zapisane wybrane sprzty (w tym "wirtualne")
 * $wybrane[id_sprzetu] == 'T' oznacza, e dany sprzt jest wybrany,
 * $wybrane[id_sprzetu] == 'N' oznacza, e nie jest wybrany,
 * nieustawione dla danego id_sprzetu jesli takiego sprzetu nie bylo w zadnym menu
 */

  polacz($connection);

  $all_sprzet_ile = 0;
  $all_uslugi_ile = 0;
  $query = pg_exec($connection, "SELECT id_sprzetu, typ FROM Sprzet");
  if(! $query)
    exit(0);
  $num = pg_numrows($query);  
  for($i=0; $i < $num; $i++) {
    $res = pg_fetch_row($query, $i);
    $id = (string)($res[0]);
    $all_sprzet[$all_sprzet_ile++] = $id;
    $typ[$id] = (int) $res[1];

    /* z parametru p_zakaz odczytuj sprzt, ktrego ju nie mozna uy */
    if($p_zakaz[$id] == 'T')
      $zakazany[$id] = true;
    else
      $zakazany[$id] = false;
  }
  pg_freeresult($query);
  $query = pg_exec($connection, "SELECT id_uslugi, jednorazowa FROM Uslugi ORDER BY Priorytet");
  if(! $query)
    exit(0);
  $num = pg_numrows($query);  
  for($i=0; $i < $num; $i++) {
    $res = pg_fetch_row($query, $i);
    $id = (string)($res[0]);
    $all_uslugi[$all_uslugi_ile++] = $id;
    $jednorazowa[$id] = ($res[1] == 'T');
  }
  pg_freeresult($query);
  echo "\n";
  for($obrot=1; $obrot <= 10; $obrot++){
    wyzeruj_sprzet($zestaw, $zestaw_ile);
    wyzeruj_sprzet($sprzet_uzytkownika, $sprzet_uzytkownika_ile);
    wyzeruj_sprzet($wybrany_uzytkownika, $wybrany_uzytkownika_ile);
    wyzeruj_sprzet($zastosowania, $zastosowania_ile);

    wyzeruj_uslugi($niezaspokojone, $niezaspokojone_ile);
    wyzeruj_uslugi($zapewnienia, $zapewnienia_ile);


/* zainicjowanie zbiorw $sprzet_uzytkownika i $zastosowania zgodnie z tym
 * co poda uytkownik
 */

    $query = pg_exec($connection, "SELECT id_sprzetu FROM Menu_Sprzetu");
    if(! $query)
      exit(0);
    $num = pg_numrows($query);  
    for($i=0; $i < $num; $i++) {
      $res = pg_fetch_row($query, $i);
      $id = (string)($res[0]);
      if($wybrane[$id] == 'T'){
        $sprzet_uzytkownika[$id] += 1;
        $sprzet_uzytkownika_ile += 1;
      }
    }
    pg_freeresult($query);

    $query = pg_exec($connection, "SELECT id_sprzetu FROM Menu_Zastosowan");
    if(! $query)
      exit(0);
    $num = pg_numrows($query);  
    for($i=0; $i < $num; $i++) {
      $res = pg_fetch_row($query, $i);
      $id = (string)($res[0]);
      if($wybrane[$id] == 'T'){
        $zastosowania[$id] += 1;
        $zastosowania_ile += 1;
      }
    }
    pg_freeresult($query);
  
  /* wrd "zastosowa" zawsze musi by "minimalne" */
    if($zastosowania['11111111'] == 0){
      $zastosowania['11111111'] = 1;
      $zastosowania_ile += 1;
    }
  
  /*  for each s in zastosowania do
      zbior_wymagan += wymagania(s)  // uslugi jednorazowe powiela,
  */
  
    for($i = 0; $i < $all_sprzet_ile; $i++){
      $id = $all_sprzet[$i];
      while($zastosowania[$id] > 0){
        wyzeruj_uslugi($wym, $wym_ile);
        wymagania_sprzetu($id, $wym, $wym_ile);
        dodaj_uslugi($wym, $wym_ile, $niezaspokojone, $niezaspokojone_ile);
        $zastosowania[$id] -= 1;
        $zastosowania_ile -= 1;
      }
    }
  

  /* teraz trzeba ju normalnie wnioskowa - budowa zestaw */

    $porazka = false;
 
    while($niezaspokojone_ile > 0){
  
      $u = daj_pierwsza_usluge($niezaspokojone, $niezaspokojone_ile);
      $s = wybierz_sprzet_zapewniajacy($u);
      if($s == -1)
        $porazka = true;
      
      /* Sprawdzam czy wczeniej nie wybrano ju sprztu tego samego niezerowego typu */
      if(($ola = $typ[$s]) != 0)
        for($i=0; $i < $all_sprzet_ile; $i++){
          $id = $all_sprzet[$i];
  	  if(($zestaw[$id] > 0) && ($typ[$id] == $ola)){
  	    $zakazany[$id] = true;
	    $porazka = true;
	  }
        }
      if($porazka)
        break;
 /* POIK */
      dodaj_jeden_sprzet($s, $zestaw, $zestaw_ile);
      wyzeruj_uslugi($zap, $zap_ile);
      zapewnienia_sprzetu($s, $zap, $zap_ile);
      odejmij_uslugi($zap, $zap_ile, $niezaspokojone, $niezaspokojone_ile);
      dodaj_uslugi($zap, $zap_ile, $zapewnienia, $zapewnienia_ile);
    
      wyzeruj_uslugi($wym, $wym_ile);
      wymagania_sprzetu($s, $wym, $wym_ile);
      odejmij_uslugi($zapewnienia, $zapewnienia_ile, $wym, $wym_ile);
      dodaj_uslugi($wym, $wym_ile, $niezaspokojone, $niezaspokojone_ile);
    }
    if(! $porazka)
      break;
  }  // FOR
  
    rozlacz($connection);

/******* KONIEC OBLICZEN *********/

/* Teraz zestaw powinien zawiera zbudowany zestaw, albo porazka */

?>

<H1>Komputerowy Majster Klepka - Wyniki</H1>
<?PHP
  if($porazka){
?>
<P CLASS="wyn_porazka">
Niestety nie udao si zbudowa zestawu speniajcego Twoje wymagania.<BR>
Wykonano <?PHP echo "$obrot"; ?> prb.
</P>
<?PHP
  } else {
?>
<P>
Udao si zoy zestaw komputerowy speniajcy Twoje wymagania. Powido si przy <?PHP echo "$obrot"; ?> prbie.
</P><P>
Twj zestaw skada si z nastpujcych czci:
</P>
<TABLE BORDER CLASS="wyniki">
<CAPTION>Skad zestawu komputerowego</CAPTION>
<TR CLASS="wyn_naglowek">
<TD CLASS="wyn_naglowek">Nazwa</TD>
<TD CLASS="wyn_naglowek">Opis</TD>
<TD CLASS="wyn_naglowek" WIDTH="11%">Cena</TD>
</TR>
<?PHP
    polacz($connection);
    $query = pg_exec($connection, "SELECT id_sprzetu, nazwa_sprzetu, opis_sprzetu, wirtualny, cena_sprzetu FROM Sprzet ORDER BY cena_sprzetu DESC");
    $suma = 0.0;
    if(! $query)
      exit(0);
    $num = pg_numrows($query);  
    for($i=0; $i < $num; $i++) {
      $res = pg_fetch_row($query, $i);
      $id = (string)($res[0]);
      if($zestaw[$id] && ($res[3] == 'N')){
        echo "<TR CLASS=\"wyn\">";
	echo "<TD CLASS=\"wyn_nazwa\">";
        echo $res[1];
        echo "</TD><TD CLASS=\"wyn_opis\">";
	if(empty($res[2]))
	  echo "brak opisu";
	else
          echo $res[2];
        echo "</TD>";
        if($wybrany_uzytkownika[$id] > 0){
          $wybrany_uzytkownika[$id] -= 1;
          $wybrany_uzytkownika_ile -= 1;
          echo "<TD CLASS=\"wyn_uzytk_lista\"> Uytkownik </TD>";
        } else {
          echo "<TD CLASS=\"wyn_cena_lista\">";
          echo "$res[4] z";
          echo "</TD>";
          $suma += $res[4];
        }
        echo "</TR>";
      }
    }
    pg_freeresult($query);
  
    rozlacz($connection);
?>

</TABLE>
<P CLASS="wyn_cena">
Cena zestawu: <FONT CLASS = "wyn_cena">
<?PHP
    echo "$suma z";
?>
</FONT>
</P>

<?PHP
  } // else
?>

<P>
<A HREF="wyniki.php?
<?PHP
  $ile = 0;
  for($i = 0; $i < $all_sprzet_ile; $i++) {
    $id = $all_sprzet[$i];
    if($zakazany[$id]){
      if($ile >0)
        echo "&";
      echo "p_zakaz[$id]=T";
      $ile += 1;
    }
  }
?>" CLASS="wyn_jeszcze_raz" TARGET="_self">sprbuj jeszcze raz</A><BR>
<A HREF="start.php" CLASS="wyn_start" TARGET="_self">zmie ustawienia</A>
</P>

</BODY>

<?PHP
  stopka_html();
} // else
?>
