/* Patryk Czarnik */
/* Zadanie nr 4 z Programowania Wspolbieznego */

/* Pierwszy proces (lewy gorny w kracie procesow) */

#include <stdlib.h>
#include <stdio.h>
#include <unistd.h>
#include <signal.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <sys/time.h>
#include "err.h"
#include "geny.h"
#include "komunikacja.h"

#define CZEKAJ 1

/* Kanaly sa zmiennymi globalnymi, aby moc je usunac
 * w przypadku przerwania programu przez sygnal.
 */
Kanal
  prawy = {0, -1, -1, 0, 0},
  dolny = {0, -1, -1, 0, 0},
  ostatni = {0, -1, -1, 0, 0};

char *wprawo=NULL, *wdol=NULL;

static void porzadki(int sygnal)
/* Wywolywana przez sygnal SIG_INT, robi porzadki. */
{
  if(wprawo != NULL)
    free(wprawo);
  if(wdol != NULL)
    free(wdol);
  awaryjne(&prawy);
  awaryjne(&dolny);
  awaryjne(&ostatni);
  exit(1);
}

void zrob_krate(int dl_kraty, int dl_genu)
/* Tworzy procesy kraty. */
{
  int i,j;
  char srozm[10], sdlug[10], sx[10], sy[10];

  for(i=0; i<dl_kraty; i++)
   for(j=0; j<dl_kraty; j++)
    if((i!=0)||(j!=0))
      switch(fork()){
        case -1:
          syserr("pierwszy 1 - fork");
        case 0:
          sprintf(srozm, "%d", dl_kraty);
          sprintf(sdlug, "%d", dl_genu);
          sprintf(sx, "%d", i);
          sprintf(sy, "%d", j);
          execl("./krata", "krata", srozm, sdlug, sx, sy, 0);
          syserr("pierwszy 2 - execl");
        default:
      }
}

static void stworz_kanaly(int n, int rozm)
/* Tworzy (otwiera) kanaly do komunikacji z sasiednimi procesami.
 * Modyfikuje globalne zmienne typu Kanal.
 */
{
  prawy.klucz = 1;
  prawy.rozm = rozm;
  otworz_do_pisania(&prawy);

  dolny.klucz = 2;
  dolny.rozm = rozm;
  otworz_do_pisania(&dolny);

  ostatni.klucz = 2*((n-1)*n + (n-1)) +1;
  ostatni.rozm = rozm;
  otworz_do_czytania(&ostatni);
}

void czekaj_na_procesy(int n)
/* Czeka na zakonczenie procesow kraty. */
{
  int i;

  for(i=1; i<n*n; i++)
    if(wait(0) < 0)
      syserr("pierwszy - wait");
}

int main(int argc, char **argv)
{
  int dl_kraty, dl_genu, ile_razy;
  int obrot, czest=CZEST;
  long czas_s, czas_m;
  struct timeval tv;
  struct timezone tz;
  
  if(argc != 4)
    fatal("Zla liczba parametrow\n");
  if((sscanf(argv[1],"%d",&dl_kraty) != 1)||
     (sscanf(argv[2],"%d",&dl_genu) != 1)||
     (sscanf(argv[3],"%d",&ile_razy) != 1)||
     (dl_kraty < 2)||(dl_genu < 1)||(ile_razy < 0))
    fatal("Niepoprawne parametry");

  if(signal(SIGINT, porzadki) == SIG_ERR)
    syserr("pierwszy 3 - signal");
  zrob_krate(dl_kraty, dl_genu);
  stworz_kanaly(dl_kraty, dl_genu+5);
  if(((wprawo = (char *)malloc(dl_genu+5)) == NULL)||
     ((wdol = (char *)malloc(dl_genu+5)) == NULL))
    syserr("pierwszy - malloc");

  /* Niech krata sie ustabilizuje.
   * To chyba nie jest konieczne, ale strzezonego...
   */
  sleep(CZEKAJ);
  
  start();
  /* Komunikat koordynujacy */
  pisz(&prawy, wprawo, 5);
  pisz(&dolny, wdol, 5);
  czytaj(&ostatni, wdol, 5);
  
  /* Startowy genotyp */
  losowy(wprawo+4, dl_genu);
  /* Zaczynam mierzyc czas */
  if(gettimeofday(&tv, &tz) == -1)
    syserr("pierwszy - gettimeofday");
  czas_s = tv.tv_sec;
  czas_m = tv.tv_usec;
  for(obrot=1; obrot<=ile_razy; obrot++){
    strcpy(wdol+4, wprawo+4);
    mutacja(wprawo+4, czest);
    mutacja(wdol+4, czest);
    pisz(&prawy, wprawo, dl_genu+5);
    pisz(&dolny, wdol, dl_genu+5);
    czytaj(&ostatni, wprawo, dl_genu+5);
  }
  /* Koncze mierzyc czas */
  if(gettimeofday(&tv, &tz) == -1)
    syserr("pierwszy - gettimeofday");
  czas_m = 1000000*(tv.tv_sec - czas_s) + (tv.tv_usec - czas_m);
  /* ... w mikrosekundach */
  
  /* Komunikat konczacy */
  wdol[4] = 'A';
  pisz(&prawy, wdol, dl_genu+5);
  pisz(&dolny, wdol, dl_genu+5);
  zwolnij(&prawy);
  zwolnij(&dolny);
  czytaj(&ostatni, wdol, dl_genu+5);
  zwolnij(&ostatni);
  usun(&ostatni);
  /* Wyniki */
  printf("Wynikowy genotyp: %s\n",wprawo+4);
  printf("Przystosowanie: %d\n",przystosowanie(wprawo+4));
  printf("Czas: %ld\n",czas_m);
  free(wprawo);
  free(wdol);
  czekaj_na_procesy(dl_kraty);
  return(0);
}
