/* Patryk Czarnik */
/* Zadanie nr 4 z Programowania Wspolbieznego */

/* Proces kraty (nie lewy gorny). */

#include <stdlib.h>
#include <stdio.h>
#include <signal.h>
#include "err.h"
#include "geny.h"
#include "komunikacja.h"

/* Kanaly i miejsca na napisy sa zmiennymi globalnymi, aby moc je usunac
 * w przypadku przerwania programu przez sygnal.
 * Sa zainicjowane w razie gdyby przerwanie nastapilo przed utworzeniem laczy.
 */
static Kanal
  prawy = {0, -1, -1, 0, 0},
  lewy  = {0, -1, -1, 0, 0},
  dolny = {0, -1, -1, 0, 0},
  gorny = {0, -1, -1, 0, 0};

static char *zgory=NULL, *zlewej=NULL;

static void porzadki(int sygnal)
/* Wywolywana przez sygnal SIG_INT, robi porzadki. */
{
  if(zgory != NULL);
    free(zgory);
  if(zlewej != NULL)
    free(zlewej);
  awaryjne(&prawy);
  awaryjne(&lewy);
  awaryjne(&gorny);
  awaryjne(&dolny);
  exit(1);
}

static void stworz_kanaly(int n, int x, int y, int rozm)
/* Tworzy (otwiera) kanaly do komunikacji z sasiednimi procesami.
 * Modyfikuje globalne zmienne typu Kanal.
 */
{
  if(x > 0){
    lewy.klucz = 2*(n*y + (x-1)) +1;
    lewy.rozm = rozm;
    otworz_do_czytania(&lewy);
  }
  if(y > 0){
    gorny.klucz = 2*(n*(y-1) + x) +2;
    gorny.rozm = rozm;
    otworz_do_czytania(&gorny);
  }
  /*                |      prawy dolny     | */
  if((x < n-1) || ((x == n-1) && (y == n-1))){
    prawy.klucz = 2*(n*y + x) +1;
    prawy.rozm = rozm;
    otworz_do_pisania(&prawy);
  }
  if(y < n-1){
    dolny.klucz = 2*(n*y + x) +2;
    dolny.rozm = rozm;
    otworz_do_pisania(&dolny);
  }
}

int main(int argc, char **argv)
{
  int dl_kraty, dl_genu;
  int x, y;
  char *wprawo, *wdol;
  int wart_lewego, wart_gornego;
  int czest=CZEST;
  
  if(argc != 5)
    fatal("Zla liczba parametrow\n");
  if((sscanf(argv[1],"%d",&dl_kraty) != 1)||
     (sscanf(argv[2],"%d",&dl_genu) != 1)||
     (sscanf(argv[3],"%d",&x) != 1)||
     (sscanf(argv[4],"%d",&y) != 1))
    fatal("Niepoprawne parametry");

  printf("%d %d Urodzilem sie\n",x,y);
  if(signal(SIGINT, porzadki) == SIG_ERR)
    syserr("krata 3 - signal");
  stworz_kanaly(dl_kraty, x, y, dl_genu+5);
  if(((zlewej = (char *)malloc(dl_genu+5)) == NULL)||
     ((zgory = (char *)malloc(dl_genu+5)) == NULL))
    syserr("krata malloc");
  zlewej[4] = '0';
  zgory[4] = '0'; /* :) naprawde sie przez to psulo */  
  

  /* Komunikat koordynujacy */
  if(lewy.id1 >= 0)
    czytaj(&lewy, zlewej, 5);
  if(gorny.id1 >= 0)
    czytaj(&gorny, zgory, 5);
  if(prawy.id1 >= 0)
    pisz(&prawy, zlewej, 5);
  if(dolny.id1 >= 0)
    pisz(&dolny, zgory, 5);

  while(1){
    if(lewy.id1 >= 0)
      czytaj(&lewy, zlewej, dl_genu+5);
    if(gorny.id1 >= 0)
      czytaj(&gorny, zgory, dl_genu+5);
    if((zlewej[4] == 'A') || (zgory[4] == 'A')){
    /* Komunikat konczacy */
      zwolnij(&lewy);
      zwolnij(&gorny);
      usun(&lewy);
      usun(&gorny);
      /* Przesylam go dalej */
      zlewej[4] = 'A';
      if(prawy.id1 >= 0){
        pisz(&prawy, zlewej, dl_genu+5);
	zwolnij(&prawy);
      }
      if(dolny.id1 >= 0){
        pisz(&dolny, zlewej, dl_genu+5);
	zwolnij(&dolny);
      }	
      break;
    }
    if(lewy.id1 < 0){
      wprawo = zgory;
      wdol = zgory;
    }
    else if(gorny.id1 < 0){
      wprawo = zlewej;
      wdol = zlewej;
    }
    else{
      wart_lewego = przystosowanie(zlewej+4);
      wart_gornego = przystosowanie(zgory+4);
      if(random() <= RAND_MAX*(wart_lewego/(wart_lewego+wart_gornego)))
        wprawo = zlewej;
      else
        wprawo = zgory;
      if(random() <= RAND_MAX*(wart_lewego/(wart_lewego+wart_gornego)))
        wdol = zlewej;
      else
        wdol = zgory;
    }
    if(prawy.id1 >= 0){
      mutacja(wprawo+4, czest);
      pisz(&prawy, wprawo, dl_genu+5);
    }
    if(dolny.id1 >= 0){
      mutacja(wdol+4, czest);
      pisz(&dolny, wdol, dl_genu+5);
    }
  }
  free(zlewej);
  free(zgory);
  printf("%d %d Koniec\n",x,y);
  return(0);
}
