/* Patryk Czarnik */
/* Zadanie nr 4 z Programowania Wspolbieznego */

/* Naglowek bibliotek do komunikacji miedzy procesami */

#ifndef KOMUNIKACJA_H
#define KOMUNIKACJA_H

/* Pole klucz sluzy do inicjalizacji kanalu komunikacyjnego, dla
 * roznych kluczy zostana utworzone rozne kanaly (nalezy ustawic
 * to pole przed wywolaniem funkcji otworz...),
 * Przed wywolaniem pierwszej funkcji otworz... nalezy takze ustawic
 * pole rozm na maksymalny przewidywany rozmiar komunikatu.
 * Przy pisaniu i czytaniu podaje sie wskaznik do poczatku obszaru
 * pamieci z ktorego funkcja ma czytac / do ktorego pisac.
 * Cztery pierwsze bajty tego obszaru maja nie zawierac wlasciwej
 * informacji (funkcje moga je dowolnie modyfikowac !).
 * Owe cztery bajty maja byc uwzglednione w rozmiarze.
 */

typedef struct {
  long klucz;
  int id1;
  int id2;
  char *pamiec;
  int rozm;
} Kanal;

extern void otworz_do_pisania(Kanal *kanal);
/* Tworzy i otwiera lub otwiera istniejacy kanal komunikacyjny.
 * Wywolujacy proces bedzie mogl pisac.
 */

extern void otworz_do_czytania(Kanal *kanal);
/* Tworzy i otwiera lub otwiera istniejacy kanal komunikacyjny.
 * Wywolujacy proces bedzie mogl czytac.
 */

extern void pisz(Kanal *kanal, char *bufor, int rozmiar);
/* Pisze rozmiar bajtow z bufora do kanalu komunikacyjnego. */

extern void czytaj(Kanal *kanal, char *bufor, int rozmiar);
/* Czyta rozmiar bajtow z kanalu komunikacyjnego. */

extern void zwolnij(Kanal *kanal);
/* Zwalnia zasoby zwiazane z kanalem komunikacyjnym.
 * Funkcje te powinien wywolac proces po zakonczeniu uzywania kanalu.
 */

extern void usun(Kanal *kanal);
/* Usuwa kanal komunikacyjny (w ogole).
 * Funkcje te nalezy wywolac raz, gdy zaden proces nie korzysta juz z kanalu.
 */

extern void awaryjne(Kanal *kanal);
/* Usuwa kanal komunikacyjny (w ogole).
 * Funkcja napisana z mysla o zwalnianiu zasobow w przypadku awaryjnego
 * przerwania programu, stad brak kontroli bledow (aby nie bylo zapetlenia).
 */
#endif
