/* Patryk Czarnik */
/* Zadanie nr 4 z Programowania Wspolbieznego */

/* Biblioteka do komunikacji uzywajaca pamieci dzielonej. */

#include <sys/types.h>
#include <sys/ipc.h>
#include <sys/sem.h>
#include <sys/shm.h>
#include <errno.h>
#include "err.h"
#include "komunikacja.h"

/* Definicja przepisana z mana */
#if defined(__GNU_LIBRARY__) && !defined(_SEM_SEMUN_UNDEFINED)
/* union semun is defined by including <sys/sem.h> */
#else
/* according to X/OPEN we have to define it ourselves */
  union semun {
    int val;                    /* value for SETVAL */
    struct semid_ds *buf;       /* buffer for IPC_STAT, IPC_SET */
    unsigned short int *array;  /* array for GETALL, SETALL */
    struct seminfo *__buf;      /* buffer for IPC_INFO */
  };
#endif


/* Kazdy kanal komunikacyjny to blok pamieci dzielonej o rozmiarze podanym
 * w strukturze Kanal oraz zbior dwoch semaforow (synchronizacja
 * typu "producent - konsument"). klucz to parametr key w funkcjach
 * ...get, id1 to identyfikator segmentu pamieci, id2 - semaforow,
 * pamiec to wskaznik do poczatku dostepnego obszaru pamieci.
 */

void otworz_do_pisania(Kanal *kanal)
/* Tworzy i otwiera lub otwiera segment pamieci dzielonej o zadanym
 * rozmiarze i zbior dwoch semaforow. Ustawia wartosci semaforow
 * w sposob umozliwiajacy pisanie.
 */
{
  union semun sem;
  int id;

  if((id = shmget(kanal->klucz, kanal->rozm, 0666 | IPC_CREAT)) < 0)
    syserr("shm 1 - shmget");
  if((kanal->pamiec = shmat(id, 0, 0)) == 0)
    syserr("shm 2 - shmmat");
  kanal->id1 = id;
  if((id = semget(kanal->klucz, 2, 0666 | IPC_CREAT)) < 0)
    syserr("shm 3 - semget");
  kanal->id2 = id;
/* Inicjuje semafory, pisarz bedzie mogl pisac. */
  sem.val = 0;
  if(semctl(kanal->id2, 0, SETVAL, sem) < 0)
    syserr("shm 4 - semctl");
  sem.val = 1;
  if(semctl(kanal->id2, 1, SETVAL, sem) < 0)
    syserr("shm 5 - semctl");
}

void otworz_do_czytania(Kanal *kanal)
/* Tworzy i otwiera lub otwiera segment pamieci dzielonej o zadanym
 * rozmiarze i zbior dwoch semaforow. Jezeli semafory sa tworzone,
 * ustawiane sa na (0,0) - nie mozna an pisac, ani czytac.
 */
{
  int id;

  if((id = shmget(kanal->klucz, kanal->rozm, 0666 | IPC_CREAT)) < 0)
    syserr("shm 6 - shmget");
  if((kanal->pamiec = shmat(id, 0, 0)) == 0)
    syserr("shm 7 - shmmat");
  kanal->id1 = id;
  if((id = semget(kanal->klucz, 2, 0666 | IPC_CREAT)) < 0)
    syserr("shm 8 - semget");
  kanal->id2 = id;
}

void pisz(Kanal *kanal, char *bufor, int rozmiar)
{
  struct sembuf sem[1];
  register int i;

  /* P(producent) */
  sem[0].sem_num = 1;
  sem[0].sem_op = -1;
  sem[0].sem_flg= 0;
  if(semop(kanal->id2, sem, 1) < 0)
    syserr("shm 6 - semop");

  for(i=0; i<rozmiar; i++)
    kanal->pamiec[i] = bufor[i];
 
  /* V(konsument) */
  sem[0].sem_num = 0;
  sem[0].sem_op = 1;
  sem[0].sem_flg= 0;
  if(semop(kanal->id2, sem, 1) < 0)
    syserr("shm 7 - semop");
}

void czytaj(Kanal *kanal, char *bufor, int rozmiar)
{
  struct sembuf sem[1];
  register int i;

  /* P(konsument) */
  sem[0].sem_num = 0;
  sem[0].sem_op = -1;
  sem[0].sem_flg= 0;
  if(semop(kanal->id2, sem, 1) < 0)
    syserr("shm 8 - semop");

  for(i=0; i<rozmiar; i++)
    bufor[i] = kanal->pamiec[i];
 
  /* V(producent) */
  sem[0].sem_num = 1;
  sem[0].sem_op = 1;
  sem[0].sem_flg= 0;
  if(semop(kanal->id2, sem, 1) < 0)
    syserr("shm 9 - semop");
}

void zwolnij(Kanal *kanal)
/* Odlaczenie pamieci */
{
  if(kanal->id1 >= 0)
    if(shmdt(kanal->pamiec) < 0)
      syserr("shm 10 - shmdt");
}

void usun(Kanal *kanal)
/* Usuniecie segmentu pamieci dzielonej i zbioru semaforow. */
{
  union semun sem;

  if(kanal->id1 >= 0){
    if(shmctl(kanal->id1, IPC_RMID, 0) < 0)
      syserr("shm 11 - shmctl");
    kanal->id1 = -1;
  }
  if(kanal->id2 >= 0){
    if(semctl(kanal->id2, 0, IPC_RMID, sem) < 0)
      syserr("shm 12 - semctl");
    kanal->id2 = -1;
  }
}

void awaryjne(Kanal *kanal)
/* Usuniecie segmentu pamieci dzielonej i zbioru semaforow. */
{
  union semun sem;

  if(kanal->id1 >= 0)
    shmctl(kanal->id1, IPC_RMID, 0);
  if(kanal->id2 >= 0)
    semctl(kanal->id2, 0, IPC_RMID, sem);
}
