/* Patryk Czarnik */
/* Zadanie nr 4 z Programowania Wspolbieznego */

/* Biblioteka komunikacji przy uzyciu kolejek komunikatow IPC. */

#include <sys/types.h>
#include <sys/ipc.h>
#include <sys/msg.h>
#include "err.h"
#include "komunikacja.h"

/* Kazdy kanal komunikacyjny to osobna kolejka komunikatow.
 * klucz jest parametrem key w funkcji msgget,
 * id1 jest identyfikatorem kolejki. Wszystkie komunikaty maja typ 1.
 */

void otworz_do_pisania(Kanal *kanal)
/* Otwiera z opcja IPC_CREAT kolejke komunikatow o zadanym kluczu.
 * Jesli kolejki jeszce nie ma, zostanie utworzona, jesli jest,
 * wywolujacy proces bedzie mogl z niej korzystac.
 */
{
  int msqid;

  if((msqid = msgget(kanal->klucz, 0666 | IPC_CREAT)) < 0)
    syserr("msg 1 - msgget");
  kanal->id1 = msqid;
}

void otworz_do_czytania(Kanal *kanal)
/* W tym przypadku identyczne z funkcja otworz_do_pisania. */
{
  otworz_do_pisania(kanal);
}

void pisz(Kanal *kanal, char *bufor, int rozmiar)
/* Wyslanie komunikatu */
{
  struct msgbuf *qbuf;

  qbuf = (struct msgbuf *)bufor;
  qbuf->mtype = 1;
  if(msgsnd(kanal->id1, qbuf, rozmiar - sizeof(long), 0) < 0)
    syserr("msg 2 - msgsnd");
}

void czytaj(Kanal *kanal, char *bufor, int rozmiar)
/* Odebranie komunikatu */
{
  struct msgbuf *qbuf;

  qbuf = (struct msgbuf *)bufor;
  if(msgrcv(kanal->id1, qbuf, rozmiar - sizeof(long), 1, 0) < 0)
    syserr("msg 3 - msgrcv");
}

void zwolnij(Kanal *kanal)
{
}

void usun(Kanal *kanal)
{
  if(kanal->id1 >= 0){
    if(msgctl(kanal->id1, IPC_RMID, 0) < 0)
      syserr("msg 4 - msgctl");
    kanal->id1 = -1;
  }
}

void awaryjne(Kanal *kanal)
{
  if(kanal->id1 >= 0)
    msgctl(kanal->id1, IPC_RMID, 0);
}
