/* Patryk Czarnik */
/* Zadanie nr 4 z Programowania Wspolbieznego */

/* Biblioteka do komunikacji uzywajaca kolejek FIFO. */

#include <stdio.h>
#include <unistd.h>
#include <fcntl.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <errno.h>
#include "err.h"
#include "komunikacja.h"
/* Kazdy kanal komunikacyjny jest osobnym laczem nazwanym.
 * klucz jest wlaczany w nazwe pliku okreslajaca lacze.
 * id1 to numer deskryptora, pod ktorym proces wywolujacy funkcje
 * bedzie mial otwarte lacze FIFO.
 */

void otworz_do_pisania(Kanal *kanal)
{
  int fd;
  char nazwa[24];

  sprintf(nazwa,"FIFO%ld.tmp",kanal->klucz);

  /* Jesli jestem pierwszy - tworze FIFO,
   * jesli juz istnieje (errno == EEXIST), to nic nie robie.
   */
  if((mknod(nazwa, S_IFIFO | 0666, 0) < 0) && (errno != EEXIST))
    syserr("fifo 1 - mknod");

  /* Otwieram lacze do pisania */
  if((fd = open(nazwa, O_WRONLY)) < 0)
    syserr("fifo 2 - open");
  kanal->id1 = fd; /* id1 jest numerem deskryptora */
}

void otworz_do_czytania(Kanal *kanal)
{
  int fd;
  char nazwa[24];

  sprintf(nazwa,"FIFO%ld.tmp",kanal->klucz);

  /* Jesli jestem pierwszy - tworze FIFO,
   * jesli juz istnieje (errno == EEXIST), to nic nie robie.
   */
  if((mknod(nazwa, S_IFIFO | 0666, 0) < 0) && (errno != EEXIST))
    syserr("fifo 1 - mknod");

  /* Otwieram lacze do czytania */
  if((fd = open(nazwa, O_RDONLY)) < 0)
    syserr("fifo 2 - open");
  kanal->id1 = fd; /* id1 jest numerem deskryptora */
}

void pisz(Kanal *kanal, char *bufor, int rozmiar)
{
  if(write(kanal->id1, bufor, rozmiar) != rozmiar)
    syserr("fifo 3 - write");
}

void czytaj(Kanal *kanal, char *bufor, int rozmiar)
{
  /* read jest wykonywane w sposob blokujacy. write pisze tymi samymi
     porcjami */
 
  if(read(kanal->id1, bufor, rozmiar) < rozmiar)
    syserr("fifo 4 - read");
}

void zwolnij(Kanal *kanal)
/* Zamyka lacze dla danego procesu. */
{
  if(kanal->id1 >= 0)
    if(close(kanal->id1) == -1)
      syserr("fifo 5 - close");
}

void usun(Kanal *kanal)
/* Wywolanie unlink. */
{
  char nazwa[24];

  sprintf(nazwa,"FIFO%ld.tmp",kanal->klucz);

  if(kanal->id1 >= 0){
    if(unlink(nazwa) < 0)
      syserr("fifo 6 - unlink");
    kanal->id1 = -1;
  }
}

void awaryjne(Kanal *kanal)
/* Wywolanie unlink. */
{
  char nazwa[24];

  if(kanal->id1 >= 0){
    sprintf(nazwa,"FIFO%ld.tmp",kanal->klucz);
    unlink(nazwa);
  }
}
