/* Patryk Czarnik */

#include <stdio.h>
#include <stdlib.h>
#include <pthread.h>
#include "err.h"

typedef struct sWezel{
  int wart;
  int flaga;
  int krok;
  pthread_mutex_t mut;
  pthread_cond_t czytanie;
  pthread_cond_t pisanie;
  pthread_t watek;
  struct sWezel *nast;
} Wezel;

/* Wartosci flagi */
#define F_ZAPIS      1
#define F_ODCZYT     2
#define F_PIERWSZY   3
#define F_ZAKONCZONY 4

int err;

void init(Wezel *w)
/* Inicjuje dany wezel, w tym mutexa i conditionale */
{
  if ((err = pthread_mutex_init(&w->mut, 0) != 0))
    syserr ("mutex init failed", err);
  if ((err = pthread_cond_init(&w->czytanie, 0)) != 0)
    syserr ("cond init failed", err);
  if ((err = pthread_cond_init(&w->pisanie, 0)) != 0)
    syserr ("cond init failed", err);
  w->krok = 0;  
  w->flaga = F_ZAPIS;
  w->nast = w+1;  /* operacja na wskaznikach, zaklada, ze wezly sa w spojnej tablicy */
}

int zrobListe(int rozmiar, Wezel **poczatek)
/* Tworzy i inicjuje liste o zadanym rozmiarze. *poczatek bedzie jednoczesnie
 * tablica wszystkich wezlow i wskaznikiem do pierwszego wezla listy.
 */
{
  int i;

  if((*poczatek = (Wezel *)malloc(rozmiar * sizeof(Wezel))) == NULL)
    return -1;
  for(i=0; i<rozmiar; i++)
    init(*poczatek + i);
  (*poczatek)[0].flaga = F_PIERWSZY;
  (*poczatek)[rozmiar-1].nast = NULL;
  return 0;
}

void wypiszListe(Wezel *l)
/* Wypisuje wartosci z listy */
{
  printf("Lista:\n");
  for(;l!=NULL; l=l->nast)
    printf("% 5d",l->wart);
  printf("\nKoniec listy\n");
}

void wypiszTablice(Wezel *t, int n)
/* Wypisuje wartosci z tablicy */
{
  int i;

  printf("Tablica:\n");
  for(i=0; i<n; i++)
    printf("% 5d",t[i].wart);
  printf("\nKoniec tablicy\n");
}

void clean(Wezel *w)
/* Sprzata dany wezel odinstalowujac conditionale i mutex */
{
  if ((err = pthread_cond_destroy(&w->czytanie)) != 0)
    syserr ("cond init failed", err);
  if ((err = pthread_cond_destroy(&w->pisanie)) != 0)
    syserr ("cond init failed", err);
  if ((err = pthread_mutex_destroy(&w->mut) != 0))
    syserr ("mutex destroy failed", err);
}

void zwolnijPamiec(Wezel **poczatek, int n)
/* Niszczy tablice wezlow */
{
  int i;

  for(i=0;i<n;i++)
    clean(*poczatek +i);
  free(*poczatek);
  *poczatek = NULL;
}

void *watek(void *param)
{
  Wezel *wezel;
  int tmp_int;
  Wezel *tmp_point;

  wezel = (Wezel *)param;

  /* Zainicjowanie wartosci */
  if(wezel->nast == NULL)
    wezel->wart = 0;
  else
    wezel->wart = 1;
  /* Ustawienie flagi i kroku (w sekcji krytycznej) */
  if ((err = pthread_mutex_lock(&wezel->mut)) != 0)
    syserr ("lock failed", err);
  if(wezel->nast == NULL)
    wezel->flaga = F_ZAKONCZONY;  
  else if(wezel->flaga == F_ZAPIS)
    wezel->flaga = F_ODCZYT;
  wezel->krok=1;
  if ((err = pthread_cond_broadcast(&wezel->czytanie)) != 0)
    syserr ("cond signal failed", err);
 /* Oddaje swojego mutexa */
  if ((err = pthread_mutex_unlock(&wezel->mut)) != 0)
    syserr ("unlock failed", err);
      
  while(wezel->nast != NULL){    /* kolejny krok algorytmu */

    /* CZYTANIE */
    /* Oczekiwanie az nastepnik bedzie gotowy aby go odczytac */
    if ((err = pthread_mutex_lock(&wezel->nast->mut)) != 0)
      syserr ("lock failed", err);
    while ((wezel->nast->flaga != F_ZAKONCZONY)&&
           ((wezel->nast->flaga == F_ZAPIS)||(wezel->krok != wezel->nast->krok)))
      if ((err = pthread_cond_wait(&wezel->nast->czytanie, &wezel->nast->mut)) != 0)
        syserr ("cond wait failed", err);
    /* Mozna czytac, mam mutexa nastepnika */
    tmp_int = wezel->wart + wezel->nast->wart;
    tmp_point = wezel->nast->nast;
    /* Ustawienie flagi nastepnikowi */
    if(wezel->nast->flaga == F_ODCZYT){
      if(wezel->flaga == F_PIERWSZY)
        wezel->nast->flaga = F_PIERWSZY;
      else
        wezel->nast->flaga = F_ZAPIS;
    /* Juz mozna pisac u nastepnika */
    }
    if ((err = pthread_cond_signal(&wezel->nast->pisanie)) != 0)
      syserr ("cond signal failed", err);
    /* Oddaje mutexa nastepnika */
    if ((err = pthread_mutex_unlock(&wezel->nast->mut)) != 0)
      syserr ("unlock failed", err);

    /* PISANIE */
    /* Oczekiwanie az bedzie mozna pisac */
    if ((err = pthread_mutex_lock(&wezel->mut)) != 0)
      syserr ("lock failed", err);
    while (wezel->flaga == F_ODCZYT)
      if ((err = pthread_cond_wait(&wezel->pisanie, &wezel->mut)) != 0)
        syserr ("cond wait failed", err);
    /* Mozna pisac, mam swojego mutexa */
    wezel->wart = tmp_int;
    wezel->nast = tmp_point;
    wezel->krok++;
    /* Ustawiam swoja flage */
    if(wezel->nast == NULL)
      wezel->flaga = F_ZAKONCZONY;  
    else if(wezel->flaga == F_ZAPIS)
      wezel->flaga = F_ODCZYT;
    if ((err = pthread_cond_broadcast(&wezel->czytanie)) != 0)
      syserr ("cond signal failed", err);
    /* Oddaje swojego mutexa */
    if ((err = pthread_mutex_unlock(&wezel->mut)) != 0)
      syserr ("unlock failed", err);
  }
  return (void *)wezel;
}

int main(int argc, char **argv)
{
  int i,n;
  Wezel *lista;
  pthread_attr_t attr;
  void *retval;

  if(argc != 2)
    fatal("Zla liczba parametrow\n");
  if((sscanf(argv[1],"%d",&n) != 1)||(n < 1))
    fatal("Niepoprawne parametry\n");  
  if(zrobListe(n,&lista) != 0)
    syserr("malloc",0);
  wypiszListe(lista);
  if ((err = pthread_attr_init (&attr)) != 0)
    syserr ("attr init failed", err);
  if ((err = pthread_attr_setdetachstate (&attr,PTHREAD_CREATE_JOINABLE)) != 0)
    syserr ("setdetachstate failed", err);
  printf("Teraz ruszaja watki\n");
  for(i=0;i<n;i++)
    if ((err = pthread_create(&(lista[i].watek), &attr, watek, (void *)(lista +i))) != 0)
      syserr ("create failed", err);
  for(i=0;i<n;i++)
    if ((err = pthread_join(lista[i].watek, &retval)) != 0)
      syserr ("join1 failed", err);
  printf("Watki zakonczyly sie\n");
  wypiszTablice(lista, n);
  zwolnijPamiec(&lista, n);
  if ((err = pthread_attr_destroy (&attr)) != 0)
    syserr ("attr destroy failed", err);       
  return 0;
}
