/* Patryk Czarnik */
/* Definicje stalych, typow i deklaracje funkcji uzywanych w programach *
 * sekretarz i wyborca. */

#ifndef _WYBORY_H
#define _WYBORY_H

/* Czas oczekiwania przez sekretarza na zgloszenie kandydatow.*
 * 0 oznacza czekanie zawsze na wszystkich.                   */
#define STARTTIME 2

/* Maksymalny czas zalatwiania wlasnych spraw. */
#define SPRAWY 4

/* Makro obliczajace quorum dla zadanej liczby wyborcow */
#define QUORUM(n) (2*n)/3

/* Ile kolejnych wyborow musi wygrac jeden kadydat aby wybory sie zakonczyly */
#define ILE_WYB 2

/* Struktura do przesylania komunikatow */
typedef struct {
  long	mesg_type;	
  int	mesg_data;
} Mesg;

/* Klucze kolejek komunikatow */
#define KOL1 1010L
#define KOL2 1111L
#define	KOL3 1234L

/* Specjalne wartosci przekazywane przez kolejke */
#define OGLOSZENIE_WYBOROW 1
#define LISTA_KANDYDATOW   2

extern void zarezerwuj_zasoby(int n, int **tab, int *kol1, int *kol2, int *kol3,
                       void (*obsluga_sygnalu)(int));
/* Tworzy tablice tab typu int o rozmiarze n, a takze tworzy lub udostepnia *
 * trzy kolejki komunikatow (flagi 0666|IPC_CREAT). */

extern void zwolnij_zasoby(int **tab, int *kol1, int *kol2, int *kol3, int usun_kolejki);
/* Zwalnia zarezerwowane wczesniej zasoby. Kolejki usuwa jesli usun_kolejki != 0*/

extern void start_losowania(int n);
/* Inicjuje generator liczb pseudolosowych korzystajac z czasu systemowego. */

extern int losowa(int zakres);
/* Pascalowy Random: zwraca liczbe losowa od 0 do zakres-1. */

#endif
