/* Patryk Czarnik */

#include <stdlib.h>
#include <stdio.h>
#include <time.h>
#include <signal.h>
#include "systemv.h"
#include <sys/types.h>
#include <sys/ipc.h>
#include <sys/msg.h>
#include "err.h"
#include "wybory.h"

void zarezerwuj_zasoby(int n, int **tab, int *kol1, int *kol2, int *kol3,
                       void (*obsluga_sygnalu)(int))
{
  if ((signal(SIGINT, obsluga_sygnalu) == SIG_ERR) ||
      (signal(SIGQUIT, obsluga_sygnalu) == SIG_ERR) ||
      (signal(SIGTERM, obsluga_sygnalu) == SIG_ERR))
    syserr("og 5 signal");
  if((*tab = (int *)malloc((n+1) * sizeof(int))) == NULL)
    syserr("og 1 malloc");
  if ((*kol1 = msgget(KOL1, 0666 | IPC_CREAT)) == -1)
    syserr("og 2 msgget");
  if ((*kol2 = msgget(KOL2, 0666 | IPC_CREAT)) == -1)
    syserr("og 3 msgget");
  if ((*kol3 = msgget(KOL3, 0666 | IPC_CREAT)) == -1)
    syserr("og 4 msgget");
}

void usun_kolejke(int *kol)
{
  if (*kol != -1){
    if(msgctl(*kol, IPC_RMID, 0) == -1)
      syserr("og 6 msgctl RMID");
    *kol = -1;
  }  
}

void zwolnij_zasoby(int **tab, int *kol1, int *kol2, int *kol3, int usun_kolejki)
{
  if(*tab != NULL){
    free(*tab);
    *tab = NULL;
  }
  if(usun_kolejki){
    usun_kolejke(kol1);
    usun_kolejke(kol2);
    usun_kolejke(kol3);
  }  
}

void start_losowania(int n)
{
  srandom((int)time(0) + n);
}

int losowa(int zakres)
{
 return (random() % zakres);
}
