/* Patryk Czarnik */

#include <stdlib.h>
#include <stdio.h>
#include <unistd.h>
#include <signal.h>
#include "systemv.h"
#include <sys/types.h>
#include <sys/ipc.h>
#include <sys/msg.h>
#include "err.h"
#include "wybory.h"

int *kandydaci = NULL;
int kol_zgloszen = -1, kol_do_sekretarza = -1, kol_do_wyborcow = -1;

int co_robic(int numer, int kol_wyb)
/* Odczytuje z kolejki informacje decydujaca o podjetej akcji. */
{
  Mesg wiad;

  if(msgrcv(kol_wyb, &wiad, sizeof(int), numer, 0) <= 0)
    syserr("wyb 1 msgrcv");
  return wiad.mesg_data;
}

void wlasne_sprawy()
{
  int czas;
  czas = losowa(SPRAWY);
  sleep(czas);
}

void zgloszenie(int numer, int kol_zgl)
/* Wyslanie zgloszenia do sekretarza. */
{
  Mesg wiad;

  wiad.mesg_type = numer;
  wiad.mesg_data = numer;
  if(msgsnd(kol_zgl, &wiad, sizeof(int), 0) != 0)
    syserr("wyb 2 msgsnd");
}

void wczytaj_liste(int numer, int kol_wyb, int *kandydaci)
/* Odczytanie z kolejki listy kandydatow. */
{
  Mesg wiad;
  int k;

  if(msgrcv(kol_wyb, &wiad, sizeof(int), numer, 0) == -1)
    syserr("wyb 4 msgrcv");
  kandydaci[0] = wiad.mesg_data;
  for(k=1; k<=kandydaci[0]; k++){
    if(msgrcv(kol_wyb, &wiad, sizeof(int), numer, 0) == -1)
      syserr("wyb 5 msgrcv");
    kandydaci[k] = wiad.mesg_data;
  }
}

void wyslij_wynik(int numer, int kol_sek, int wynik)
/* Wyslanie identyfikatora wybranego kandydata. */
{
  Mesg wiad;

  wiad.mesg_type = numer;
  wiad.mesg_data= wynik;
  if(msgsnd(kol_sek, &wiad, sizeof(int), 0) == -1)
    syserr("wyb 5 msgsnd");
}

int wybierz(int *kandydaci)
/* Wybor kanydata z listy. */
{
  int a;

  a = losowa(kandydaci[0]) +1;
  return kandydaci[a];
}

void przerwanie(int typ_sygnalu)
/* Obsluga sygnalu konczacego prace wyborcy. */
{
  zwolnij_zasoby(&kandydaci, &kol_zgloszen, &kol_do_sekretarza, &kol_do_wyborcow, 0);
  exit(1);
}

int main(int argc, char **argv)
{
  int n, numer;
  int co;

  if(argc != 3)
    fatal("Wyborca: Zla liczba parametrow\n");
  if((sscanf(argv[1],"%d",&n) == -1) || (sscanf(argv[2],"%d",&numer) == -1))
    fatal("Wyborca: Niepoprawne parametry\n");
  zarezerwuj_zasoby(n, &kandydaci, &kol_zgloszen, &kol_do_sekretarza,
                    &kol_do_wyborcow, przerwanie);
  start_losowania(numer);
  while(1) /* prgram moze zakonczyc tylko sygnal */
    switch(co = co_robic(numer, kol_do_wyborcow)){
      case OGLOSZENIE_WYBOROW:
        wlasne_sprawy();
        zgloszenie(numer, kol_zgloszen);
        break;
      case LISTA_KANDYDATOW:
        wczytaj_liste(numer, kol_do_wyborcow, kandydaci);
        wyslij_wynik(numer, kol_do_sekretarza, wybierz(kandydaci));
        break;
    }
  return 0;
}
