/* Patryk Czarnik */

#include <stdlib.h>
#include <stdio.h>
#include <unistd.h>
#include <errno.h>
#include <asm/errno.h>
#include <signal.h>
#include "systemv.h"
#include <sys/types.h>
#include <sys/ipc.h>
#include <sys/msg.h>
#include <sys/wait.h>
#include "err.h"
#include "wybory.h"

/* Zmienne potrzebne funkcji konczacej dzialanie programu sa globalne, *
 * aby ta funkcja (zakoncz_prace) miala do nich dostep. */
int *wyborcy = NULL, n;
int kol_zgloszen = -1, kol_do_sekretarza = -1, kol_do_wyborcow = -1;

void przeterminowanie (int typ_sygnalu) {}

void stworz_wyborcow(int ilu_ma_byc)
/* Tworzy ilu_ma_byc procesow wyborcow */
{
  int i;
  char par1[8], par2[8];

  printf("Tworzenie procesow wyborcow\n");
  for(i=1;i<=ilu_ma_byc;i++)
    switch(fork()){
     case -1 : syserr("sek 1 fork");
     case  0 :
       sprintf(par1,"%d",n);
       sprintf(par2,"%d",i);
       execl("./wyborca","wyborca",par1,par2,NULL);
       syserr("sek 3 execl");
    }
  printf("Wyborcy utworzeni.\n");  
}

void oglos_wybory(int *wyborcy, int kol_do_wyb)
/* Do wyborcow z tablicy wyborcy wysyla informacje o rozpoczeciu nowego *
 * glosowania. Tablica wyborcy powinna zawierac w pierwszym glosowaniu  *
 * wszystkich wyborcow, a w kolejnych tych, ktorzy ostatnio zdazyli sie *
 * zglosic, ci ktorzy nie zdazyli beda sie i tak zglaszac. */
{
  int i;
  Mesg wiad;

  printf("\nOglaszanie glosowania\n");
  wiad.mesg_data = OGLOSZENIE_WYBOROW;
  for(i=1;i<=wyborcy[0];i++){
    wiad.mesg_type = wyborcy[i];  /* numer wyborcy, dla ktorego jest wiadomosc */
    if(msgsnd(kol_do_wyb, &wiad, sizeof(int), 0) != 0)
      syserr("sek 4 msgsnd");
  }
}

int zbieraj_zgloszenia(int n, int *wyborcy, int kol_zgl)
/* Odczytuje od wyborcow zgloszenia checi udzialu w glosowaniu.         *
 * Odczytuje wszystkie zgloszenia z kolejki w kolejnosci ich zglaszania *
 * az wszyscy sie zglosza, albo minie czas STARTTIME. Zwraca liczbe zgloszonych */
{
  void (*handler)(int);
  int i;
  Mesg wiad;
 
  if ((handler = signal(SIGALRM, przeterminowanie)) == SIG_ERR)
    syserr("sek 5 signal");

  alarm(STARTTIME);
  for(i=1; i<=n; i++){
    if(msgrcv(kol_zgl, &wiad, sizeof(int), 0, 0) <= 0)
      if(errno == EINTR)
        break;
      else
        syserr("sek 6 msgrcv");
    else
      wyborcy[i] = wiad.mesg_data;  /* numer zgloszonego kandydata */
  }
  alarm(0);

  if (signal(SIGALRM, handler) == SIG_ERR)
    syserr("sek 7 signal");

  /* Ostatnia zapisana pozycja w tablicy jest i-1. */
   wyborcy[0] = i-1;
   printf("Zglosilo sie %d wyborcow\n",i-1);
   return i-1;
}

int wybory(int n, int *wyb, int kol_sek, int kol_wyb)
/* Przeprowadzenie wyborow z udzialem wyborcow zapisanych w tablicy wyb.*
 * Zwraca zwyciezce lub 0, jesli nie bylo rozstrzygniecia.              */
{
  int w, k;
  int minimum;
  int *kandydaci, *glosy;
  Mesg wiad;

  if((kandydaci = (int *)malloc((wyb[0]+1) * sizeof(int))) == NULL)
    syserr("sek 8 malloc");
  if((glosy = (int *)malloc((n+1) * sizeof(int))) == NULL)
    syserr("sek 9 malloc");
  /* Poczatkowo kandydatem jest kazdy wyborca. */
  for(k=0; k<=wyb[0]; k++)
    kandydaci[k] = wyb[k];
  while(kandydaci[0] > 1){  /* jedna tura glosowania */
    printf("tura ");
   /* Rozeslanie list */
    for(w=1; w<=wyb[0]; w++){
    /* Informacja, ze zaraz przesylam liste  */
      wiad.mesg_type = wyborcy[w];
      wiad.mesg_data = LISTA_KANDYDATOW;
      if(msgsnd(kol_wyb, &wiad, sizeof(int), 0) != 0)
        syserr("sek 10 msgsnd");
    /* Przeslanie calej tablicy */    
      for(k=0; k<=kandydaci[0]; k++){
        wiad.mesg_data = kandydaci[k];
        if(msgsnd(kol_wyb, &wiad, sizeof(int), 0) != 0)
            syserr("sek 12 msgsnd");
      }  
    }
   /* Zbieranie glosow */
    for(k=1; k<=kandydaci[0]; k++)
      glosy[kandydaci[k]] = 0;
    for(w=1; w<=wyborcy[0]; w++){
      if(msgrcv(kol_sek, &wiad, sizeof(int), wyborcy[w], 0) <= 0)
        syserr("sek 14 msgrcv");
      else
        glosy[wiad.mesg_data]++;  /* glos na danego kandydata */
    }
   /* Podliczenie glosow */
    /* znalezienie minimalnej liczby glosow */
    minimum = wyborcy[0]+1;
    for(k=1; k<=kandydaci[0]; k++)
      if(glosy[kandydaci[k]] < minimum)
        minimum = glosy[kandydaci[k]];
    /* do nowej tury przechodza tylko ci, ktorzy zdobyli wiecej glosow */
    w = 1;
    for(k=1; k<=kandydaci[0]; k++)
      if(glosy[kandydaci[k]] > minimum)
        kandydaci[w++] = kandydaci[k];
    kandydaci[0] = w-1;
    printf("zostalo %d kandydatow\n",w-1);
  } /* koniec tury */
  /* kandydaci[0] <= 1 */
  if(kandydaci[0] == 1){
    w = kandydaci[1];
    printf("Glosowanie wygral %d\n",w);
  }  
  else{
    w = 0;
    printf("Glosowanie nierozstrzygniete\n");
  }  
  free(kandydaci);
  free(glosy);
  return w;
}

void zakoncz_wyborcow(int n)
/* Wysyla sygnal SIGINT do wyborcow i czeka na ich zakonczenie. */
{
  int i;
  /* Wysylam sygnal o zakonczeniu do wyborcow */
  printf("Wyslanie sygnalu zakonczenia do wyborcow %d\n", n);
  if(kill(-1, SIGINT) == -1)
    syserr("sek 16 kill");
  /* I czekam az procesy wyborcow sie zakoncza */
  printf("Oczekiwanie na zamkniecie\n");
  for(i=1; i<=n; i++)
    if(wait(0) == -1)
      syserr("sek 17 wait");
  printf("Wyborcy zakonczyli prace\n");  
}

void zakoncz_prace(int sig)
/* Funkcja wywolywana na koncu programu albo przy przerwaniu przez uzytkownika.
 * Robi porzadki. */
{
  zakoncz_wyborcow(n);
  zwolnij_zasoby(&wyborcy, &kol_zgloszen, &kol_do_sekretarza, &kol_do_wyborcow, 1);
  printf("\nProgram zakonczyl prace\n");
  exit(0);
}

int main(int argc, char **argv)
{
  int quorum, i, il_zgloszonych;
  int wyborow_do_przeprowadzenia;
  int wybrany, poprzedni;

  if(argc != 2)
    fatal("Zla liczba parametrow\n");
  if(sscanf(argv[1],"%d",&n) == -1)
    fatal("Niepoprawne parametry\n");
  wyborow_do_przeprowadzenia = ILE_WYB;
  quorum = QUORUM(n);
  printf("%d wyborcow, quorum: %d\n", n, quorum);
  poprzedni = 0;
  stworz_wyborcow(n);
  zarezerwuj_zasoby(n, &wyborcy, &kol_zgloszen, &kol_do_sekretarza,
                    &kol_do_wyborcow, zakoncz_prace);
  /* Inicjalnie zbior wyborcow bedzie zawieral wszystkich. */
  wyborcy[0] = n;
  for(i=1;i<=n;i++)
    wyborcy[i] = i;
  while(wyborow_do_przeprowadzenia > 0){
    oglos_wybory(wyborcy, kol_do_wyborcow);
    il_zgloszonych = zbieraj_zgloszenia(n, wyborcy, kol_zgloszen);
    if(il_zgloszonych >= quorum)
      if((wybrany = wybory(n, wyborcy, kol_do_sekretarza, kol_do_wyborcow)) > 0){
        if(wybrany == poprzedni)
          wyborow_do_przeprowadzenia--;
        else
          wyborow_do_przeprowadzenia = ILE_WYB - 1;
        poprzedni = wybrany;
      }
  }
  printf("\nKoniec wyborow, wygral %d\n\n",wybrany);
  zakoncz_prace(0);
  return 0;
}
