/* Patryk Czarnik */

/* Definicje funkcji z pliku FIBB.H */
#include <stdio.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/wait.h>
#include "err.h"
#include "fibb.h"

void wypiszWynik(long int wynik)
 {
  fprintf(stderr,"\nWynik:  %ld\n",wynik);
 }

void wywolajPodproces(long int numer, long int argument,
                      long int wynik, int odDziadka)
 {
  int fdSyn[2], fdWnuk[2];  /* tablice deskryptorow - parametry pipe() */
  char napis_arg[12], napis_nr[12], napis_lacze1[8], napis_lacze2[8];

  /* Tworze lacza do komunikacji z synem i wnukiem */
  if(pipe(fdSyn) == -1) syserr("3_1 pipe\n");
  if(pipe(fdWnuk) == -1) syserr("3_2 pipe\n");
  
  switch(fork())
    {
     case -1:
       syserr("3_3 fork\n");
     case 0:
       {
         /* Jestem w procesie potomnym */
	 /* Zmiana standardowego wejscia na lacze od ojca */          
         if(close(0) == -1) syserr("3_4 close\n");
	 if(dup(fdSyn[0]) != 0) syserr("3_5 dup\n");
         if(close(fdSyn[0]) == -1) syserr("3_6 close\n");
	 
	 /* Zamkniecie wyjscia */
	 if(close(fdSyn[1]) == -1) syserr("3_7 close\n");
	 
	 /* W fdWnuk znajduja sie deskryptory lacza, do ktorego proces *
	 *  pierwotny bedzie zapisywal czesciowy wynik dla wnuka.      */
	 /* Zamykam deskryptor do pisania */
	 if(close(fdWnuk[1]) == -1) syserr("3_8 close\n");
	 
         /* Przygotowuje parametry wywolania programu */
         sprintf(napis_nr,"%ld",numer);
	 sprintf(napis_arg,"%ld",argument);
	 sprintf(napis_lacze1,"%d",odDziadka); /* przekazuje lacze od dziadka */
	 sprintf(napis_lacze2,"%d",fdWnuk[0]);
	 execl("./fibb_synek","fibb_synek",napis_nr,napis_arg,napis_lacze1,napis_lacze2,NULL);
	 syserr("3_9 exec\n");
       }
     default:
       {
         /* Jestem w procesie macierzystym */
         /* Zmiana standardowego wyjscia na lacze do syna */
         if(close(1) == -1) syserr("3_10 close\n");
	 if(dup(fdSyn[1]) != 1) syserr("3_11 dup\n");
         if(close(fdSyn[1]) == -1) syserr("3_12 close\n");
	 
	 /* Zamkniecie wszystkich wejsc z laczy */
	 if(close(fdSyn[0]) == -1) syserr("3_13 close\n");
	 if(close(fdWnuk[0]) == -1) syserr("3_14 close\n");
	 if(close(odDziadka) == -1) syserr("3_15 close\n");
	 
	 /* Wynik czesciowy do syna przedefiniowanym standardowym wyjsciem */
	 if(write(1,&wynik,sizeof(wynik)) == -1)
	   syserr("3_17 write\n");
           
         /* Wynik czesciowy do wnuka */
	 if(write(fdWnuk[1],&wynik,sizeof(wynik)) == -1)
	   syserr("3_16 write\n");
	 
	 /* Czekam na zakonczenie pracy syna (a wiec i wnuka) */
	 if(wait(0) == -1) syserr("3_18 wait\n");
	 
	 /* Zamkniecie otwartych laczy */
	 if(close(1) == -1) syserr("3_19 close\n");
	 if(close(fdWnuk[1]) == -1) syserr("3_20 close\n");
       }
    }
 }
