/* Patryk Czarnik */

#include <stdio.h>
#include <unistd.h>
#include "err.h"
#include "fibb.h"


int main(int argc, char **argv)
 {
  long int argument, wynik;
  int fdNaNiby[2];
  
  if(argc != 2)
    fprintf(stderr,"Program nalezy wywolywac z jednym parametrem n - policzona zostanie liczba F(n).\n");
  else
    {
      sscanf(argv[1],"%ld",&argument);
      switch(argument)
       {
        case 0:
          {wypiszWynik(1); break;}
        case 1:
          {wypiszWynik(1); break;}
        default:
          {
            if(pipe(fdNaNiby) == -1) syserr("1_1 pipe\n");
	 /* W fdNaNiby znajduja sie deksryptory lacza, ktore proces potomny *
	  * ma potraktowac jak lacze od dziadka (chociaz jego dziadek nie   *
	  * istnieje). Wpisze tam 1 jako wynik F(0).                        */
            wynik=1;
            if(write(fdNaNiby[1],&wynik,sizeof(wynik)) == -1)
              syserr("1_2 write\n");

          /* Wywoluje podproces, po jego zakonczeniu zamykam lacze NaNiby */  
            wywolajPodproces(2,argument,1,fdNaNiby[0]);
            if(close(fdNaNiby[1]) == -1) syserr("1_3 close\n");
          } /* default */  
       } /* switch */
    }
  return 0;  
 } /* main */
