import logging
import os
import subprocess
import time
import signal

from fulp_compare import fulpdiff;

class Alarm(Exception):
    pass;

def alarm_handler(signum, frame):
    raise Alar

log = logging.getLogger("verifyprograms")

max_fulp_difference = 100
testtotal = 4
timelimit = 30

if __name__ == "__main__":

    logging.basicConfig(level=logging.DEBUG)
    sink = open('/dev/null', 'w')

    # --------------------------------------------------
    # TODO: put the directory with your source code here
    dirs = ['xx123456']
    # --------------------------------------------------

    with  open('results.csv', 'a') as results_stat:
        for subdir in dirs:
            error_count = 0
            os.chdir(subdir)
            log.info("dir: %s" % subdir)
            results_stat.write("\n"+subdir+",")

            retcode = subprocess.call(("ant", "clean"), stdout=sink, stderr=sink)
            if retcode != 0:
                log.error("ant clean doesn't compile")
                continue
            retcode = subprocess.call(("ant", "verify"), stdout=sink, stderr=sink)
            if retcode != 0:
                log.error("ant doesn't compile")
                continue

            for testcount in range(1, testtotal):
                results_stat.flush()
                log.info("test %d" % testcount)
                infilename = "../tests/%d" % testcount
                refresult = []

                with open("../res/%d/part-00000" % testcount) as result_file:
                    for line in result_file:
                        if line.strip():
                            refresult.append(line)

                signal.signal(signal.SIGALRM, alarm_handler)
                signal.alarm(timelimit)
                child = None

                try:
                    child = subprocess.Popen(("./verify.sh", "20", "0.8", "0", "../tests/"+str(testcount), "res/"+str(testcount)), stdout=sink, stderr = sink)
                    outcode = child.wait()
                    signal.alarm(0)
                    log.info("subprocess finished")
                    if outcode != 0:
                        log.error("non-0 exit code")
                        error_count += len(refresult)
                        results_stat.write(str(len(refresult))+", ")
                        continue
                except Alarm:
                    log.error("timeout!")
                    if child != None:
                        log.info("killing the child")
                        child.kill()
                        log.info("child killed")
                    error_count += len(refresult)
                    results_stat.write(str(len(refresult))+", ")
                    continue

                progresult = []
                with open("res/"+str(testcount)+"/part-00000") as progresult_file:
                    for line in progresult_file:
                        if line.strip():
                            progresult.append(line)

                if len(progresult) != len(refresult):
                    log.error("progresult has different length; expected %d progresult %d" % (len(refresult), len(progresult)))
                    results_stat.write(str(len(refresult))+", ")
                    error_count += len(refresult)
                    continue

                combresults = zip(refresult, progresult)
                test_error_count = 0
                for (i, (ref, prog)) in enumerate(combresults):
                    (ref_id, ref_val) = ref.split()
                    (prog_id, prog_val) = prog.split()
                    if (ref_id != prog_id):
                        log.error("different vertex id for line %d expected %s progresult %s" % (i, ref_id, prog_id))
                        test_error_count += 1
                        continue
                    f_ref = float(ref_val)
                    f_prog = float(prog_val)
                    fulp_diff = fulpdiff(f_ref, f_prog)
                    if (f_ref > 10e-4 and fulp_diff > max_fulp_difference) or (f_ref < 10e-4 and f_prog > 10e-4):
                        log.error("different results for line %d expected %s progresult %s fulps %d" % (i, ref, prog, fulp_diff))
                        test_error_count += 1
                results_stat.write(str(test_error_count)+", ")
                error_count += test_error_count

            log.info("subdir %s errors %d" % (subdir, error_count))
            os.chdir("../")
        results_stat.write("\n")

