#!/bin/python
import os

host_file = "./hosts"
first_port = 35000

if __name__ == '__main__':
    with open(host_file) as host_f:
        hosts = host_f.read()
    master = hosts.split("\n")[0]

    with open("conf/slaves", "w") as slave_f:
        slave_f.write(hosts)

    hadoop_port = first_port + os.getuid();
    print "base port: "+str(hadoop_port)

    content = """<?xml version="1.0"?>
<?xml-stylesheet type="text/xsl" href="configuration.xsl"?>
<configuration>
<property>
<name>fs.default.name</name>
<value>hdfs://"""+master+":"+str(hadoop_port)+"""</value>
</property>
</configuration>"""
    with open("conf/core-site.xml", "w") as core_f:
        core_f.write(content)

    mapred_content = """<?xml version="1.0"?>
<?xml-stylesheet type="text/xsl" href="configuration.xsl"?>
<configuration>
<property>
<name>mapred.job.tracker</name>
<value>"""+str(master)+":"+str(hadoop_port+10)+"""</value>
</property>
<property>
<name>mapred.task.tracker.http.address</name>
<value>0.0.0.0:"""+str(hadoop_port+20)+"""</value>
</property>
<property>
<name>mapred.job.tracker.http.address</name>
<value>0.0.0.0:"""+str(hadoop_port+30)+"""</value>
</property>


</configuration>"""
    with open("conf/mapred-site.xml", "w") as mapred_f:
        mapred_f.write(mapred_content)
    print "jobtracker: http://"+str(master)+":"+str(hadoop_port+30)
        
    hdfs_content = """<?xml version="1.0"?>
<?xml-stylesheet type="text/xsl" href="configuration.xsl"?>
<configuration>
<property>
<name>dfs.replication</name>
<value>1</value>
</property>
<property>
<name>dfs.http.address</name>
<value>0.0.0.0:"""+str(hadoop_port+40)+"""</value>
</property>
<property>
<name>dfs.datanode.address</name>
<value>0.0.0.0:"""+str(hadoop_port+50)+"""</value>
</property>
<property>
<name>dfs.datanode.ipc.address</name>
<value>0.0.0.0:"""+str(hadoop_port+60)+"""</value>
</property>
<property>
<name>dfs.datanode.http.address</name>
<value>0.0.0.0:"""+str(hadoop_port+70)+"""</value>
</property>
<property>
<name>dfs.namenode.http-address</name>
<value>0.0.0.0:"""+str(hadoop_port+80)+"""</value>
</property>
</configuration>"""
    with open("conf/hdfs-site.xml", "w") as hdfs_f:
        hdfs_f.write(hdfs_content)
    print "namenode: http://"+str(master)+":"+str(hadoop_port+40)
        
    print("configuration done")
    print("remember to format hdfs:\nbin/hadoop namenode -format")
