/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.IOException;
import java.util.Collection;
import org.apache.hadoop.mapred.ClusterStatus;
import org.apache.hadoop.mapred.FairScheduler;
import org.apache.hadoop.mapred.JobInProgress;
import org.apache.hadoop.mapred.JobPriority;
import org.apache.hadoop.mapred.LoadManager;
import org.apache.hadoop.mapred.LocalityLevel;
import org.apache.hadoop.mapred.Schedulable;
import org.apache.hadoop.mapred.Task;
import org.apache.hadoop.mapred.TaskInProgress;
import org.apache.hadoop.mapred.TaskTrackerManager;
import org.apache.hadoop.mapred.TaskTrackerStatus;
import org.apache.hadoop.mapreduce.TaskType;

public class JobSchedulable
extends Schedulable {
    protected FairScheduler scheduler;
    protected JobInProgress job;
    protected TaskType taskType;
    private int demand = 0;

    public JobSchedulable(FairScheduler scheduler, JobInProgress job, TaskType taskType) {
        this.scheduler = scheduler;
        this.job = job;
        this.taskType = taskType;
        this.initMetrics();
    }

    public JobSchedulable() {
    }

    public void init(FairScheduler scheduler, JobInProgress job, TaskType taskType) {
        this.scheduler = scheduler;
        this.job = job;
        this.taskType = taskType;
        this.initMetrics();
    }

    @Override
    public TaskType getTaskType() {
        return this.taskType;
    }

    @Override
    public String getName() {
        return this.job.getJobID().toString();
    }

    public JobInProgress getJob() {
        return this.job;
    }

    @Override
    public void updateDemand() {
        this.demand = 0;
        if (this.isRunnable()) {
            if (this.taskType == TaskType.REDUCE && !this.job.scheduleReduces()) {
                return;
            }
            TaskInProgress[] tips = this.taskType == TaskType.MAP ? this.job.getTasks(TaskType.MAP) : this.job.getTasks(TaskType.REDUCE);
            boolean speculationEnabled = this.taskType == TaskType.MAP ? this.job.getMapSpeculativeExecution() : this.job.getReduceSpeculativeExecution();
            double avgProgress = this.taskType == TaskType.MAP ? this.job.getStatus().mapProgress() : this.job.getStatus().reduceProgress();
            long time = this.scheduler.getClock().getTime();
            for (TaskInProgress tip : tips) {
                if (tip.isComplete()) continue;
                if (tip.isRunning()) {
                    this.demand += tip.getActiveTasks().size();
                    if (!speculationEnabled || !tip.hasSpeculativeTask(time, avgProgress)) continue;
                    ++this.demand;
                    continue;
                }
                ++this.demand;
            }
        }
    }

    protected boolean isRunnable() {
        FairScheduler.JobInfo info = this.scheduler.getJobInfo(this.job);
        int runState = this.job.getStatus().getRunState();
        return info != null && info.runnable && runState == 1;
    }

    @Override
    public int getDemand() {
        return this.demand;
    }

    @Override
    public void redistributeShare() {
    }

    @Override
    public JobPriority getPriority() {
        return this.job.getPriority();
    }

    @Override
    public int getRunningTasks() {
        if (!this.job.inited()) {
            return 0;
        }
        return this.taskType == TaskType.MAP ? this.job.runningMaps() : this.job.runningReduces();
    }

    @Override
    public long getStartTime() {
        return this.job.startTime;
    }

    @Override
    public double getWeight() {
        return this.scheduler.getJobWeight(this.job, this.taskType);
    }

    @Override
    public int getMinShare() {
        return 0;
    }

    @Override
    public Task assignTask(TaskTrackerStatus tts, long currentTime, Collection<JobInProgress> visited) throws IOException {
        if (this.isRunnable()) {
            visited.add(this.job);
            TaskTrackerManager ttm = this.scheduler.taskTrackerManager;
            ClusterStatus clusterStatus = ttm.getClusterStatus();
            int numTaskTrackers = clusterStatus.getTaskTrackers();
            LoadManager loadMgr = this.scheduler.getLoadManager();
            if (!loadMgr.canLaunchTask(tts, this.job, this.taskType)) {
                return null;
            }
            if (this.taskType == TaskType.MAP) {
                LocalityLevel localityLevel = this.scheduler.getAllowedLocalityLevel(this.job, currentTime);
                this.scheduler.getEventLog().log("ALLOWED_LOC_LEVEL", new Object[]{this.job.getJobID(), localityLevel});
                switch (localityLevel) {
                    case NODE: {
                        return this.job.obtainNewNodeLocalMapTask(tts, numTaskTrackers, ttm.getNumberOfUniqueHosts());
                    }
                    case RACK: {
                        return this.job.obtainNewNodeOrRackLocalMapTask(tts, numTaskTrackers, ttm.getNumberOfUniqueHosts());
                    }
                }
                return this.job.obtainNewMapTask(tts, numTaskTrackers, ttm.getNumberOfUniqueHosts());
            }
            return this.job.obtainNewReduceTask(tts, numTaskTrackers, ttm.getNumberOfUniqueHosts());
        }
        return null;
    }

    @Override
    protected String getMetricsContextName() {
        return "jobs";
    }

    @Override
    void updateMetrics() {
        assert (this.metrics != null);
        super.setMetricValues(this.metrics);
        this.metrics.update();
    }
}

