/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapred.JobInProgress;
import org.apache.hadoop.mapred.LoadManager;
import org.apache.hadoop.mapred.TaskTrackerStatus;
import org.apache.hadoop.mapreduce.TaskType;

public class CapBasedLoadManager
extends LoadManager {
    float maxDiff = 0.0f;

    @Override
    public void setConf(Configuration conf) {
        super.setConf(conf);
        this.maxDiff = conf.getFloat("mapred.fairscheduler.load.max.diff", 0.0f);
    }

    int getCap(int totalRunnableTasks, int localMaxTasks, int totalSlots) {
        double load = (double)this.maxDiff + (double)totalRunnableTasks / (double)totalSlots;
        return (int)Math.ceil((double)localMaxTasks * Math.min(1.0, load));
    }

    @Override
    public boolean canAssignMap(TaskTrackerStatus tracker, int totalRunnableMaps, int totalMapSlots, int alreadyAssigned) {
        int cap = this.getCap(totalRunnableMaps, tracker.getMaxMapSlots(), totalMapSlots);
        return tracker.countMapTasks() + alreadyAssigned < cap;
    }

    @Override
    public boolean canAssignReduce(TaskTrackerStatus tracker, int totalRunnableReduces, int totalReduceSlots, int alreadyAssigned) {
        int cap = this.getCap(totalRunnableReduces, tracker.getMaxReduceSlots(), totalReduceSlots);
        return tracker.countReduceTasks() + alreadyAssigned < cap;
    }

    @Override
    public boolean canLaunchTask(TaskTrackerStatus tracker, JobInProgress job, TaskType type) {
        return true;
    }
}

