/*
 * Decompiled with CFR 0.152.
 */
package org.vafer.jdeb.signing;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.Security;
import java.security.SignatureException;
import java.util.Iterator;
import org.bouncycastle.bcpg.ArmoredOutputStream;
import org.bouncycastle.bcpg.BCPGOutputStream;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPrivateKey;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.openpgp.PGPSecretKeyRingCollection;
import org.bouncycastle.openpgp.PGPSignatureGenerator;
import org.bouncycastle.openpgp.PGPUtil;

public final class SigningUtils {
    private static PGPSecretKey getSecretKey(InputStream pInput, String pKey) throws IOException, PGPException {
        PGPSecretKeyRingCollection pgpSec = new PGPSecretKeyRingCollection(PGPUtil.getDecoderStream((InputStream)pInput));
        Iterator rIt = pgpSec.getKeyRings();
        while (rIt.hasNext()) {
            PGPSecretKeyRing kRing = (PGPSecretKeyRing)rIt.next();
            Iterator kIt = kRing.getSecretKeys();
            while (kIt.hasNext()) {
                PGPSecretKey k = (PGPSecretKey)kIt.next();
                if (!k.isSigningKey() || !Long.toHexString(k.getKeyID() & 0xFFFFFFFFL).equals(pKey.toLowerCase())) continue;
                return k;
            }
        }
        return null;
    }

    public static void clearSign(InputStream pInput, InputStream pKeyring, String pKey, String pPassphrase, OutputStream pOutput) throws IOException, PGPException, NoSuchProviderException, NoSuchAlgorithmException, SignatureException {
        Security.addProvider((Provider)new BouncyCastleProvider());
        PGPSecretKey secretKey = SigningUtils.getSecretKey(pKeyring, pKey);
        PGPPrivateKey privateKey = secretKey.extractPrivateKey(pPassphrase.toCharArray(), "BC");
        int digest = 2;
        PGPSignatureGenerator signatureGenerator = new PGPSignatureGenerator(secretKey.getPublicKey().getAlgorithm(), 2, "BC");
        signatureGenerator.initSign(1, privateKey);
        ArmoredOutputStream armoredOutput = new ArmoredOutputStream(pOutput);
        armoredOutput.beginClearText(2);
        BufferedReader reader = new BufferedReader(new InputStreamReader(pInput));
        byte[] newline = "\r\n".getBytes("UTF-8");
        SigningUtils.processLine(reader.readLine(), armoredOutput, signatureGenerator);
        while (true) {
            String line;
            if ((line = reader.readLine()) == null) break;
            armoredOutput.write(newline);
            signatureGenerator.update(newline);
            SigningUtils.processLine(line, armoredOutput, signatureGenerator);
        }
        armoredOutput.write(newline);
        armoredOutput.endClearText();
        BCPGOutputStream pgpOutput = new BCPGOutputStream((OutputStream)armoredOutput);
        signatureGenerator.generate().encode((OutputStream)pgpOutput);
        armoredOutput.close();
    }

    private static void processLine(String pLine, ArmoredOutputStream pArmoredOutput, PGPSignatureGenerator pSignatureGenerator) throws IOException, SignatureException {
        int len;
        if (pLine == null) {
            return;
        }
        char[] chars = pLine.toCharArray();
        for (len = chars.length; len > 0 && Character.isWhitespace(chars[len - 1]); --len) {
        }
        byte[] data = pLine.substring(0, len).getBytes("UTF-8");
        pArmoredOutput.write(data);
        pSignatureGenerator.update(data);
    }
}

