/*
 * Decompiled with CFR 0.152.
 */
package org.vafer.jdeb.shaded.compress.compress.archivers.tar;

public class TarUtils {
    private static final int BYTE_MASK = 255;

    private TarUtils() {
    }

    public static long parseOctal(byte[] buffer, int offset, int length) {
        byte currentByte;
        long result = 0L;
        boolean stillPadding = true;
        int end = offset + length;
        for (int i = offset; i < end && (currentByte = buffer[i]) != 0; ++i) {
            if (currentByte == 32 || currentByte == 48) {
                if (stillPadding) continue;
                if (currentByte == 32) break;
            }
            stillPadding = false;
            if (currentByte < 48 || currentByte > 55) {
                throw new IllegalArgumentException("Invalid octal digit at position " + i + " in '" + new String(buffer, offset, length) + "'");
            }
            result = (result << 3) + (long)(currentByte - 48);
        }
        return result;
    }

    public static String parseName(byte[] buffer, int offset, int length) {
        StringBuffer result = new StringBuffer(length);
        int end = offset + length;
        for (int i = offset; i < end && buffer[i] != 0; ++i) {
            result.append((char)buffer[i]);
        }
        return result.toString();
    }

    public static int formatNameBytes(String name, byte[] buf, int offset, int length) {
        int i;
        for (i = 0; i < length && i < name.length(); ++i) {
            buf[offset + i] = (byte)name.charAt(i);
        }
        while (i < length) {
            buf[offset + i] = 0;
            ++i;
        }
        return offset + length;
    }

    public static void formatUnsignedOctalString(long value, byte[] buffer, int offset, int length) {
        int remaining = length;
        --remaining;
        if (value == 0L) {
            buffer[offset + remaining--] = 48;
        } else {
            long val;
            for (val = value; remaining >= 0 && val != 0L; val >>>= 3, --remaining) {
                buffer[offset + remaining] = (byte)(48 + (byte)(val & 7L));
            }
            if (val != 0L) {
                throw new IllegalArgumentException(value + "=" + Long.toOctalString(value) + " will not fit in octal number buffer of length " + length);
            }
        }
        while (remaining >= 0) {
            buffer[offset + remaining] = 48;
            --remaining;
        }
    }

    public static int formatOctalBytes(long value, byte[] buf, int offset, int length) {
        int idx = length - 2;
        TarUtils.formatUnsignedOctalString(value, buf, offset, idx);
        buf[offset + idx++] = 32;
        buf[offset + idx] = 0;
        return offset + length;
    }

    public static int formatLongOctalBytes(long value, byte[] buf, int offset, int length) {
        int idx = length - 1;
        TarUtils.formatUnsignedOctalString(value, buf, offset, idx);
        buf[offset + idx] = 32;
        return offset + length;
    }

    public static int formatCheckSumOctalBytes(long value, byte[] buf, int offset, int length) {
        int idx = length - 2;
        TarUtils.formatUnsignedOctalString(value, buf, offset, idx);
        buf[offset + idx++] = 0;
        buf[offset + idx] = 32;
        return offset + length;
    }

    public static long computeCheckSum(byte[] buf) {
        long sum = 0L;
        for (int i = 0; i < buf.length; ++i) {
            sum += (long)(0xFF & buf[i]);
        }
        return sum;
    }
}

