/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.contrib.index.mapred;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.StringTokenizer;
import org.apache.hadoop.contrib.index.mapred.IndexUpdateConfiguration;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.WritableComparable;

public class Shard
implements WritableComparable {
    private long version;
    private String dir;
    private long gen;

    public static String normalizePath(String path) {
        path = path.replace("//", "/");
        if ((path = path.replace("\\", "/")).length() > 1 && path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        return path;
    }

    public static void setIndexShards(IndexUpdateConfiguration conf, Shard[] shards) {
        StringBuilder shardsString = new StringBuilder(shards[0].toString());
        for (int i = 1; i < shards.length; ++i) {
            shardsString.append(",");
            shardsString.append(shards[i].toString());
        }
        conf.setIndexShards(shardsString.toString());
    }

    public static Shard[] getIndexShards(IndexUpdateConfiguration conf) {
        String shards = conf.getIndexShards();
        if (shards != null) {
            ArrayList<Object> list = Collections.list(new StringTokenizer(shards, ","));
            Shard[] result = new Shard[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                result[i] = Shard.createShardFromString((String)list.get(i));
            }
            return result;
        }
        return null;
    }

    private static Shard createShardFromString(String str) {
        int first = str.indexOf("@");
        int second = str.indexOf("@", first + 1);
        long version = Long.parseLong(str.substring(0, first));
        String dir = str.substring(first + 1, second);
        long gen = Long.parseLong(str.substring(second + 1));
        return new Shard(version, dir, gen);
    }

    public Shard() {
        this.version = -1L;
        this.dir = null;
        this.gen = -1L;
    }

    public Shard(long version, String dir, long gen) {
        this.version = version;
        this.dir = Shard.normalizePath(dir);
        this.gen = gen;
    }

    public Shard(Shard shard) {
        this.version = shard.version;
        this.dir = shard.dir;
        this.gen = shard.gen;
    }

    public long getVersion() {
        return this.version;
    }

    public String getDirectory() {
        return this.dir;
    }

    public long getGeneration() {
        return this.gen;
    }

    public String toString() {
        return this.version + "@" + this.dir + "@" + this.gen;
    }

    public void write(DataOutput out) throws IOException {
        out.writeLong(this.version);
        Text.writeString((DataOutput)out, (String)this.dir);
        out.writeLong(this.gen);
    }

    public void readFields(DataInput in) throws IOException {
        this.version = in.readLong();
        this.dir = Text.readString((DataInput)in);
        this.gen = in.readLong();
    }

    public int compareTo(Object o) {
        return this.compareTo((Shard)o);
    }

    public int compareTo(Shard other) {
        if (this.version < other.version) {
            return -1;
        }
        if (this.version > other.version) {
            return 1;
        }
        int result = this.dir.compareTo(other.dir);
        if (result != 0) {
            return result;
        }
        if (this.gen < other.gen) {
            return -1;
        }
        if (this.gen == other.gen) {
            return 0;
        }
        return 1;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Shard)) {
            return false;
        }
        Shard other = (Shard)o;
        return this.version == other.version && this.dir.equals(other.dir) && this.gen == other.gen;
    }

    public int hashCode() {
        return (int)this.version ^ this.dir.hashCode() ^ (int)this.gen;
    }
}

