/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.contrib.index.mapred;

import java.io.IOException;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.contrib.index.lucene.ShardWriter;
import org.apache.hadoop.contrib.index.mapred.IndexUpdateConfiguration;
import org.apache.hadoop.contrib.index.mapred.IntermediateForm;
import org.apache.hadoop.contrib.index.mapred.Shard;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.io.Closeable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.MapReduceBase;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.Reducer;
import org.apache.hadoop.mapred.Reporter;

public class IndexUpdateReducer
extends MapReduceBase
implements Reducer<Shard, IntermediateForm, Shard, Text> {
    static final Log LOG = LogFactory.getLog(IndexUpdateReducer.class);
    static final Text DONE = new Text("done");
    private IndexUpdateConfiguration iconf;
    private String mapredTempDir;

    public static Class<? extends WritableComparable> getOutputKeyClass() {
        return Shard.class;
    }

    public static Class<? extends Writable> getOutputValueClass() {
        return Text.class;
    }

    public void reduce(Shard key, Iterator<IntermediateForm> values, OutputCollector<Shard, Text> output, Reporter reporter) throws IOException {
        LOG.info((Object)("Construct a shard writer for " + key));
        FileSystem fs = FileSystem.get((Configuration)this.iconf.getConfiguration());
        String temp = this.mapredTempDir + "/" + "shard_" + System.currentTimeMillis();
        final ShardWriter writer = new ShardWriter(fs, key, temp, this.iconf);
        while (values.hasNext()) {
            IntermediateForm form = values.next();
            writer.process(form);
            reporter.progress();
        }
        final Reporter fReporter = reporter;
        new Closeable(){
            volatile boolean closed = false;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void close() throws IOException {
                Thread prog = new Thread(){

                    @Override
                    public void run() {
                        while (!closed) {
                            try {
                                fReporter.setStatus("closing");
                                Thread.sleep(1000L);
                            }
                            catch (InterruptedException e) {
                            }
                            catch (Throwable e) {
                                return;
                            }
                        }
                    }
                };
                try {
                    prog.start();
                    if (writer != null) {
                        writer.close();
                    }
                }
                finally {
                    this.closed = true;
                }
            }
        }.close();
        LOG.info((Object)("Closed the shard writer for " + key + ", writer = " + writer));
        output.collect((Object)key, (Object)DONE);
    }

    public void configure(JobConf job) {
        this.iconf = new IndexUpdateConfiguration((Configuration)job);
        this.mapredTempDir = this.iconf.getMapredTempDir();
        this.mapredTempDir = Shard.normalizePath(this.mapredTempDir);
    }

    public void close() throws IOException {
    }
}

