/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.contrib.index.mapred;

import java.io.IOException;
import org.apache.hadoop.contrib.index.mapred.IndexUpdateReducer;
import org.apache.hadoop.contrib.index.mapred.Shard;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordWriter;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.util.Progressable;

public class IndexUpdateOutputFormat
extends FileOutputFormat<Shard, Text> {
    public RecordWriter<Shard, Text> getRecordWriter(final FileSystem fs, JobConf job, String name, Progressable progress) throws IOException {
        final Path perm = new Path(IndexUpdateOutputFormat.getWorkOutputPath((JobConf)job), name);
        return new RecordWriter<Shard, Text>(){

            public void write(Shard key, Text value) throws IOException {
                assert (IndexUpdateReducer.DONE.equals((Object)value));
                String shardName = key.getDirectory();
                shardName = shardName.replace("/", "_");
                Path doneFile = new Path(perm, IndexUpdateReducer.DONE + "_" + shardName);
                if (!fs.exists(doneFile)) {
                    fs.createNewFile(doneFile);
                }
            }

            public void close(Reporter reporter) throws IOException {
            }
        };
    }
}

