/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.contrib.index.mapred;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.contrib.index.mapred.DocumentAndOp;
import org.apache.hadoop.contrib.index.mapred.DocumentID;
import org.apache.hadoop.contrib.index.mapred.IDistributionPolicy;
import org.apache.hadoop.contrib.index.mapred.ILocalAnalysis;
import org.apache.hadoop.contrib.index.mapred.IndexUpdateConfiguration;
import org.apache.hadoop.contrib.index.mapred.IntermediateForm;
import org.apache.hadoop.contrib.index.mapred.Shard;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.MapReduceBase;
import org.apache.hadoop.mapred.Mapper;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.lucene.analysis.Analyzer;

public class IndexUpdateMapper<K extends WritableComparable, V extends Writable>
extends MapReduceBase
implements Mapper<K, V, Shard, IntermediateForm> {
    static final Log LOG = LogFactory.getLog(IndexUpdateMapper.class);
    IndexUpdateConfiguration iconf;
    private Analyzer analyzer;
    private Shard[] shards;
    private IDistributionPolicy distributionPolicy;
    private ILocalAnalysis<K, V> localAnalysis;
    private DocumentID tmpKey;
    private DocumentAndOp tmpValue;
    private OutputCollector<DocumentID, DocumentAndOp> tmpCollector = new OutputCollector<DocumentID, DocumentAndOp>(){

        public void collect(DocumentID key, DocumentAndOp value) throws IOException {
            IndexUpdateMapper.this.tmpKey = key;
            IndexUpdateMapper.this.tmpValue = value;
        }
    };

    public static Class<? extends WritableComparable> getMapOutputKeyClass() {
        return Shard.class;
    }

    public static Class<? extends Writable> getMapOutputValueClass() {
        return IntermediateForm.class;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void map(K key, V value, OutputCollector<Shard, IntermediateForm> output, Reporter reporter) throws IOException {
        IndexUpdateMapper indexUpdateMapper = this;
        synchronized (indexUpdateMapper) {
            this.localAnalysis.map(key, value, this.tmpCollector, reporter);
            if (this.tmpKey == null || this.tmpValue == null) return;
            DocumentAndOp doc = this.tmpValue;
            IntermediateForm form = new IntermediateForm();
            form.configure(this.iconf);
            form.process(doc, this.analyzer);
            form.closeWriter();
            if (doc.getOp() == DocumentAndOp.Op.INSERT) {
                int chosenShard = this.distributionPolicy.chooseShardForInsert(this.tmpKey);
                if (chosenShard < 0) throw new IOException("Chosen shard for insert must be >= 0");
                output.collect((Object)this.shards[chosenShard], (Object)form);
            } else if (doc.getOp() == DocumentAndOp.Op.DELETE) {
                int chosenShard = this.distributionPolicy.chooseShardForDelete(this.tmpKey);
                if (chosenShard >= 0) {
                    output.collect((Object)this.shards[chosenShard], (Object)form);
                } else {
                    for (int i = 0; i < this.shards.length; ++i) {
                        output.collect((Object)this.shards[i], (Object)form);
                    }
                }
            } else {
                int insertToShard = this.distributionPolicy.chooseShardForInsert(this.tmpKey);
                int deleteFromShard = this.distributionPolicy.chooseShardForDelete(this.tmpKey);
                if (insertToShard < 0) throw new IOException("Chosen shard for insert must be >= 0");
                if (insertToShard == deleteFromShard) {
                    output.collect((Object)this.shards[insertToShard], (Object)form);
                } else {
                    IntermediateForm deletionForm = new IntermediateForm();
                    deletionForm.configure(this.iconf);
                    deletionForm.process(new DocumentAndOp(DocumentAndOp.Op.DELETE, doc.getTerm()), this.analyzer);
                    deletionForm.closeWriter();
                    if (deleteFromShard >= 0) {
                        output.collect((Object)this.shards[deleteFromShard], (Object)deletionForm);
                    } else {
                        for (int i = 0; i < this.shards.length; ++i) {
                            output.collect((Object)this.shards[i], (Object)deletionForm);
                        }
                    }
                    IntermediateForm insertionForm = new IntermediateForm();
                    insertionForm.configure(this.iconf);
                    insertionForm.process(new DocumentAndOp(DocumentAndOp.Op.INSERT, doc.getDocument()), this.analyzer);
                    insertionForm.closeWriter();
                    output.collect((Object)this.shards[insertToShard], (Object)insertionForm);
                }
            }
            return;
        }
    }

    public void configure(JobConf job) {
        this.iconf = new IndexUpdateConfiguration((Configuration)job);
        this.analyzer = (Analyzer)ReflectionUtils.newInstance(this.iconf.getDocumentAnalyzerClass(), (Configuration)job);
        this.localAnalysis = (ILocalAnalysis)ReflectionUtils.newInstance(this.iconf.getLocalAnalysisClass(), (Configuration)job);
        this.localAnalysis.configure(job);
        this.shards = Shard.getIndexShards(this.iconf);
        this.distributionPolicy = (IDistributionPolicy)ReflectionUtils.newInstance(this.iconf.getDistributionPolicyClass(), (Configuration)job);
        this.distributionPolicy.init(this.shards);
        LOG.info((Object)("sea.document.analyzer = " + this.analyzer.getClass().getName()));
        LOG.info((Object)("sea.local.analysis = " + this.localAnalysis.getClass().getName()));
        LOG.info((Object)(this.shards.length + " shards = " + this.iconf.getIndexShards()));
        LOG.info((Object)("sea.distribution.policy = " + this.distributionPolicy.getClass().getName()));
    }

    public void close() throws IOException {
        this.localAnalysis.close();
    }
}

