/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.contrib.index.mapred;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.contrib.index.example.HashingDistributionPolicy;
import org.apache.hadoop.contrib.index.example.LineDocInputFormat;
import org.apache.hadoop.contrib.index.example.LineDocLocalAnalysis;
import org.apache.hadoop.contrib.index.mapred.IDistributionPolicy;
import org.apache.hadoop.contrib.index.mapred.IIndexUpdater;
import org.apache.hadoop.contrib.index.mapred.ILocalAnalysis;
import org.apache.hadoop.contrib.index.mapred.IndexUpdater;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;

public class IndexUpdateConfiguration {
    final Configuration conf;

    public IndexUpdateConfiguration(Configuration conf) {
        this.conf = conf;
    }

    public Configuration getConfiguration() {
        return this.conf;
    }

    public int getIOSortMB() {
        return this.conf.getInt("io.sort.mb", 100);
    }

    public void setIOSortMB(int mb) {
        this.conf.setInt("io.sort.mb", mb);
    }

    public String getMapredTempDir() {
        return this.conf.get("mapred.temp.dir");
    }

    public Class<? extends IDistributionPolicy> getDistributionPolicyClass() {
        return this.conf.getClass("sea.distribution.policy", HashingDistributionPolicy.class, IDistributionPolicy.class);
    }

    public void setDistributionPolicyClass(Class<? extends IDistributionPolicy> theClass) {
        this.conf.setClass("sea.distribution.policy", theClass, IDistributionPolicy.class);
    }

    public Class<? extends Analyzer> getDocumentAnalyzerClass() {
        return this.conf.getClass("sea.document.analyzer", StandardAnalyzer.class, Analyzer.class);
    }

    public void setDocumentAnalyzerClass(Class<? extends Analyzer> theClass) {
        this.conf.setClass("sea.document.analyzer", theClass, Analyzer.class);
    }

    public Class<? extends InputFormat> getIndexInputFormatClass() {
        return this.conf.getClass("sea.input.format", LineDocInputFormat.class, InputFormat.class);
    }

    public void setIndexInputFormatClass(Class<? extends InputFormat> theClass) {
        this.conf.setClass("sea.input.format", theClass, InputFormat.class);
    }

    public Class<? extends IIndexUpdater> getIndexUpdaterClass() {
        return this.conf.getClass("sea.index.updater", IndexUpdater.class, IIndexUpdater.class);
    }

    public void setIndexUpdaterClass(Class<? extends IIndexUpdater> theClass) {
        this.conf.setClass("sea.index.updater", theClass, IIndexUpdater.class);
    }

    public Class<? extends ILocalAnalysis> getLocalAnalysisClass() {
        return this.conf.getClass("sea.local.analysis", LineDocLocalAnalysis.class, ILocalAnalysis.class);
    }

    public void setLocalAnalysisClass(Class<? extends ILocalAnalysis> theClass) {
        this.conf.setClass("sea.local.analysis", theClass, ILocalAnalysis.class);
    }

    public String getIndexShards() {
        return this.conf.get("sea.index.shards");
    }

    public void setIndexShards(String shards) {
        this.conf.set("sea.index.shards", shards);
    }

    public int getIndexMaxFieldLength() {
        return this.conf.getInt("sea.max.field.length", -1);
    }

    public void setIndexMaxFieldLength(int maxFieldLength) {
        this.conf.setInt("sea.max.field.length", maxFieldLength);
    }

    public int getIndexMaxNumSegments() {
        return this.conf.getInt("sea.max.num.segments", -1);
    }

    public void setIndexMaxNumSegments(int maxNumSegments) {
        this.conf.setInt("sea.max.num.segments", maxNumSegments);
    }

    public boolean getIndexUseCompoundFile() {
        return this.conf.getBoolean("sea.use.compound.file", false);
    }

    public void setIndexUseCompoundFile(boolean useCompoundFile) {
        this.conf.setBoolean("sea.use.compound.file", useCompoundFile);
    }
}

