/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.contrib.index.lucene;

import java.io.IOException;
import java.util.List;
import org.apache.lucene.index.IndexCommitPoint;
import org.apache.lucene.index.IndexDeletionPolicy;

class MixedDeletionPolicy
implements IndexDeletionPolicy {
    private int keepAllFromInit = 0;

    MixedDeletionPolicy() {
    }

    public void onInit(List commits) throws IOException {
        this.keepAllFromInit = commits.size();
    }

    public void onCommit(List commits) throws IOException {
        int size = commits.size();
        assert (size > this.keepAllFromInit);
        for (int i = this.keepAllFromInit; i < size - 1; ++i) {
            ((IndexCommitPoint)commits.get(i)).delete();
        }
    }
}

