/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.contrib.index.lucene;

import java.io.IOException;
import org.apache.lucene.store.Directory;

public final class LuceneUtil {
    public static boolean isSegmentsFile(String name) {
        return name.startsWith("segments") && !name.equals("segments.gen");
    }

    public static boolean isSegmentsGenFile(String name) {
        return name.equals("segments.gen");
    }

    public static long getCurrentSegmentGeneration(Directory directory) throws IOException {
        String[] files = directory.list();
        if (files == null) {
            throw new IOException("cannot read directory " + directory + ": list() returned null");
        }
        return LuceneUtil.getCurrentSegmentGeneration(files);
    }

    public static long getCurrentSegmentGeneration(String[] files) {
        if (files == null) {
            return -1L;
        }
        long max = -1L;
        for (int i = 0; i < files.length; ++i) {
            long gen;
            String file = files[i];
            if (!file.startsWith("segments") || file.equals("segments.gen") || (gen = LuceneUtil.generationFromSegmentsFileName(file)) <= max) continue;
            max = gen;
        }
        return max;
    }

    public static long generationFromSegmentsFileName(String fileName) {
        if (fileName.equals("segments")) {
            return 0L;
        }
        if (fileName.startsWith("segments")) {
            return Long.parseLong(fileName.substring(1 + "segments".length()), 36);
        }
        throw new IllegalArgumentException("fileName \"" + fileName + "\" is not a segments file");
    }

    static final class IndexFileNames {
        static final String SEGMENTS = "segments";
        static final String SEGMENTS_GEN = "segments.gen";

        IndexFileNames() {
        }
    }
}

