/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.contrib.index.example;

import org.apache.hadoop.contrib.index.mapred.DocumentID;
import org.apache.hadoop.contrib.index.mapred.IDistributionPolicy;
import org.apache.hadoop.contrib.index.mapred.Shard;

public class RoundRobinDistributionPolicy
implements IDistributionPolicy {
    private int numShards;
    private int rr;

    @Override
    public void init(Shard[] shards) {
        this.numShards = shards.length;
        this.rr = 0;
    }

    @Override
    public int chooseShardForInsert(DocumentID key) {
        int chosen = this.rr;
        this.rr = (this.rr + 1) % this.numShards;
        return chosen;
    }

    @Override
    public int chooseShardForDelete(DocumentID key) {
        return -1;
    }
}

